/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.train;

import java.util.ArrayList;
import java.util.List;
import tratz.parse.types.Arc;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectivityHandler {
    public static void traverse(Token t, List[] tokenToArcs, int[] projectiveIndices) {
        ProjectivityHandler.traverse(t, tokenToArcs, new IntHolderX(), projectiveIndices);
    }

    private static void traverse(Token t, List[] tokenToArcs, IntHolderX val, int[] projectiveIndices) {
        List arcs = tokenToArcs[t.getIndex()];
        ArrayList<Arc> preArcs = new ArrayList<Arc>();
        ArrayList<Arc> postArcs = new ArrayList<Arc>();
        if (arcs != null) {
            for (Arc arc : arcs) {
                if (arc.getChild().getIndex() < t.getIndex()) {
                    preArcs.add(arc);
                    continue;
                }
                postArcs.add(arc);
            }
        }
        for (Arc arc : preArcs) {
            ProjectivityHandler.traverse(arc.getChild(), tokenToArcs, val, projectiveIndices);
        }
        projectiveIndices[t.getIndex()] = ++val.x;
        for (Arc arc : postArcs) {
            ProjectivityHandler.traverse(arc.getChild(), tokenToArcs, val, projectiveIndices);
        }
    }

    public static boolean hasAllItsDependents(Token topOfStack, List<Arc> arcListFull, List<Arc> arcListWorking) {
        int numFull = arcListFull == null ? 0 : arcListFull.size();
        int numWorking = arcListWorking == null ? 0 : arcListWorking.size();
        return numFull == numWorking;
    }

    public static Arc getDependency(Token t1, Token t2, List<Arc> arcList) {
        Arc dep = null;
        if (arcList != null) {
            for (Arc arc : arcList) {
                if (arc.getChild() != t1 || arc.getHead() != t2) continue;
                dep = arc;
                break;
            }
        }
        return dep;
    }

    public static Token[] findSubcomponents(List<Token> tokens, List[] finalTokenToChildren) {
        Token[] subcomponentHeadMappings = new Token[tokens.size() + 1];
        ArrayList stack = new ArrayList();
        ArrayList<Token> buffer = new ArrayList<Token>();
        for (Token token : tokens) {
            buffer.add(token);
        }
        Token topOfStack = null;
        Token nextToTopOfStack = null;
        int numOps = 0;
        List[] workingTokenToArcs = new List[tokens.size() + 1];
        stack.add(buffer.remove(0));
        while (buffer.size() > 0 || stack.size() > 1) {
            List<Arc> workingArcs;
            if (++numOps > 10000) {
                System.err.println("ERROR: 10000+ operations!!! for sentence");
                break;
            }
            topOfStack = (Token)stack.get(stack.size() - 1);
            nextToTopOfStack = stack.size() >= 2 ? (Token)stack.get(stack.size() - 2) : null;
            Arc arc = null;
            arc = ProjectivityHandler.getDependency(nextToTopOfStack, topOfStack, finalTokenToChildren[topOfStack.getIndex()]);
            if (nextToTopOfStack != null && arc != null && ProjectivityHandler.hasAllItsDependents(nextToTopOfStack, finalTokenToChildren[nextToTopOfStack.getIndex()], workingTokenToArcs[nextToTopOfStack.getIndex()])) {
                stack.remove(nextToTopOfStack);
                workingArcs = workingTokenToArcs[topOfStack.getIndex()];
                if (workingArcs == null) {
                    workingArcs = new ArrayList<Arc>();
                    workingTokenToArcs[topOfStack.getIndex()] = workingArcs;
                }
                workingArcs.add(arc);
                continue;
            }
            if (nextToTopOfStack != null && (arc = ProjectivityHandler.getDependency(topOfStack, nextToTopOfStack, finalTokenToChildren[nextToTopOfStack.getIndex()])) != null && ProjectivityHandler.hasAllItsDependents(topOfStack, finalTokenToChildren[topOfStack.getIndex()], workingTokenToArcs[topOfStack.getIndex()])) {
                stack.remove(topOfStack);
                workingArcs = workingTokenToArcs[nextToTopOfStack.getIndex()];
                if (workingArcs == null) {
                    workingArcs = new ArrayList();
                    workingTokenToArcs[nextToTopOfStack.getIndex()] = workingArcs;
                }
                workingArcs.add(arc);
                continue;
            }
            if (buffer.size() == 0) break;
            Token topOfBuffer = (Token)buffer.remove(0);
            stack.add(topOfBuffer);
        }
        for (Token t : stack) {
            ProjectivityHandler.setSubcomponentHead(t, t, workingTokenToArcs, subcomponentHeadMappings);
        }
        return subcomponentHeadMappings;
    }

    private static void setSubcomponentHead(Token t, Token head, List[] workingTokenToArcs, Token[] tokenToSubcomponentHead) {
        tokenToSubcomponentHead[t.getIndex()] = head;
        List arcs = workingTokenToArcs[t.getIndex()];
        if (arcs != null) {
            for (Arc arc : arcs) {
                ProjectivityHandler.setSubcomponentHead(arc.getChild(), head, workingTokenToArcs, tokenToSubcomponentHead);
            }
        }
    }

    private static class IntHolderX {
        int x;

        private IntHolderX() {
        }
    }
}

