/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.transform;

import java.util.ArrayList;
import java.util.List;
import tratz.parse.transform.ParseTransform;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

public class CcTransformer
implements ParseTransform {
    public void performTransformation(Parse parse) {
        Arc[] tokenToHead = parse.getHeadArcs();
        List[] tokenToArcs = parse.getDependentArcLists();
        boolean[] modified = new boolean[tokenToHead.length];
        for (int i = tokenToHead.length - 1; i >= 0; --i) {
            String depNext;
            Arc nextArc;
            if (modified[i] || tokenToHead[i] == null) continue;
            String dep = tokenToHead[i].getDependency();
            boolean foundCC = false;
            if (!dep.equals("conj") && !dep.equals("cc")) continue;
            if (dep.equals("cc")) {
                foundCC = true;
            }
            ArrayList<Arc> arcsToRelocate = new ArrayList<Arc>();
            arcsToRelocate.add(tokenToHead[i]);
            System.err.println(tokenToHead[i].getChild().getText() + "--" + tokenToHead[i].getDependency() + "-->" + tokenToHead[i].getHead().getText());
            Token topConjunct = tokenToHead[i].getHead();
            while (!((nextArc = tokenToHead[topConjunct.getIndex()]) == null || !(depNext = nextArc.getDependency()).equals("conj") && !depNext.equals("cc") || foundCC && nextArc.getHead().getPos().equals("CC"))) {
                if (depNext.equals("cc")) {
                    foundCC = true;
                }
                topConjunct = nextArc.getHead();
                arcsToRelocate.add(nextArc);
            }
            if (arcsToRelocate.size() <= 1) continue;
            List newHeadsChildren = tokenToArcs[topConjunct.getIndex()];
            for (Arc arc : arcsToRelocate) {
                modified[arc.getChild().getIndex()] = true;
                Token oldArcHead = arc.getHead();
                List oldHeadsChildren = tokenToArcs[oldArcHead.getIndex()];
                oldHeadsChildren.remove(arc);
                arc.setHead(topConjunct);
                newHeadsChildren.add(arc);
            }
        }
    }
}

