/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.transform;

import java.util.ArrayList;
import java.util.List;
import tratz.parse.transform.ParseTransform;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;

public class ObjcompTransformer
implements ParseTransform {
    public void performTransformation(Parse parse) {
        Arc[] tokenToHead = parse.getHeadArcs();
        List[] tokenToArcs = parse.getDependentArcLists();
        for (int i = tokenToHead.length - 1; i >= 0; --i) {
            Arc arc = tokenToHead[i];
            if (arc == null || !arc.getDependency().equals("objcomp")) continue;
            List headsChildren = tokenToArcs[arc.getHead().getIndex()];
            Arc dobjArc = null;
            for (Arc child : headsChildren) {
                if (!child.getDependency().equals("dobj")) continue;
                dobjArc = child;
                break;
            }
            if (dobjArc != null) {
                arc.setDependency("xcomp");
                headsChildren.remove(dobjArc);
                dobjArc.setDependency("nsubj");
                dobjArc.setHead(arc.getChild());
                ArrayList<Arc> objcompChildren = tokenToArcs[arc.getChild().getIndex()];
                if (objcompChildren == null) {
                    tokenToArcs[arc.getChild().getIndex()] = objcompChildren = new ArrayList<Arc>();
                }
                objcompChildren.add(dobjArc);
                continue;
            }
            arc.setDependency("dep");
        }
    }
}

