/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.transform;

import java.util.ArrayList;
import java.util.List;
import tratz.parse.transform.ParseTransform;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

public class VchTransformer
implements ParseTransform {
    public void performTransformation(Parse parse) {
        Arc arc;
        int i;
        Arc[] tokenToHead = parse.getHeadArcs();
        List[] tokenToArcs = parse.getDependentArcLists();
        boolean anyChangesMade = false;
        boolean changeMade = true;
        while (changeMade) {
            changeMade = false;
            for (i = tokenToHead.length - 1; i >= 0; --i) {
                arc = tokenToHead[i];
                if (arc == null || !arc.getDependency().equals("vch")) continue;
                boolean hasVchild = false;
                List arcs = tokenToArcs[arc.getChild().getIndex()];
                if (arcs != null) {
                    for (Arc a : arcs) {
                        if (!a.getDependency().equals("vch")) continue;
                        hasVchild = true;
                        break;
                    }
                }
                if (hasVchild) continue;
                this.handleArc(parse.getRoot(), tokenToArcs, tokenToHead, arc);
                changeMade = true;
                anyChangesMade = true;
            }
        }
        for (i = 0; i < tokenToHead.length; ++i) {
            arc = tokenToHead[i];
            if (arc == null || !arc.getDependency().equals("nsubj") && !arc.getDependency().equals("csubj")) continue;
            Token head = arc.getHead();
            boolean hasAuxpass = false;
            List children = tokenToArcs[head.getIndex()];
            if (children != null) {
                for (Arc child : children) {
                    if (!child.getDependency().equals("auxpass")) continue;
                    hasAuxpass = true;
                    break;
                }
            }
            if (!hasAuxpass) continue;
            arc.setDependency(arc.getDependency() + "pass");
        }
    }

    private void handleArc(Token root, List[] tokenToArcs, Arc[] tokenToHead, Arc arc) {
        Token originalChild = arc.getChild();
        while ((arc = tokenToHead[originalChild.getIndex()]) != null && arc.getDependency().equals("vch")) {
            Token child = arc.getChild();
            Token head = arc.getHead();
            String newDep = "dep";
            String headText = head.getText().toLowerCase();
            if (headText.matches("ai|been|be|am|'m|are|were|'re|was|is")) {
                if (child.getPos().matches("VB(D|N)|JJ") || child.getPos().startsWith("NN") && child.getText().toLowerCase().matches(".*(ed|n)")) {
                    newDep = "auxpass";
                    child.setPos("VBN");
                } else {
                    newDep = child.getPos().matches("VBG") ? "aux" : "aux";
                }
            } else if (headText.matches("'s")) {
                newDep = VchTransformer.hasChildWithText(child, tokenToArcs, "being") ? "auxpass" : "aux";
            } else if (headText.matches("done|don't|ca|'d|can|coulda?|did|does|do|may|mighta?|must|ought|should|woulda?|will|shall|shalt|'ll|wo|had|has|have|'ve|having|being")) {
                newDep = "aux";
            }
            VchTransformer.demoteAUX(root, head, child, tokenToArcs, tokenToHead, newDep);
        }
    }

    private static boolean hasChildWithText(Token child, List[] tokenToArcs, String text) {
        boolean hasChildMatchingText = false;
        List arcs = tokenToArcs[child.getIndex()];
        if (arcs != null) {
            for (Arc arc : arcs) {
                if (!arc.getChild().getText().toLowerCase().matches(text)) continue;
                hasChildMatchingText = true;
                break;
            }
        }
        return hasChildMatchingText;
    }

    private static void demoteAUX(Token root, Token demotee, Token promotee, List[] tokenToArcs, Arc[] tokenToHead, String newDependency) {
        Token demoteeHead;
        Arc demoteeHeadArc = tokenToHead[demotee.getIndex()];
        Arc promoteeHeadArc = tokenToHead[promotee.getIndex()];
        Token token = demoteeHead = demoteeHeadArc == null ? null : demoteeHeadArc.getHead();
        if (demoteeHead != null) {
            List demoteeHeadArcs = tokenToArcs[demoteeHead.getIndex()];
            demoteeHeadArcs.remove(demoteeHeadArc);
            demoteeHeadArcs.add(promoteeHeadArc);
        }
        promoteeHeadArc.setDependency(demoteeHead == null ? "ROOT" : demoteeHeadArc.getDependency());
        List demoteesChildren = tokenToArcs[demotee.getIndex()];
        demoteesChildren.remove(promoteeHeadArc);
        promoteeHeadArc.setHead(demoteeHead == null ? null : demoteeHead);
        ArrayList<Arc> reattachedArcs = new ArrayList<Arc>();
        if (demoteeHeadArc != null) {
            demoteeHeadArc.setHead(promotee);
            demoteeHeadArc.setDependency(newDependency);
            reattachedArcs.add(demoteeHeadArc);
        } else {
            tokenToHead[demotee.getIndex()] = demoteeHeadArc = new Arc(demotee, promotee, newDependency);
            reattachedArcs.add(demoteeHeadArc);
        }
        for (Arc demoteeChildArc : demoteesChildren) {
            reattachedArcs.add(demoteeChildArc);
            demoteeChildArc.setHead(promotee);
        }
        ArrayList<Arc> promoteesChildren = tokenToArcs[promotee.getIndex()];
        if (promoteesChildren == null) {
            tokenToArcs[promotee.getIndex()] = promoteesChildren = new ArrayList<Arc>();
        }
        promoteesChildren.addAll(reattachedArcs);
    }
}

