/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.featgen.MultiStepFeatureGenerator;
import tratz.featgen.fer.FeatureExtractionRule;
import tratz.jwni.WordNet;
import tratz.ml.ClassScoreTuple;
import tratz.parse.NLParser;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.io.SentenceReader;
import tratz.parse.io.SentenceWriter;
import tratz.parse.ml.ParseModel;
import tratz.parse.transform.VchTransformer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.parse.util.ParseScorer;
import tratz.semantics.ClassificationBundle;

public class ParseScriptForEval {
    public static final String OPT_SENTENCE_READER_CLASS = "sentencereader";
    public static final String OPT_SENTENCE_WRITER_CLASS = "sentencewriter";
    public static final String OPT_SENTENCE_WRITER_OPTIONS = "writeroptions";
    public static final String OPT_MODEL_FILE = "model";
    public static final String OPT_WORDNET_DIR = "wndir";
    public static final String OPT_INPUT_FILE = "infile";
    public static long sPsdTime = 0L;
    public static long sNnTime = 0L;

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOptions = new CommandLineOptions();
        cmdOptions.addOption(OPT_SENTENCE_READER_CLASS, "classname", "the name of the sentence reading class (must implement " + SentenceReader.class.getName() + ")");
        cmdOptions.addOption(OPT_SENTENCE_WRITER_CLASS, "classname", "the name of the sentence writing class (must implement " + SentenceWriter.class.getName() + ")");
        cmdOptions.addOption(OPT_SENTENCE_WRITER_OPTIONS, "string", "string of colon-separated arguments for the writer");
        cmdOptions.addOption(OPT_MODEL_FILE, "file", "the name of file with the parsing model");
        cmdOptions.addOption(OPT_WORDNET_DIR, "file", "the dictionary (dict) directory of WordNet");
        cmdOptions.addOption(OPT_INPUT_FILE, "file", "the name of the input file");
        return cmdOptions;
    }

    public static void main(String[] args) throws Exception {
        String[] files;
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(ParseScriptForEval.createOptions(), args);
        String sentenceReaderClass = cmdLine.getStringValue(OPT_SENTENCE_READER_CLASS);
        String sentenceWriterClass = cmdLine.getStringValue(OPT_SENTENCE_WRITER_CLASS);
        String modelFile = cmdLine.getStringValue(OPT_MODEL_FILE);
        String wnDir = cmdLine.getStringValue(OPT_WORDNET_DIR);
        String inputFile = cmdLine.getStringValue(OPT_INPUT_FILE);
        String writerArgs = cmdLine.getStringValue(OPT_SENTENCE_WRITER_OPTIONS);
        HashMap<String, String> writerArgsMap = new HashMap<String, String>();
        String[] writerArgArray = writerArgs.split(":");
        SentenceReader sentenceReader = (SentenceReader)Class.forName(sentenceReaderClass).newInstance();
        SentenceWriter sentenceWriter = (SentenceWriter)Class.forName(sentenceWriterClass).newInstance();
        for (int i = 0; i < writerArgArray.length; ++i) {
            String[] parts = writerArgArray[i].split("=");
            writerArgsMap.put(parts[0], parts[1]);
        }
        sentenceWriter.initialize(writerArgsMap);
        ClassificationBundle psdWrapper = null;
        ClassificationBundle nnWrapper = null;
        ClassificationBundle possWrapper = null;
        ClassificationBundle srlArgsWrapper = null;
        ClassificationBundle srlPredicatesWrapper = null;
        ObjectInputStream ois = null;
        System.err.print("Loading parse model...");
        long startTime = System.currentTimeMillis();
        System.err.println(modelFile);
        FilterInputStream is = new BufferedInputStream(new FileInputStream(modelFile));
        if (modelFile.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        ois = new ObjectInputStream(is);
        ParseModel model = (ParseModel)ois.readObject();
        ParseFeatureGenerator featGen = (ParseFeatureGenerator)ois.readObject();
        ois.close();
        System.err.println("Model type: " + model.getClass().getName());
        System.err.println("loaded");
        System.err.println("Model loading took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
        System.err.print("Loading WordNet...");
        new WordNet(new File(wnDir));
        System.err.println("loaded");
        System.gc();
        System.err.println("Feature generation class: " + featGen.getClass().getName());
        NLParser parser = new NLParser(model, featGen);
        System.err.println("Start parsing...");
        boolean laCorrect = false;
        boolean laWrong = false;
        boolean unlCorrect = false;
        boolean unlWrong = false;
        ParseScorer lasCalc = new ParseScorer();
        boolean exactMatch = false;
        boolean totalSentences = false;
        System.gc();
        startTime = System.currentTimeMillis();
        block3: for (String file : files = inputFile.split(File.pathSeparator)) {
            Parse parse;
            BufferedReader reader = new BufferedReader(new FileReader(new File(file)));
            HashMap<Sentence, Integer> sentenceToIndex = new HashMap<Sentence, Integer>();
            ArrayList<Sentence> sentences = new ArrayList<Sentence>();
            int index = 0;
            while ((parse = sentenceReader.readSentence(reader)) != null) {
                sentences.add(parse.getSentence());
                sentenceToIndex.put(parse.getSentence(), index++);
            }
            reader.close();
            int ti = 0;
            int i = -1;
            for (Sentence sentence : sentences) {
                ++i;
                if (sentence == null) continue block3;
                long nanoStart = System.nanoTime();
                Parse parse2 = null;
                try {
                    parse2 = parser.parseSentence(sentence);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error encountered :(");
                    for (Token t : sentence.getTokens()) {
                        System.err.print(t.getText() + " ");
                    }
                    System.exit(0);
                }
                if (i % 100 == 0) {
                    System.err.println(i);
                }
                long psdStart = System.nanoTime();
                if (psdWrapper != null) {
                    for (Arc a : parse2.getArcs()) {
                        String dep = a.getDependency();
                        if (!dep.equals("prep") && !dep.equals("agent") && (!dep.equals("cop") || !a.getChild().getPos().equals("IN"))) continue;
                        Token t = a.getChild();
                        ClassScoreTuple[] rankings = psdWrapper.getPredictions(dep, sentence.getTokens(), parse2, t.getIndex() - 1);
                        t.setLexSense(rankings[0].clazz);
                    }
                }
                sPsdTime += System.nanoTime() - psdStart;
                long nnTime = System.nanoTime();
                if (nnWrapper != null) {
                    int numTokens = sentence.getTokens().size();
                    for (int t = 0; t < numTokens; ++t) {
                        Arc arc = parse2.getHeadArcs()[t];
                        if (arc == null || !arc.getDependency().equals("nn")) continue;
                        ClassScoreTuple[] decision = nnWrapper.getPredictions(arc.getDependency(), parse2.getSentence().getTokens(), parse2, arc.getChild().getIndex() - 1);
                        arc.setSemanticAnnotation(decision[0].clazz);
                    }
                }
                sNnTime += System.nanoTime() - nnTime;
                if (possWrapper != null) {
                    ArrayList<Sentence> sentenceDummyList = new ArrayList<Sentence>();
                    sentenceDummyList.add(sentence);
                    int numTokens = sentence.getTokens().size();
                    for (int t = 0; t < sentence.getTokens().size(); ++t) {
                        Arc arc = parse2.getHeadArcs()[t];
                        if (arc == null || !arc.getDependency().equals("poss")) continue;
                        ClassScoreTuple[] classification = possWrapper.getPredictions(arc.getDependency(), sentence.getTokens(), parse2, arc.getHead().getIndex() - 1);
                        arc.setSemanticAnnotation(classification[0].clazz);
                    }
                }
                List<Token> tokens = sentence.getTokens();
                int numTokens = tokens.size();
                Parse parseCopy = null;
                if (srlArgsWrapper != null) {
                    int t;
                    ArrayList<Arc> newArcs = new ArrayList<Arc>();
                    for (t = 0; t < numTokens; ++t) {
                        Arc orig = parse2.getHeadArcs()[t];
                        if (orig == null) continue;
                        Arc newArc = new Arc(orig.getChild(), orig.getHead(), orig.getDependency());
                        newArc.setCreationNum(orig.getCreationNum());
                        newArcs.add(newArc);
                    }
                    parseCopy = new Parse(sentence, parse2.getRoot(), newArcs);
                    new VchTransformer().performTransformation(parseCopy);
                    for (t = 0; t < numTokens; ++t) {
                        ClassScoreTuple[] predictions;
                        Arc arc = parseCopy.getHeadArcs()[t];
                        if (arc != null && (predictions = srlArgsWrapper.getPredictions(arc.getDependency(), tokens, parseCopy, arc.getChild().getIndex() - 1)) != null) {
                            arc.setSemanticAnnotation(predictions[0].clazz);
                        }
                        Token tok = tokens.get(t);
                        ClassScoreTuple[] predictions2 = srlPredicatesWrapper.getPredictions(arc.getDependency(), tokens, parseCopy, tok.getIndex() - 1);
                        if (predictions2 == null) continue;
                        tok.setLexSense(predictions2[0].clazz);
                    }
                }
                ti += sentence.getTokens().size();
                sentenceWriter.appendSentence(sentence, parse2, parseCopy.getHeadArcs());
            }
        }
        System.err.println("Parsing time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        System.err.println("Accuracy: " + (double)laCorrect / ((double)laCorrect + (double)laWrong) + " " + (double)unlCorrect / ((double)unlCorrect + (double)unlWrong));
        System.err.println("Exact match: " + (double)exactMatch / (double)totalSentences);
        System.err.println("DotTime: " + (double)NLParser.sDotProductTime / 1000000.0);
        System.err.println("FeatTime: " + (double)NLParser.sFeatGenTime / 1000000.0);
        System.err.println("NNTime: " + (double)sNnTime / 1.0E7);
        System.err.println("PsdTime: " + (double)sPsdTime / 1000000.0);
        for (FeatureExtractionRule fer : MultiStepFeatureGenerator.ferTimes.keySet()) {
            System.err.println(fer.getClass().getCanonicalName() + "\t" + (double)MultiStepFeatureGenerator.ferTimes.get(fer).longValue() / 1000000.0);
        }
        sentenceWriter.close();
    }
}

