/*
 * Decompiled with CFR 0.152.
 */
package tratz.pos.train;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CombineTrainingFeatureFiles {
    public static void main(String[] args) throws Exception {
        String inputFilePrefix = args[0];
        String outputFilePrefix = args[1];
        int numFolds = Integer.parseInt(args[2]);
        for (int i = 1; i <= numFolds; ++i) {
            String outputFilename = outputFilePrefix + i + ".gz";
            System.err.println("Writing: " + outputFilename);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outputFilename), 1000000))));
            for (int j = 1; j <= numFolds; ++j) {
                if (i == j) continue;
                String inputFilename = inputFilePrefix + j + ".gz";
                System.err.println("Adding: " + inputFilename);
                BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(inputFilename), 1000000))));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
                reader.close();
            }
            writer.close();
        }
        String outputFilename = outputFilePrefix + "FULL.gz";
        System.err.println("Writing: " + outputFilename);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(outputFilename))));
        for (int j = 1; j <= numFolds; ++j) {
            String inputFilename = inputFilePrefix + j + ".gz";
            System.err.println("Adding: " + inputFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFilename))));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            reader.close();
        }
        writer.close();
    }
}

