/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.annotations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tratz.runpipe.TextDocument;
import tratz.runpipe.impl.AnnotationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
extends AnnotationImpl {
    public static final long serialVersionUID = 1L;
    protected Arc mParentArc;
    protected List<Arc> mDependentArcs;
    protected String mPartOfSpeech;
    protected String mLemma;

    public Token(TextDocument doc) {
        super(doc);
    }

    public Token(TextDocument doc, int start, int end) {
        super(doc, start, end);
    }

    public void addDependent(Arc dependent) {
        if (this.mDependentArcs == null) {
            this.mDependentArcs = new ArrayList<Arc>(5);
        }
        this.mDependentArcs.add(dependent);
    }

    public List<Arc> getDependentArcs() {
        return this.mDependentArcs;
    }

    public String getLemma() {
        return this.mLemma;
    }

    public Arc getParentArc() {
        return this.mParentArc;
    }

    public String getPos() {
        return this.mPartOfSpeech;
    }

    public void setLemma(String lemma) {
        this.mLemma = lemma;
    }

    public void setParentArc(Arc parentArc) {
        this.mParentArc = parentArc;
    }

    public void setPos(String partOfSpeech) {
        this.mPartOfSpeech = partOfSpeech;
    }

    public static class Arc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Token mHead;
        private Token mChild;
        private String mDependency;

        public Arc(Token head, Token child, String dependency) {
            this.mHead = head;
            this.mChild = child;
            this.mDependency = dependency;
        }

        public Token getHead() {
            return this.mHead;
        }

        public Token getChild() {
            return this.mChild;
        }

        public String getDependency() {
            return this.mDependency;
        }
    }
}

