/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import tratz.runpipe.Annotation;
import tratz.runpipe.TextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentImpl
implements TextDocument,
Serializable {
    public static final long serialVersionUID = 1L;
    protected String mText;
    protected String mUri;
    protected Map<Class, TreeSet<Annotation>> mAnnotationIndex = new HashMap<Class, TreeSet<Annotation>>();

    public TextDocumentImpl(String text) {
        this.mText = text;
    }

    public TextDocumentImpl() {
    }

    @Override
    public void setUri(String uri) {
        this.mUri = uri;
    }

    @Override
    public void setText(String text) {
        this.mText = text;
    }

    @Override
    public String getUri() {
        return this.mUri;
    }

    @Override
    public void addAnnotation(Annotation annot) {
        Class<?> type = annot.getClass();
        TreeSet<Annotation> annotations = this.mAnnotationIndex.get(type);
        if (annotations == null) {
            annotations = new TreeSet();
            this.mAnnotationIndex.put(type, annotations);
        }
        annotations.add(annot);
    }

    @Override
    public void removeAnnotation(Annotation annot) {
        Class<?> type = annot.getClass();
        TreeSet<Annotation> annots = this.mAnnotationIndex.get(type);
        if (annots != null) {
            annots.remove(annot);
        }
    }

    public TreeSet<Annotation> getAnnotationSet(Class annotationType) {
        TreeSet<Annotation> annotSet = this.mAnnotationIndex.get(annotationType);
        if (annotSet != null) {
            annotSet = new TreeSet<Annotation>((SortedSet<Annotation>)annotSet);
        }
        return annotSet;
    }

    public List<Annotation> getAnnotationList(Class annotationType) {
        TreeSet<Annotation> annotSet = this.mAnnotationIndex.get(annotationType);
        ArrayList<Annotation> annots = null;
        if (annotSet != null) {
            annots = new ArrayList<Annotation>(annotSet);
        }
        return annots;
    }

    @Override
    public String getText() {
        return this.mText;
    }
}

