/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.annotators.parse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tratz.jwni.WordNet;
import tratz.runpipe.Annotation;
import tratz.runpipe.Annotator;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.util.HeuristicLongSentenceSplittingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharniakParserAnnotator
implements Annotator {
    public static final String PROGRAM_DIRECTORY = "ProgramDirectory";
    public static final String DATA_DIRECTORY = "DataDirectory";
    public static final String WORDNET_LOCATION = "WordNetDir";
    public static final String SPLIT_FAILED_SENTENCES = "SplitFailedSentences";
    private String mProgramDirectoryParam;
    private String mDataDirectoryParam;
    private File mProgramDir;
    private File mDataDir;
    private boolean mSplitFailedSentences;

    @Override
    public void initialize(Map<String, String> params) throws InitializationException {
        try {
            new WordNet(new File(params.get(WORDNET_LOCATION)).getAbsoluteFile().toURI().toURL().toString());
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
        this.mSplitFailedSentences = Boolean.parseBoolean(params.get(SPLIT_FAILED_SENTENCES));
        this.mProgramDirectoryParam = params.get(PROGRAM_DIRECTORY);
        this.mDataDirectoryParam = params.get(DATA_DIRECTORY);
        this.mProgramDir = new File(this.mProgramDirectoryParam);
        this.mDataDir = new File(this.mDataDirectoryParam);
        if (!(this.mProgramDir.canRead() && this.mProgramDir.isDirectory() && this.mDataDir.canRead() && this.mProgramDir.isDirectory())) {
            System.err.println(this.mProgramDir.getAbsolutePath() + "\t" + this.mProgramDir.canRead() + "\t" + this.mProgramDir.isDirectory());
            System.err.println(this.mDataDir.getAbsolutePath() + "\t" + this.mDataDir.canRead() + "\t" + this.mDataDir.isDirectory());
            throw new InitializationException();
        }
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> sentences = doc.getAnnotationList(Sentence.class);
        boolean firstPassComplete = false;
        int iteration = 0;
        if (sentences != null) {
            while (!firstPassComplete || this.mSplitFailedSentences && sentences != null && sentences.size() > 1) {
                sentences = this.runParsing(doc.getUri(), sentences, iteration);
                if (this.mSplitFailedSentences && sentences != null) {
                    sentences = HeuristicLongSentenceSplittingUtil.splitSentences(doc, sentences);
                }
                ++iteration;
                firstPassComplete = true;
            }
        } else {
            System.err.println("No sentences!");
        }
    }

    private List<Sentence> runParsing(String docURI, List<Sentence> sentences, int iteration) throws ProcessException {
        File tempInputFile = this.writeInputFile(sentences);
        if (tempInputFile != null) {
            String results = this.runProcess(tempInputFile);
            tempInputFile.delete();
            if (results != null) {
                return this.readResult(docURI, sentences, results, iteration);
            }
            ArrayList<Sentence> sentencesToRedo = new ArrayList<Sentence>();
            for (Sentence sentence : sentences) {
                List<Sentence> sList;
                ArrayList<Sentence> singleSentenceList = new ArrayList<Sentence>();
                singleSentenceList.add(sentence);
                tempInputFile = this.writeInputFile(singleSentenceList);
                results = this.runProcess(tempInputFile);
                tempInputFile.delete();
                if (results == null || (sList = this.readResult(docURI, singleSentenceList, results, iteration)) == null) continue;
                sentencesToRedo.addAll(sList);
            }
            return sentencesToRedo;
        }
        return null;
    }

    private File writeInputFile(List<Sentence> sentences) throws ProcessException {
        File tempFile = null;
        PrintWriter sentencesWriter = null;
        int numWritten = 0;
        try {
            tempFile = File.createTempFile("sentences", ".txt", new File("."));
            sentencesWriter = new PrintWriter(new FileWriter(tempFile));
            for (Sentence sentence : sentences) {
                String sentenceText = sentence.getAnnotText().replaceAll("\\(\\(+", "\\(").replaceAll("\\)\\)+", "\\)");
                if (!sentenceText.trim().equals("")) {
                    ++numWritten;
                } else {
                    sentenceText = "_BLANK_LINE_DUMBY_";
                }
                sentencesWriter.print("<s> " + sentenceText + " </s>\n");
                sentencesWriter.print("<s> g090g </s>\n");
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        finally {
            if (sentencesWriter != null) {
                sentencesWriter.close();
            }
        }
        if (numWritten == 0) {
            tempFile.delete();
            tempFile = null;
        }
        return tempFile;
    }

    private String runProcess(File sentencesFile) throws ProcessException {
        Runtime runtime = Runtime.getRuntime();
        String resultsText = null;
        try {
            String part1 = this.mProgramDir.getPath() + "/parseIt";
            String part2 = this.mDataDir.getPath() + "/";
            String part3 = sentencesFile.getPath();
            String executionString = part1 + " " + part2 + " " + part3;
            System.err.println(executionString);
            Process process = runtime.exec(executionString);
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            int result = process.waitFor();
            System.err.println("Process returned: " + result);
            reader.close();
            if (result == 0) {
                resultsText = builder.toString();
            }
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
        return resultsText;
    }

    private List<Sentence> readResult(String docURI, List<Sentence> sentences, String results, int iteration) throws ProcessException {
        ArrayList<Sentence> potentiallyTooLongSentences = new ArrayList<Sentence>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(results));
            for (Sentence sentence : sentences) {
                String line = reader.readLine();
                System.err.println(line);
                if (line == null) {
                    System.err.println("Oddball result. Expected junk link.");
                    for (int i = 0; i < sentences.size(); ++i) {
                        System.err.println(sentences.get(i).getAnnotText());
                        System.err.println(sentences.get(i).getParseString());
                    }
                }
                if (line.equals("(S1 (NP (NNP g090g)))")) {
                    String sentenceText = sentence.getAnnotText();
                    if (sentenceText.split("\\s+").length > 40) {
                        potentiallyTooLongSentences.add(sentence);
                    }
                    reader.readLine();
                    continue;
                }
                if (iteration > 1) {
                    System.err.println("Iteration " + iteration + ": " + sentence.getAnnotText());
                }
                if (!line.equals("(S1 (NP (NNP _BLANK_LINE_DUMBY_)))")) {
                    sentence.setParseString(line);
                }
                reader.readLine();
                reader.readLine();
                reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return potentiallyTooLongSentences;
    }
}

