/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.annotators.parse;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;
import tratz.runpipe.Annotation;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Token;
import tratz.runpipe.impl.AnnotatorImpl;
import tratz.util.TreebankConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenFieldUpdater
extends AnnotatorImpl
implements TreebankConstants {
    public static final String PARAM_WORDNET_DIR = "WordNetDir";

    @Override
    public void initialize(Map<String, String> params) throws InitializationException {
        String wordNetPath = params.get(PARAM_WORDNET_DIR);
        if (WordNet.getInstance() == null) {
            try {
                String path = new File(wordNetPath).getAbsolutePath();
                new WordNet(new File(path).getAbsoluteFile().toURI().toString());
            }
            catch (IOException ioe) {
                throw new InitializationException(ioe);
            }
        }
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> tokens = doc.getAnnotationList(Token.class);
        if (tokens != null) {
            for (Token token : tokens) {
                this.updateField(token);
            }
        }
    }

    private void updateField(Token tok) {
        String xPos = tok.getPos();
        POS jpos = this.getPosForType(xPos);
        if (jpos != null) {
            IndexEntry ie = null;
            try {
                for (POS speechPart : new POS[]{jpos, POS.NOUN, POS.VERB, POS.ADJECTIVE}) {
                    if (ie != null) continue;
                    ie = WordNet.getInstance().lookupIndexEntry(speechPart, tok.getAnnotText().replace(' ', '_'));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ie != null) {
                tok.setLemma(ie.getLemma());
            } else {
                tok.setLemma(tok.getAnnotText().toLowerCase());
            }
        } else {
            tok.setLemma(tok.getAnnotText().toLowerCase());
        }
    }

    protected POS getPosForType(String type) {
        POS pos = null;
        if (TreebankConstants.NOUN_LABELS.contains(type)) {
            pos = POS.NOUN;
        } else if (TreebankConstants.VERB_LABELS.contains(type)) {
            pos = POS.VERB;
        } else if (TreebankConstants.ADJ_LABELS.contains(type)) {
            pos = POS.ADJECTIVE;
        } else if (TreebankConstants.ADV_LABELS.contains(type)) {
            pos = POS.ADVERB;
        }
        return pos;
    }
}

