/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.annotators.pos;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tratz.jwni.WordNet;
import tratz.parse.types.Token;
import tratz.pos.PosTagger;
import tratz.runpipe.Annotation;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.impl.AnnotatorImpl;
import tratz.runpipe.util.RunpipeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TratzPosTaggerAnnotator
extends AnnotatorImpl {
    public static final String PARAM_MODEL_FILE = "ModelFile";
    public static final String PARAM_WORDNET_DIR = "WordNetDir";
    private PosTagger mPosTagger;

    @Override
    public void initialize(Map<String, String> args) throws InitializationException {
        try {
            String modelFile = args.get(PARAM_MODEL_FILE);
            this.mPosTagger = new PosTagger(new File(modelFile));
            String wordNetDir = args.get(PARAM_WORDNET_DIR);
            new WordNet(new File(wordNetDir));
        }
        catch (Exception ioe) {
            throw new InitializationException(ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> allSentences = doc.getAnnotationList(Sentence.class);
        List<? extends Annotation> allTokens = doc.getAnnotationList(tratz.runpipe.annotations.Token.class);
        if (allSentences != null && allTokens != null) {
            try {
                for (Sentence sentence : allSentences) {
                    void var10_12;
                    List<? extends Annotation> tokens = RunpipeUtils.getSublist(sentence, allTokens);
                    ArrayList<Token> gtokens = new ArrayList<Token>(tokens.size());
                    int index = 0;
                    for (tratz.runpipe.annotations.Token token : tokens) {
                        gtokens.add(new Token(token.getAnnotText(), ++index));
                    }
                    this.mPosTagger.posTag(gtokens);
                    int numTokens = tokens.size();
                    boolean bl = false;
                    while (var10_12 < numTokens) {
                        ((tratz.runpipe.annotations.Token)tokens.get((int)var10_12)).setPos(((Token)gtokens.get((int)var10_12)).getPos());
                        ++var10_12;
                    }
                }
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        }
    }
}

