/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.corpusreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.runpipe.CorpusReader;
import tratz.runpipe.DocumentReadException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.TextDocumentReader;
import tratz.runpipe.impl.TextDocumentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryCorpusReader
implements CorpusReader {
    public static final String PARAM_INPUT_DIR = "InputDirectories";
    public static final String PARAM_RECURSIVE = "IncludeSubdirs";
    public static final String PARAM_FILTER_PATTERN = "FilterPattern";
    protected List<File> mFiles = new ArrayList<File>();
    protected int mCurrentFileIndex;
    protected TextDocumentReader mDocumentReader;

    @Override
    public void initialize(Map<String, String> params) {
        String inputDirectoriesString = params.get(PARAM_INPUT_DIR);
        String[] inputDirectoriesArray = inputDirectoriesString.split(File.pathSeparator);
        String includeSubdirsString = params.get(PARAM_RECURSIVE);
        boolean includeSubdirs = includeSubdirsString == null ? Boolean.TRUE : Boolean.parseBoolean(includeSubdirsString);
        String filterPattern = params.get(PARAM_FILTER_PATTERN);
        Matcher fileNameMatcher = filterPattern == null ? null : Pattern.compile(filterPattern).matcher("");
        for (String inputDirectory : inputDirectoriesArray) {
            DirectoryCorpusReader.addFiles(new File(inputDirectory), this.mFiles, includeSubdirs, fileNameMatcher);
        }
        Collections.sort(this.mFiles);
        Collections.reverse(this.mFiles);
    }

    private static void addFiles(File directory, List<File> fileList, boolean includeSubdirs, Matcher filter) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                if (!includeSubdirs) continue;
                DirectoryCorpusReader.addFiles(file, fileList, includeSubdirs, filter);
                continue;
            }
            if (filter != null && !filter.reset(file.getName()).matches()) continue;
            fileList.add(file);
        }
    }

    @Override
    public TextDocumentReader getDocumentReader() {
        return this.mDocumentReader;
    }

    @Override
    public void setDocumentReader(TextDocumentReader reader) {
        this.mDocumentReader = reader;
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentFileIndex < this.mFiles.size();
    }

    @Override
    public TextDocument getNext() throws DocumentReadException, IOException {
        TextDocumentImpl doc = new TextDocumentImpl();
        File file = this.mFiles.get(this.mCurrentFileIndex++);
        System.err.println("Reading file " + this.mCurrentFileIndex + " of " + this.mFiles.size() + ": " + file.getName());
        doc.setUri(file.getAbsolutePath());
        FileInputStream is = new FileInputStream(file);
        this.mDocumentReader.hydrateDocument(is, doc);
        ((InputStream)is).close();
        return doc;
    }
}

