/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.docreader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import tratz.runpipe.TextDocument;
import tratz.runpipe.TextDocumentReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagRemoverReader
implements TextDocumentReader {
    @Override
    public void initialize(Map<String, String> params) {
    }

    @Override
    public void hydrateDocument(InputStream istream, TextDocument doc) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
        String l = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = reader.readLine()) != null) {
            l = l.replaceAll("<DOCID.*DOCID>", "");
            l = l.replaceAll("<DOCTYPE.*DOCTYPE>", "");
            l = l.replaceAll("<DATETIME.*DATETIME>", "");
            l = l.replaceAll("<POSTER.*POSTER>", "");
            l = l.replaceAll("<POSTDATE.*POSTDATE>", "");
            l = l.replaceAll("<[^>]*>", "");
            lines.add(l);
        }
        StringBuffer docText = new StringBuffer();
        int start = 0;
        for (String sentence : lines) {
            int length = sentence.length();
            docText.append(sentence);
            docText.append('\n');
            start += length + 1;
        }
        doc.setText(docText.toString());
        reader.close();
    }
}

