/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.endpoints;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import tratz.runpipe.Annotation;
import tratz.runpipe.EndPoint;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.annotations.Token;
import tratz.runpipe.util.RunpipeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotFileWriter
implements EndPoint {
    public static final String PARAM_OUTPUT_DIR = "OutputDir";
    private File mOutputDir;
    private int mDocCounter;

    @Override
    public void initialize(Map<String, String> args) throws InitializationException {
        String outputDir = args.get(PARAM_OUTPUT_DIR);
        this.mOutputDir = new File(outputDir);
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> sentences = doc.getAnnotationList(Sentence.class);
        List<? extends Annotation> tokens = doc.getAnnotationList(Token.class);
        try {
            int sentenceNo = 0;
            for (Sentence sentence : sentences) {
                PrintWriter writer = new PrintWriter(new FileWriter(new File(this.mOutputDir, this.mDocCounter + "-" + sentenceNo + ".txt")));
                List<? extends Annotation> subtokens = RunpipeUtils.getSublist(sentence, tokens);
                writer.println("digraph G {");
                for (Token token : subtokens) {
                    Token parent;
                    Token.Arc parentArc = token.getParentArc();
                    if (parentArc == null || (parent = parentArc.getHead()) == null) continue;
                    writer.println("\"" + parent.getStart() + ":" + parent.getAnnotText() + ":" + parent.getPos() + "\" -> \"" + token.getStart() + ":" + token.getAnnotText() + ":" + token.getPos() + "\" [label=\"" + parentArc.getDependency() + "\"];");
                }
                writer.println("}");
                writer.close();
                ++sentenceNo;
            }
            ++this.mDocCounter;
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    @Override
    public void batchFinished() {
    }
}

