/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.endpoints;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import tratz.runpipe.EndPoint;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzippedDocumentWriter
implements EndPoint {
    public static final String PARAM_OUTPUT_DIR = "OutputDir";
    private File mOutputDir;

    @Override
    public void initialize(Map<String, String> params) throws InitializationException {
        this.mOutputDir = new File(params.get(PARAM_OUTPUT_DIR));
        this.mOutputDir.mkdirs();
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        String uri = doc.getUri();
        String docFilename = uri.substring(uri.lastIndexOf(File.separatorChar) + 1);
        String outputFilename = docFilename + ".gz";
        try {
            File outputFile = new File(this.mOutputDir, outputFilename);
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)));
            oos.writeObject(doc);
            oos.close();
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    @Override
    public void batchFinished() {
    }
}

