/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tratz.runpipe.Annotator;
import tratz.runpipe.CorpusReader;
import tratz.runpipe.EndPoint;
import tratz.runpipe.Pipe;
import tratz.runpipe.TextDocumentReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunPipe {
    public static final String ANNOTATOR = "-annotator";
    public static final String CORPUS_READER = "-corpusreader";
    public static final String DOC_READER = "-documentreader";
    public static final String END_POINT = "-endpoint";
    private static final Set<String> KNOWN_ARG_TYPES = new HashSet<String>(Arrays.asList("-corpusreader", "-documentreader", "-annotator", "-endpoint"));

    public static void main(String[] args) throws Exception {
        Pipe pipe = new Pipe();
        String corpusReaderClassName = null;
        String documentReaderClassName = null;
        ArrayList<String> annotatorClassNameList = new ArrayList<String>();
        ArrayList<String> endPointClassNameList = new ArrayList<String>();
        HashMap<String, String> corpusReaderParams = new HashMap<String, String>();
        HashMap<String, String> initializerParams = new HashMap<String, String>();
        ArrayList annotatorParams = new ArrayList();
        ArrayList endPointParams = new ArrayList();
        int argIndex = 0;
        while (argIndex < args.length) {
            String arg = args[argIndex];
            HashMap<String, String> params = null;
            if (arg.equals(ANNOTATOR)) {
                annotatorClassNameList.add(args[++argIndex]);
                params = new HashMap();
                annotatorParams.add(params);
            } else if (arg.equals(CORPUS_READER)) {
                corpusReaderClassName = args[++argIndex];
                params = corpusReaderParams;
            } else if (arg.equals(DOC_READER)) {
                documentReaderClassName = args[++argIndex];
                params = initializerParams;
            } else if (arg.equals(END_POINT)) {
                endPointClassNameList.add(args[++argIndex]);
                params = new HashMap();
                endPointParams.add(params);
            } else {
                throw new IllegalArgumentException("Unknown arg type: " + args[argIndex]);
            }
            ++argIndex;
            argIndex = RunPipe.populateArgumentMap(argIndex, args, params);
        }
        CorpusReader corpusReader = (CorpusReader)Class.forName(corpusReaderClassName).newInstance();
        pipe.setCorpusReader(corpusReader, corpusReaderParams);
        if (documentReaderClassName != null) {
            TextDocumentReader docReader = (TextDocumentReader)Class.forName(documentReaderClassName).newInstance();
            pipe.setDocumentReader(docReader, initializerParams);
        }
        int numAnnotators = annotatorClassNameList.size();
        for (int i = 0; i < numAnnotators; ++i) {
            Annotator annotator = (Annotator)Class.forName((String)annotatorClassNameList.get(i)).newInstance();
            pipe.addAnnotator(annotator, (Map)annotatorParams.get(i));
        }
        int numEndPoints = endPointClassNameList.size();
        for (int i = 0; i < numEndPoints; ++i) {
            EndPoint epu = (EndPoint)Class.forName((String)endPointClassNameList.get(i)).newInstance();
            pipe.addEndProcessingUnit(epu, (Map)endPointParams.get(i));
        }
        pipe.go();
    }

    private static int populateArgumentMap(int currentIndex, String[] args, Map<String, String> paramMap) {
        String arg = args[currentIndex];
        while (currentIndex < args.length && !KNOWN_ARG_TYPES.contains(arg = args[currentIndex])) {
            int equalsIndex = arg.indexOf(61);
            if (equalsIndex == -1) {
                throw new IllegalArgumentException("parameter setting: " + arg + " lacks an equals sign ('=')");
            }
            paramMap.put(arg.substring(0, equalsIndex), arg.substring(equalsIndex + 1));
            ++currentIndex;
        }
        return currentIndex;
    }
}

