/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.psd.training;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tratz.runpipe.Annotation;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Token;
import tratz.runpipe.impl.AnnotatorImpl;
import tratz.semantics.psd.training.HeadAnnotation;

public class HeadAnnotationCreator
extends AnnotatorImpl {
    private Set<String> mPrepositionsOfInterest = new HashSet<String>(Arrays.asList("about", "above", "across", "after", "against", "along", "among", "around", "as", "at", "before", "behind", "beneath", "beside", "between", "by", "down", "during", "for", "from", "in", "inside", "into", "like", "of", "off", "on", "onto", "over", "round", "through", "to", "towards", "with"));

    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> tokens = doc.getAnnotationList(Token.class);
        for (Token token : tokens) {
            if (!this.mPrepositionsOfInterest.contains(token.getAnnotText().toLowerCase())) continue;
            doc.addAnnotation(new HeadAnnotation(doc, token.getStart(), token.getEnd()));
        }
    }
}

