/*
 * Decompiled with CFR 0.152.
 */
package tratz.types;

import java.io.Serializable;

public class ByteArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] mData;
    private int mLength;

    public ByteArrayList() {
        this(10);
    }

    public ByteArrayList(int size) {
        this.mData = new byte[size];
    }

    public void add(byte b) {
        this.expandIfNecessary(this.mData, this.mLength);
        this.mData[this.mLength++] = b;
    }

    private void expandIfNecessary(byte[] data, int neededLength) {
        if (data.length == neededLength) {
            int newSize = data.length * 3 / 2 + 1;
            byte[] newData = new byte[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.mData = newData;
        }
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte[] toCompactArray() {
        byte[] result = new byte[this.mLength];
        System.arraycopy(this.mData, 0, result, 0, this.mLength);
        return result;
    }

    public byte get(int i) {
        return this.mData[i];
    }

    public void set(int i, byte b) {
        this.mData[i] = b;
    }

    public int size() {
        return this.mLength;
    }
}

