/*
 * Decompiled with CFR 0.152.
 */
package tratz.types;

import java.io.Serializable;

public class ShortArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short[] mData;
    private int mLength;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(int size) {
        this.mData = new short[size];
    }

    public void add(short b) {
        this.expandIfNecessary(this.mData, this.mLength);
        this.mData[this.mLength++] = b;
    }

    private void expandIfNecessary(short[] data, int neededLength) {
        if (data.length == neededLength) {
            int newSize = data.length * 3 / 2 + 1;
            short[] newData = new short[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.mData = newData;
        }
    }

    public short[] getData() {
        return this.mData;
    }

    public short[] toCompactArray() {
        short[] result = new short[this.mLength];
        System.arraycopy(this.mData, 0, result, 0, this.mLength);
        return result;
    }

    public short get(int i) {
        return this.mData[i];
    }

    public void set(int i, short b) {
        this.mData[i] = b;
    }

    public int size() {
        return this.mLength;
    }
}

