/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.concepts.ConceptHierarchyWindow;
import edu.nyu.jet.hmm.HMMTagger;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.parser.Parsers;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternGraphView;
import edu.nyu.jet.pat.PatternView;
import edu.nyu.jet.scorer.SGMLScorerWindow;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Console
extends JFrame
implements ActionListener {
    static JMenuBar menuBar;
    static JPanel controlPanel;
    static JLabel label;
    static JTextField sentence;
    static JTextArea area;
    static JScrollPane sp;
    public static PatternView pv;
    public static PatternGraphView pgv;

    public Console() {
        super("Jet Console");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(640, 480);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    private static JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem loadGrammar = new JMenuItem("Reload Grammar");
        loadGrammar.setMnemonic(71);
        loadGrammar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JetTest.readGrammar();
            }
        });
        fileMenu.add(loadGrammar);
        JMenuItem loadLexicons = new JMenuItem("Reload Lexicon");
        loadLexicons.setMnemonic(76);
        loadLexicons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JetTest.readLexicons();
            }
        });
        fileMenu.add(loadLexicons);
        JMenuItem loadPatterns = new JMenuItem("Reload Patterns");
        loadPatterns.setMnemonic(80);
        loadPatterns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JetTest.readPatterns();
                JMenu patternsMenu = menuBar.getMenu(3);
                patternsMenu.remove(2);
                patternsMenu.remove(2);
                patternsMenu.add(PatternApplication.matchSubmenu());
                patternsMenu.add(PatternApplication.applySubmenu());
            }
        });
        fileMenu.add(loadPatterns);
        fileMenu.addSeparator();
        JMenuItem clearConsole = new JMenuItem("Clear console");
        clearConsole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                area.setText("");
            }
        });
        fileMenu.add(clearConsole);
        fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic(88);
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(exit);
        return fileMenu;
    }

    private static JMenu buildTaggerMenu() {
        JMenu taggerMenu = new JMenu("Tagger");
        taggerMenu.setMnemonic(71);
        final JCheckBoxMenuItem traceItem = new JCheckBoxMenuItem("POS Tagger Trace", HMMTagger.trace);
        traceItem.setMnemonic(80);
        traceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HMMTagger.trace = traceItem.getState();
            }
        });
        taggerMenu.add(traceItem);
        return taggerMenu;
    }

    private static JMenu buildPatternsMenu() {
        JMenu patternsMenu = new JMenu("Patterns");
        patternsMenu.setMnemonic(80);
        JMenuItem viewPatterns = new JMenuItem("View Patterns");
        viewPatterns.setMnemonic(86);
        viewPatterns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pv = new PatternView(JetTest.patternFile);
            }
        });
        patternsMenu.add(viewPatterns);
        JMenuItem viewPatternGraphs = new JMenuItem("View Pattern Graphs");
        viewPatternGraphs.setMnemonic(71);
        viewPatternGraphs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pgv = new PatternGraphView(JetTest.patternFile);
            }
        });
        patternsMenu.add(viewPatternGraphs);
        patternsMenu.add(PatternApplication.matchSubmenu());
        patternsMenu.add(PatternApplication.applySubmenu());
        return patternsMenu;
    }

    private static JMenu buildToolsMenu() {
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        JMenuItem sgmlScorer = new JMenuItem("SGML Scorer ...");
        sgmlScorer.setMnemonic(83);
        sgmlScorer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SGMLScorerWindow dsw = new SGMLScorerWindow();
            }
        });
        toolsMenu.add(sgmlScorer);
        toolsMenu.addSeparator();
        JMenuItem conceptEditor = new JMenuItem("Concept Editor ...");
        conceptEditor.setMnemonic(67);
        conceptEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConceptHierarchyWindow chw = new ConceptHierarchyWindow(JetTest.conceptHierarchy, JetTest.conceptHierarchyFile);
            }
        });
        toolsMenu.add(conceptEditor);
        toolsMenu.addSeparator();
        JMenu processDocsSubMenu = new JMenu("Process Documents");
        processDocsSubMenu.setMnemonic(80);
        toolsMenu.add(processDocsSubMenu);
        JMenuItem view = new JMenuItem("and View Annotated Documents ...");
        view.setMnemonic(86);
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pv != null) {
                    pv.clearMatchedPatterns();
                    pv.clearAppliedPatterns();
                    pv.refresh();
                }
                JetTest.processFiles(true);
            }
        });
        processDocsSubMenu.add(view);
        JMenuItem noview = new JMenuItem("but Don't View");
        noview.setMnemonic(68);
        noview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pv != null) {
                    pv.clearMatchedPatterns();
                    pv.clearAppliedPatterns();
                    pv.refresh();
                }
                JetTest.processFiles(false);
            }
        });
        processDocsSubMenu.add(noview);
        JMenuItem closeAllViews = new JMenuItem("Close All Jet Documents");
        closeAllViews.setMnemonic(65);
        closeAllViews.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        closeAllViews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JetTest.closeAllViews();
            }
        });
        toolsMenu.add(closeAllViews);
        JMenuItem setColors = new JMenuItem("Costomize Annotation Colors ...");
        setColors.setMnemonic(90);
        setColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationColor.showColors();
            }
        });
        toolsMenu.add(setColors);
        return toolsMenu;
    }

    public static void print(String stg) {
        if (area == null) {
            System.err.print(stg);
        } else {
            area.append(stg);
            sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMaximum());
        }
    }

    public static void println(String stg) {
        if (area == null) {
            System.err.println(stg);
        } else {
            area.append(stg);
            area.append("\n");
            sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMaximum());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String stg = sentence.getText();
        Console.println("---------");
        Console.println("Sentence:                               " + stg);
        sentence.selectAll();
        if (pv != null) {
            pv.clearMatchedPatterns();
            pv.clearAppliedPatterns();
            pv.refresh();
        }
        if (stg == null) {
            return;
        }
        Document doc = new Document(stg);
        Span sentenceSpan = new Span(0, doc.length());
        Tokenizer.tokenize(doc, sentenceSpan);
        Control.processSentence(doc, sentenceSpan);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(3);
        menuBar = new JMenuBar();
        menuBar.add(Console.buildFileMenu());
        menuBar.add(Parsers.parserMenu());
        menuBar.add(Console.buildTaggerMenu());
        menuBar.add(Console.buildPatternsMenu());
        menuBar.add(Console.buildToolsMenu());
        this.setJMenuBar(menuBar);
        controlPanel = new JPanel();
        label = new JLabel();
        sentence = new JTextField();
        area = new JTextArea();
        area.setEditable(false);
        area.setFont(new Font("Monospaced", 0, 12));
        sp = new JScrollPane(area);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        label.setText("Enter sentence:");
        sentence.addActionListener(this);
        controlPanel.setLayout(new GridBagLayout());
        area.setMargin(new Insets(3, 3, 3, 3));
        c.add((Component)controlPanel, "South");
        controlPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 3, 0), 0, 0));
        controlPanel.add((Component)sentence, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 6, 3, 16), 0, 0));
        c.add((Component)sp, "Center");
    }

    static {
        area = null;
        pv = null;
        pgv = null;
    }
}

