/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.Console;
import edu.nyu.jet.Control;
import edu.nyu.jet.JarDate;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.chunk.Chunker;
import edu.nyu.jet.chunk.MENameTagger;
import edu.nyu.jet.chunk.MaxEntNE;
import edu.nyu.jet.chunk.Onoma;
import edu.nyu.jet.concepts.ConceptHierarchy;
import edu.nyu.jet.hmm.BIOWriter;
import edu.nyu.jet.hmm.HMMNameTagger;
import edu.nyu.jet.hmm.HMMTagger;
import edu.nyu.jet.hmm.WordFeatureHMMemitter;
import edu.nyu.jet.lex.EnglishLex;
import edu.nyu.jet.lex.Lexicon;
import edu.nyu.jet.ne.NameAnnotator;
import edu.nyu.jet.ne.RuleFormatException;
import edu.nyu.jet.ne.TrieDictionary;
import edu.nyu.jet.parser.DepParser;
import edu.nyu.jet.parser.Grammar;
import edu.nyu.jet.parser.StatParser;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.pat.PatternCollection;
import edu.nyu.jet.refres.CorefEval;
import edu.nyu.jet.refres.EntityView;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.scorer.NameTagger;
import edu.nyu.jet.scorer.SGMLProcessor;
import edu.nyu.jet.time.NumberAnnotator;
import edu.nyu.jet.time.TimeAnnotator;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.CollectionAnnotationTool;
import edu.nyu.jet.tipster.CollectionView;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.View;
import edu.nyu.jet.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JetTest {
    public static Set<String> validProperties = new HashSet<String>();
    public static boolean batchFlag = false;
    protected static Properties defaultConfig = new Properties();
    protected static Properties config = null;
    private static File configFile;
    protected static String dataPath;
    public static PatternCollection pc;
    public static File patternFile;
    protected static Grammar gram;
    public static HMMTagger tagger;
    public static NameTagger nameTagger;
    protected static Vector views;
    public static ConceptHierarchy conceptHierarchy;
    public static File conceptHierarchyFile;
    public static String encoding;
    public static String docId;
    public static NameAnnotator extendedNameTagger;
    private static TimeAnnotator timeAnnotator;
    private static DateTime referenceTime;
    private static DateTimeFormatter referenceTimeFormat;
    private static NumberAnnotator numberAnnotator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeFromConfig(File configFile, String jetHome) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            config.load(in);
            batchFlag = config.getProperty("Jet.batch") != null;
            String dataPathProperty = config.getProperty("Jet.dataPath");
            dataPath = dataPathProperty == null ? (jetHome == null || jetHome.equals("") ? "." : jetHome) : (jetHome == null || jetHome.equals("") || new File(dataPathProperty).isAbsolute() ? dataPathProperty : jetHome + File.separatorChar + dataPathProperty);
            if (!batchFlag) {
                new AnnotationColor(dataPath);
            }
            JetTest.initialize();
            System.err.println("Jet Ver. 1.9.0.  Portions (c) 1999-2015 R. Grishman");
            JarDate.print(System.err);
            System.err.println("Licensed under Apache License, Version 2.0.");
            JetTest.validateConfig(config);
        }
        catch (IOException ioe) {
            try {
                System.err.println("Error: could not open file " + configFile);
                System.err.println("USAGE: JetTest <configFile>");
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
        }
        IOUtils.closeQuietly(in);
    }

    static void validateConfig(Properties config) {
        block0: for (String string : config.keySet()) {
            if (validProperties.contains(string)) continue;
            for (String s : validProperties) {
                if (!s.endsWith("*") || !string.startsWith(s.substring(0, s.length() - 1))) continue;
                continue block0;
            }
            System.err.println("*** Invalid property " + string + " in properties file.");
        }
    }

    public static void initializeFromConfig(String configFile, String jetHome) {
        JetTest.initializeFromConfig(new File(configFile), jetHome);
    }

    public static void initializeFromConfig(File configFile) {
        JetTest.initializeFromConfig(configFile, System.getProperty("jetHome"));
    }

    public static void initializeFromConfig(String configFile) {
        JetTest.initializeFromConfig(configFile, System.getProperty("jetHome"));
    }

    public static String getConfig(String property) {
        String value = config.getProperty(property);
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public static String getConfigFile(String property) {
        String fileName = config.getProperty(property);
        if (fileName == null) {
            return null;
        }
        if (fileName.startsWith("./") || new File(fileName).isAbsolute()) {
            return fileName;
        }
        return dataPath + File.separatorChar + fileName;
    }

    public static void initialize() {
        if (config.getProperty("Jet.encoding") != null) {
            JetTest.setEncoding(config.getProperty("Jet.encoding"));
        }
        JetTest.readLexicons();
        JetTest.readTags();
        JetTest.readNameTags();
        JetTest.readPatterns();
        JetTest.readGrammar();
        JetTest.readChunkModel();
        if (config.getProperty("StatParser.grammar.fileName") != null) {
            StatParser.initialize(dataPath, config);
        }
        Resolve.readGenderDict(dataPath, config);
        DepParser.initialize(dataPath, config);
        JetTest.readConcepts();
        JetTest.readGazetteer();
        JetTest.readENEData();
        JetTest.initTimex();
        String trace = config.getProperty("Resolve.trace");
        if (trace != null) {
            if (trace.equals("on")) {
                Resolve.trace = true;
            } else if (trace.equals("off")) {
                Resolve.trace = false;
            } else {
                System.err.println("*** Invalid value " + trace + " for Resolve.trace " + "(should be 'on' or 'off')");
            }
        }
        Resolve.useMaxEnt = config.getProperty("Resolve.useMaxEnt") != null;
    }

    public static void readLexicons() {
        Lexicon.clear();
        for (String string : config.keySet()) {
            if (!string.startsWith("EnglishLex.fileName")) continue;
            String fileName = JetTest.getConfigFile(string);
            try {
                EnglishLex.readLexicon(fileName);
            }
            catch (IOException ioe) {
                System.err.println("Error: reading lexicon file " + fileName + ", " + ioe.getMessage());
            }
        }
    }

    public static void readTags() {
        String fileName = JetTest.getConfigFile("Tags.fileName");
        if (fileName != null) {
            try {
                tagger = new HMMTagger();
                tagger.load(fileName);
            }
            catch (IOException ioe) {
                System.err.println("Error: reading tag file " + fileName + ", " + ioe.getMessage());
            }
        }
    }

    public static void readNameTags() {
        String wordClusters;
        String hmmFileName = JetTest.getConfigFile("NameTags.fileName");
        String meFileName = JetTest.getConfigFile("NameTags.ME.fileName");
        if (hmmFileName != null) {
            try {
                Class<Object> emitterClass;
                String emitter = config.getProperty("NameTags.emitter", "Jet.HMM.WordFeatureHMMemitter");
                try {
                    emitterClass = Class.forName(emitter);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Unknown HMM emitter class " + emitter);
                    System.err.println("Using class WordFeatureHMMemitter");
                    emitterClass = WordFeatureHMMemitter.class;
                }
                HMMNameTagger hmmNameTagger = new HMMNameTagger(emitterClass);
                hmmNameTagger.load(hmmFileName);
                if (config.getProperty("NameTags.trace") != null) {
                    hmmNameTagger.annotator.setTrace(true);
                }
                if (config.getProperty("NameTags.recordMargin") != null) {
                    hmmNameTagger.annotator.setRecordMargin(true);
                }
                nameTagger = hmmNameTagger;
            }
            catch (IOException ioe) {
                System.err.println("Error: reading name tag file " + hmmFileName + ", " + ioe.getMessage());
            }
        } else if (meFileName != null) {
            try {
                nameTagger = new MENameTagger();
                nameTagger.load(meFileName);
            }
            catch (IOException ioe) {
                System.err.println("Error: reading name tag file " + meFileName + ", " + ioe.getMessage());
            }
            String onoma = JetTest.getConfigFile("Onoma.fileName");
            try {
                if (onoma != null) {
                    Onoma.read(onoma);
                }
            }
            catch (IOException ioe) {
                System.err.println("Error: reading onoma file " + onoma + ", " + ioe.getMessage());
            }
        }
        if ((wordClusters = JetTest.getConfigFile("WordClusters.fileName")) != null) {
            try {
                MaxEntNE.loadWordClusters(wordClusters);
            }
            catch (IOException ioe) {
                System.err.println("Error: reading cluster file " + wordClusters + ", " + ioe.getMessage());
            }
        }
    }

    public static void readPatterns() {
        pc = new PatternCollection();
        for (String string : config.keySet()) {
            if (!string.startsWith("Pattern.fileName")) continue;
            String fileName = JetTest.getConfigFile(string);
            try {
                patternFile = new File(fileName);
                pc.readPatternCollection(new BufferedReader(new FileReader(patternFile)));
            }
            catch (IOException ioe) {
                System.err.println("Error: reading pattern file " + fileName + ", " + ioe.getMessage());
            }
        }
        pc.makePatternGraph();
        String string = config.getProperty("Pattern.trace");
        if (string != null) {
            if (string.equals("on")) {
                Pat.trace = true;
            } else if (string.equals("off")) {
                Pat.trace = false;
            } else {
                System.err.println("*** Invalid value " + string + " for Pattern.trace " + "(should be 'on' or 'off')");
            }
        }
    }

    public static void readGrammar() {
        String fileName = JetTest.getConfigFile("Grammar.fileName");
        if (fileName != null) {
            try {
                gram = new Grammar(new BufferedReader(new FileReader(fileName)));
            }
            catch (IOException ioe) {
                System.err.println("Error: reading grammar file " + fileName + ", " + ioe.getMessage());
            }
        }
    }

    public static void readChunkModel() {
        String fileName = JetTest.getConfigFile("Chunker.fileName");
        if (fileName != null) {
            Chunker.loadModel(fileName);
        }
    }

    public static void readConcepts() {
        String fileName = JetTest.getConfigFile("Concepts.fileName");
        if (fileName == null) {
            conceptHierarchyFile = null;
            conceptHierarchy = new ConceptHierarchy();
        } else {
            conceptHierarchyFile = new File(fileName);
            conceptHierarchy = new ConceptHierarchy(conceptHierarchyFile);
        }
    }

    public static void readGazetteer() {
        if (JetTest.getConfigFile("Gazetteer.fileName") != null) {
            try {
                Ace.gazetteer = new Gazetteer();
                Ace.gazetteer.load();
            }
            catch (IOException ioe) {
                System.err.println("Error reading gazetteer: " + ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void readENEData() {
        String rule;
        String trie = config.getProperty("ENE.dict.trie");
        String cdb = config.getProperty("ENE.dict.cdb");
        if (trie != null && cdb != null) {
            try {
                File trieFile = new File(dataPath, trie);
                File cdbFile = new File(dataPath, cdb);
                TrieDictionary dict = new TrieDictionary(trieFile.getPath(), cdbFile.getPath());
                extendedNameTagger.setDictionary(dict);
            }
            catch (IOException ex) {
                System.err.println("Error reading ENE dictionary: " + ex.getMessage());
            }
        }
        if ((rule = config.getProperty("ENE.rule")) != null) {
            File ruleFile = new File(dataPath, rule);
            BufferedReader in = null;
            try {
                Charset cs = Charset.forName(encoding);
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ruleFile), cs));
                extendedNameTagger.loadRules(in);
            }
            catch (IOException ex) {
                System.err.println("Error reading rule file: " + ex.getMessage());
                IOUtils.closeQuietly(in);
            }
            catch (RuleFormatException ex2) {
                System.err.println("Rule format error: " + ex2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(in);
            }
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTimex() {
        String ruleFile = config.getProperty("Timex.rule");
        String refTime = config.getProperty("Timex.refTime");
        String refFormat = config.getProperty("Timex.refFormat");
        if (ruleFile != null) {
            File file = new File(dataPath, ruleFile);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                timeAnnotator.load(in);
            }
            catch (IOException ex) {
                try {
                    System.err.println("Error reading rule file: " + ex.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
            IOUtils.closeQuietly(in);
        }
        if (refTime != null) {
            DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser();
            referenceTime = formatter.parseDateTime(refTime);
        }
        if (refFormat != null) {
            referenceTimeFormat = DateTimeFormat.forPattern((String)refFormat);
        }
    }

    public static DateTime getReferenceTime() {
        return referenceTime;
    }

    public static void setReferenceTime(DateTime reference) {
        referenceTime = reference;
    }

    public static DateTimeFormatter getReferenceTimeFormat() {
        return referenceTimeFormat;
    }

    public static TimeAnnotator getTimeAnnotator() {
        return timeAnnotator;
    }

    public static NumberAnnotator getNumberAnnotator() {
        return numberAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFile(String inputFileName, boolean viewable) throws IOException {
        long startTime = System.currentTimeMillis();
        File inputFile = inputFileName.startsWith("./") || new File(inputFileName).isAbsolute() ? new File(inputFileName) : new File(dataPath, inputFileName);
        BufferedReader rdr = null;
        BufferedWriter writer = null;
        try {
            Document doc;
            Charset cs = Charset.forName(encoding);
            rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), cs));
            if (config.getProperty("WriteSGML.type") != null) {
                File outputFile = new File(inputFile.getParent(), "response-" + inputFile.getName());
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));
            }
            int docNo = 0;
            while ((doc = JetTest.readDocument(rdr)) != null) {
                String readSGML = config.getProperty("ReadSGML.type");
                if (readSGML != null) {
                    String[] readSGMLtypes = readSGML.split("\\s*,\\s*");
                    doc = SGMLProcessor.sgmlToDoc(doc.text(), readSGMLtypes);
                    doc.stretchAll();
                }
                Control.processDocument(doc, writer, viewable, ++docNo);
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rdr);
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(rdr);
        IOUtils.closeQuietly(writer);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.err.println("Processing of file " + inputFileName + " took " + duration + " ms");
    }

    public static void processFiles(boolean viewable) {
        for (String string : config.keySet()) {
            if (!string.startsWith("JetTest.fileName")) continue;
            String inputFileName = config.getProperty(string);
            try {
                JetTest.processFile(inputFileName, viewable);
            }
            catch (IOException ioe) {
                System.err.println("Error: could not process document file " + inputFileName + ", " + ioe.getMessage());
            }
        }
    }

    public static void closeAllViews() {
        for (int i = 0; i < views.size(); ++i) {
            ((View)views.get(i)).dispose();
        }
        views.clear();
    }

    public static Document readDocument(BufferedReader rdr) throws IOException {
        int idEndOffset;
        String line;
        do {
            if ((line = rdr.readLine()) != null) continue;
            return null;
        } while (!line.startsWith("<DOC"));
        Document doc = new Document();
        doc.append(line);
        doc.append("\n");
        int idOffset = line.indexOf("id=\"");
        if (idOffset > 0 && (idEndOffset = line.indexOf("\"", idOffset += 4)) > 0) {
            docId = line.substring(idOffset, idEndOffset);
        }
        do {
            if ((line = rdr.readLine()) == null) {
                System.err.println("no </DOC>");
                return null;
            }
            if (line.startsWith("<DOCID>") && line.trim().endsWith("</DOCID>")) {
                String docIdLine = line.trim();
                docId = docIdLine.substring(7, docIdLine.length() - 8).trim();
            }
            doc.append(line);
            doc.append("\n");
        } while (!line.trim().equals("</DOC>"));
        return doc;
    }

    public static boolean setEncoding(String charset) {
        try {
            if (Charset.isSupported(charset)) {
                encoding = charset;
                return true;
            }
            System.err.println("Character set " + charset + " is not supported.");
        }
        catch (IllegalCharsetNameException e) {
            System.err.println(charset + " is an illegal character set name.");
        }
        SortedMap<String, Charset> allSets = Charset.availableCharsets();
        Iterator<String> it = allSets.keySet().iterator();
        System.err.println("Supported character sets are:");
        while (it.hasNext()) {
            String setName = it.next();
            Charset c = (Charset)allSets.get(setName);
            System.err.println("  " + setName + " " + c.aliases());
        }
        System.err.println(" ");
        return false;
    }

    static boolean hasDisplay() {
        try {
            new JFrame();
            return true;
        }
        catch (InternalError e) {
            return false;
        }
    }

    public static void main(String[] args) {
        String task;
        if (args.length > 0 && (task = args[0]).length() > 0 && task.charAt(0) == '-') {
            if (task.equals("-AnnotateCollection")) {
                CollectionAnnotationTool.task(args);
                return;
            }
            if (task.equals("-CorefEval")) {
                CorefEval.task(args);
                System.exit(0);
            } else if (task.equals("-BIOWriter")) {
                BIOWriter.task(args);
                System.exit(0);
            } else {
                if (task.equals("-CorefView")) {
                    EntityView.task(args);
                    return;
                }
                if (task.equals("-CollectionView")) {
                    CollectionView.task(args);
                    return;
                }
                System.err.println("Unknown Jet task: " + task);
                System.exit(1);
            }
        }
        if (args.length == 0) {
            if (!JetTest.hasDisplay()) {
                System.err.println("Error:  no configuration file selected.");
                System.err.println("USAGE: JetTest <configFile>");
                System.exit(1);
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Select Jet configuration file");
            File propsFile = new File(System.getProperty("user.dir"), "props");
            chooser.setCurrentDirectory(propsFile);
            int option = chooser.showOpenDialog(null);
            if (option == 0) {
                configFile = chooser.getSelectedFile();
            } else {
                System.err.println("Error:  no configuration file selected.");
                System.exit(1);
            }
        } else {
            configFile = new File(args[0]);
            if (args.length > 1) {
                System.err.println("Warning:  extra command line arguments ignored.");
            }
        }
        JetTest.initializeFromConfig(configFile);
        if (batchFlag) {
            JetTest.processFiles(false);
        } else {
            new Console();
        }
    }

    static {
        views = new Vector();
        encoding = "ISO-8859-1";
        docId = "";
        extendedNameTagger = new NameAnnotator();
        timeAnnotator = new TimeAnnotator();
        numberAnnotator = new NumberAnnotator();
        defaultConfig.put("processDocument", "tag(TEXT), TEXT:processTextZone");
        defaultConfig.put("processTextZone", "sentenceSplit, sentence:processSentence");
        config = new Properties(defaultConfig);
        validProperties.add("Jet.batch");
        validProperties.add("Jet.dataPath");
        validProperties.add("Jet.encoding");
        validProperties.add("DepParser.model.fileName");
        validProperties.add("DepParser.transformations");
        validProperties.add("StatParser.grammar.fileName");
        validProperties.add("StatParser.properties.fileName");
        validProperties.add("Resolve.trace");
        validProperties.add("Resolve.useMaxEnt");
        validProperties.add("NameGender.fileName");
        validProperties.add("EnglishLex.fileName*");
        validProperties.add("Tags.fileName*");
        validProperties.add("NameTags.fileName");
        validProperties.add("NameTags.emitter");
        validProperties.add("NameTags.recordMargin");
        validProperties.add("NameTags.trace");
        validProperties.add("NameTags.ME.fileName");
        validProperties.add("Onoma.fileName");
        validProperties.add("WordClusters.fileName");
        validProperties.add("Pattern.fileName*");
        validProperties.add("Pattern.trace");
        validProperties.add("Grammar.fileName");
        validProperties.add("Chunker.fileName");
        validProperties.add("Concepts.fileName");
        validProperties.add("Gazetteer.fileName");
        validProperties.add("ENE.dict.trie");
        validProperties.add("ENE.dict.cdb");
        validProperties.add("ENE.dict.rule");
        validProperties.add("Timex.rule");
        validProperties.add("Timex.refTime");
        validProperties.add("Timex.refFormat");
        validProperties.add("process*");
        validProperties.add("WriteSGML.type");
        validProperties.add("ReadSGML.type");
        validProperties.add("JetTest.fileName*");
    }
}

