/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ProcessDocuments {
    public static void main(String[] args) throws IOException {
        String docName;
        if (args.length != 6) {
            System.err.println("ProcessDocuments requires 6 arguments:");
            System.err.println("  propsFile docList inputDir inputSuffix outputDir outputSuffix");
            System.exit(1);
        }
        String propsFile = args[0];
        String docList = args[1];
        String inputDir = args[2];
        String inputSuffix = args[3];
        String outputDir = args[4];
        String outputSuffix = args[5];
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig(propsFile);
        EDTtype.readTypeDict();
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        int docCount = 0;
        BufferedReader docListReader = new BufferedReader(new FileReader(docList));
        while ((docName = docListReader.readLine()) != null) {
            ++docCount;
            String inputFile = docName + "." + inputSuffix;
            ExternalDocument doc = new ExternalDocument("sgml", inputDir, inputFile);
            doc.setAllTags(true);
            doc.open();
            String[] types = doc.getAnnotationTypes();
            doc.setSGMLwrapMargin(0);
            String outputFile = docName + "." + outputSuffix;
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, outputFile)));
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, writer, docCount == -1, docCount);
            writer.close();
        }
    }
}

