/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEntityName;
import edu.nyu.jet.aceJet.AceTimex;
import edu.nyu.jet.aceJet.AceTimexMention;
import edu.nyu.jet.aceJet.DepPathRelationTagger;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.aceJet.EventTagger;
import edu.nyu.jet.aceJet.FindAceValues;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.aceJet.PerfectAce;
import edu.nyu.jet.aceJet.PerfectNameTagger;
import edu.nyu.jet.aceJet.RelationPatternSet;
import edu.nyu.jet.aceJet.RelationTagger;
import edu.nyu.jet.format.InvalidFormatException;
import edu.nyu.jet.format.PTBReader;
import edu.nyu.jet.hmm.BigramHMMemitter;
import edu.nyu.jet.hmm.HMMstate;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.AddSyntacticRelations;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.scorer.NameTagger;
import edu.nyu.jet.time.TimeAnnotator;
import edu.nyu.jet.time.TimeMain;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SpecialZoner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ace {
    static final Logger logger = LoggerFactory.getLogger(Ace.class);
    public static boolean useParser = false;
    static final boolean useParseCollection = false;
    public static boolean perfectMentions = false;
    public static boolean perfectEntities = false;
    static final boolean asr = false;
    public static boolean preferRelations = false;
    public static boolean preferEntities = !preferRelations;
    public static boolean entityTrace = false;
    public static boolean monocase = false;
    static String fileList;
    public static Gazetteer gazetteer;
    static int aceEntityNo;
    static HashMap aceTypeDict;
    static final String suffix = ".sgm.apf";
    static String sourceType;
    public static RelationPatternSet eve;
    static EventTagger eventTagger;
    static String docDir;
    static String outputDir;
    static String parseDir;
    static String glarfDir;
    static int docCount;
    static String parseSuffix;
    static NameTagger realNameTagger;
    static boolean writeEventConfidence;
    static float MAX_UPPER;
    static String[] functionWord;
    static final String[] locativePrepositions;
    static final String[] genericFriendlyDeterminers;
    static final String[] clearGenericPronouns;

    public static void main(String[] args) throws IOException {
        String currentDocPath;
        Ace.initForFileIO(args);
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        boolean debug = false;
        while ((currentDocPath = reader.readLine()) != null) {
            if (debug) {
                Ace.processFile(currentDocPath);
                continue;
            }
            try {
                Ace.processFile(currentDocPath);
            }
            catch (Exception e) {
                logger.error("Error processing document " + fileList + "(" + docCount + ")=" + currentDocPath, (Throwable)e);
            }
        }
    }

    public static void initForFileIO(String[] args) throws IOException {
        logger.info("Starting ACE Jet...");
        if (args.length < 4 || args.length > 8) {
            logger.error("Ace must take 4 to 8 arguments:");
            logger.error("    properties filelist documentDir outputDir [parseDir [glarfDir [glarfSuffix [parseSuffix]]]]");
            System.exit(1);
        }
        String propertyFile = args[0];
        fileList = args[1];
        docDir = args[2];
        outputDir = args[3];
        parseDir = null;
        if (args.length >= 5) {
            parseDir = args[4];
        }
        String glarfDir = null;
        if (args.length >= 6) {
            glarfDir = args[5];
        }
        if (args.length >= 7) {
            EventTagger.triplesSuffix = args[6];
        }
        if (args.length == 8) {
            parseSuffix = args[7];
        }
        Ace.init(propertyFile);
    }

    public static void init(String propertyFile) throws IOException {
        String relationDepPathFile;
        String relationModelFile;
        Pat.trace = false;
        Resolve.trace = false;
        JetTest.initializeFromConfig(propertyFile);
        realNameTagger = JetTest.nameTagger;
        Ace.setAceYear();
        if (JetTest.getConfig("Ace.PerfectEntities") != null) {
            perfectMentions = true;
            perfectEntities = true;
        }
        Resolve.ACE = true;
        EDTtype.readTypeDict();
        EDTtype.readGenericDict();
        String valueDictFile = JetTest.getConfigFile("Ace.Value.fileName");
        if (valueDictFile != null) {
            FindAceValues.readTypeDict(valueDictFile);
        } else {
            logger.info("Ace:  no value dictionary file name specified in config file.");
            logger.info("      Will not tag values.");
        }
        String timeRulesFileName = JetTest.getConfigFile("Time.fileName");
        if (timeRulesFileName != null) {
            TimeMain.timeAnnotator = new TimeAnnotator(timeRulesFileName);
        } else {
            logger.info("Ace:  no time rules file name specified in config file.");
            logger.info("      Will not tag time expressions.");
        }
        String relationPatternFile = JetTest.getConfigFile("Ace.RelationPatterns.fileName");
        if (relationPatternFile != null) {
            eve = new RelationPatternSet();
            eve.load(relationPatternFile, 0);
        }
        if ((relationModelFile = JetTest.getConfigFile("Ace.RelationModel.fileName")) != null) {
            RelationTagger.loadModels(relationModelFile);
        }
        if ((relationDepPathFile = JetTest.getConfigFile("Ace.RelationDepPaths.fileName")) != null) {
            DepPathRelationTagger.loadModel(relationDepPathFile);
        }
        if (relationPatternFile == null && relationModelFile == null && relationDepPathFile == null) {
            logger.info("Ace:  no relation model specified in config file");
            logger.info("      Will not tag relations.");
        }
        RelationTagger.tagSameSentence = JetTest.getConfigFile("Ace.Relations.tagSameSentence") != null;
        String eventModelsDir = JetTest.getConfigFile("Ace.EventModels.directory");
        if (eventModelsDir != null) {
            eventTagger = new EventTagger();
            EventTagger.useParser = useParser;
            EventTagger.usePA = glarfDir != null;
            EventTagger.glarfDir = glarfDir;
            String eventPatternFile = eventModelsDir + "eventPatterns.log";
            eventTagger.load(eventPatternFile);
            eventTagger.loadAllModels(eventModelsDir);
        } else {
            logger.info("Ace:  no event model file name specified in config file");
            logger.info("      Will not tag events.");
        }
        writeEventConfidence = JetTest.getConfigFile("Ace.writeEventConfidence") != null;
        EventTagger.EVENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.eventProbabilityThreshold", EventTagger.EVENT_PROBABILITY_THRESHOLD);
        EventTagger.ARGUMENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.argumentProbabilityThreshold", EventTagger.ARGUMENT_PROBABILITY_THRESHOLD);
    }

    static double getConfigDouble(String paramName, double defaultValue) {
        String paramValue = JetTest.getConfig(paramName);
        if (paramValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(paramValue);
        }
        catch (NumberFormatException e) {
            logger.error("Error in Jet parameter " + paramName + " = " + paramValue);
            logger.error(e.toString());
            return defaultValue;
        }
    }

    static void setAceYear() {
        String aceYear = JetTest.getConfig("Ace.Year");
        if (aceYear != null) {
            Ace.setAceYear(aceYear);
        }
    }

    static void setAceYear(String aceYear) {
        if (aceYear.equals("2003")) {
            AceDocument.ace2004 = false;
            AceDocument.ace2005 = false;
        } else if (aceYear.equals("2004")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = false;
        } else if (aceYear.equals("2005")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = true;
        } else {
            logger.error("Unrecognized value " + aceYear + " for Ace.Year");
        }
    }

    public static void processFileAndCatchError(String currentDocPath) throws IOException {
        try {
            Ace.processFile(currentDocPath);
        }
        catch (Exception e) {
            logger.error("Error processing document " + docCount + " = " + currentDocPath, (Throwable)e);
        }
    }

    public static void processFile(String currentDocPath) throws IOException {
        logger.info("\nProcessing document " + ++docCount + ": " + currentDocPath);
        String currentDocFileName = new File(currentDocPath).getName();
        String currentDocId = Ace.removeFileExtension(currentDocFileName);
        String currentDocPathBase = Ace.removeFileExtension(currentDocPath);
        ExternalDocument doc = new ExternalDocument("sgml", docDir + currentDocPath);
        if (perfectMentions) {
            String textFile = docDir + currentDocPath;
            String keyFile = docDir + currentDocPathBase + ".apf.xml";
            AceDocument keyDoc = new AceDocument(textFile, keyFile);
            PerfectAce.buildEntityMentionMap(doc, keyDoc);
            JetTest.nameTagger = new PerfectNameTagger(keyDoc, realNameTagger);
        }
        doc.setAllTags(true);
        doc.open();
        AceDocument aceDoc = Ace.processDocument(doc, currentDocId, currentDocFileName, currentDocPathBase);
        String apfFileName = outputDir + currentDocPathBase + suffix;
        PrintWriter apf = new PrintWriter(apfFileName, JetTest.encoding);
        aceDoc.write(apf, doc);
    }

    public static AceDocument processDocument(Document doc, String sourceId, String sourceFile, String docPathBase) throws IOException {
        Annotation doctype;
        String source;
        doc.stretchAll();
        monocase = Ace.allLowerCase(doc);
        logger.trace("Monocase is " + monocase);
        gazetteer.setMonocase(monocase);
        BigramHMMemitter.useBigrams = monocase;
        double d = HMMstate.otherPreference = monocase ? 1.0 : 0.0;
        if (doc.annotationsOfType("dateline") == null && doc.annotationsOfType("textBreak") == null) {
            SpecialZoner.findSpecialZones(doc);
        }
        Control.processDocument(doc, null, docCount == -1, docCount);
        if (parseDir != null && !parseDir.equals("-")) {
            String parseFileName = parseDir + docPathBase + parseSuffix;
            try {
                File f = new File(parseFileName);
                PTBReader ptbReader = new PTBReader();
                List<ParseTreeNode> trees = ptbReader.loadParseTrees(f);
                List<Integer> offsets = ptbReader.getOffsets();
                ptbReader.addAnnotations(trees, offsets, doc, "sentence", new Span(0, doc.text().length()), true);
            }
            catch (InvalidFormatException e) {
                logger.error("Format error in reading parse tree from file " + parseFileName);
            }
            catch (IOException e) {
                logger.error("IO error reading parse tree from file " + parseFileName);
                logger.error("   " + e);
            }
            Vector<Annotation> sentences = doc.annotationsOfType("sentence");
            if (sentences != null) {
                for (Annotation sentence : sentences) {
                    AddSyntacticRelations.annotate(doc, sentence.span());
                    Resolve.references(doc, sentence.span());
                }
            }
        }
        Ace.tagReciprocalRelations(doc);
        String docId = Ace.getDocId(doc);
        if (docId == null) {
            docId = sourceId;
        }
        sourceType = "text";
        Vector<Annotation> doctypes = doc.annotationsOfType("DOCTYPE");
        if (doctypes != null && doctypes.size() > 0 && (source = (String)(doctype = doctypes.get(0)).get("SOURCE")) != null) {
            sourceType = source;
        }
        AceDocument aceDoc = new AceDocument(sourceFile, sourceType, docId, doc.text());
        Ace.buildAceEntities(doc, docId, aceDoc);
        if (TimeMain.timeAnnotator != null) {
            Ace.buildTimex(doc, aceDoc, docId);
        }
        if (FindAceValues.isDictLoaded()) {
            FindAceValues.buildAceValues(doc, docId, aceDoc);
        }
        if (eve != null) {
            LearnRelations.findRelations(docId, doc, aceDoc);
        } else if (RelationTagger.model0 != null) {
            RelationTagger.findRelations(docId, doc, aceDoc);
        } else if (DepPathRelationTagger.model != null) {
            DepPathRelationTagger.findRelations(docId, doc, aceDoc);
        }
        if (eventTagger != null) {
            eventTagger.tag(doc, aceDoc, docPathBase, docId);
        }
        if (FindAceValues.isDictLoaded()) {
            FindAceValues.pruneAceValues(aceDoc);
        }
        return aceDoc;
    }

    public static String getDocId(Document doc) {
        Annotation docAnn;
        Object docId;
        Vector<Annotation> docIdAnns = doc.annotationsOfType("DOCID");
        if (docIdAnns != null && docIdAnns.size() > 0) {
            Annotation docIdAnn = docIdAnns.get(0);
            return doc.text(docIdAnn).trim();
        }
        docIdAnns = doc.annotationsOfType("DOCNO");
        if (docIdAnns != null && docIdAnns.size() > 0) {
            Annotation docIdAnn = docIdAnns.get(0);
            return doc.text(docIdAnn).trim();
        }
        Vector<Annotation> docAnns = doc.annotationsOfType("document");
        if (docAnns != null && docAnns.size() > 0 && (docId = (docAnn = docAnns.get(0)).get("DOCID")) != null && docId instanceof String) {
            return (String)docId;
        }
        docAnns = doc.annotationsOfType("DOC");
        if (docAnns != null && docAnns.size() > 0 && (docId = (docAnn = docAnns.get(0)).get("id")) != null && docId instanceof String) {
            return (String)docId;
        }
        return null;
    }

    public static boolean allLowerCase(Document doc) {
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        Span span = textSegments != null && textSegments.size() > 0 ? textSegments.get(0).span() : doc.fullSpan();
        return Ace.allLowerCase(doc, span);
    }

    public static boolean allLowerCase(Document doc, Span span) {
        int countLower = 0;
        int countUpper = 0;
        for (int i = span.start(); i < span.end(); ++i) {
            if (Character.isUpperCase(doc.charAt(i))) {
                ++countUpper;
            }
            if (!Character.isLowerCase(doc.charAt(i))) continue;
            ++countLower;
        }
        int totalLetters = countLower + countUpper;
        return countUpper == 0 || (float)countUpper > (float)totalLetters * MAX_UPPER;
    }

    public static boolean titleCase(Document doc, Span span) {
        boolean allTitle = true;
        String text = doc.text(span);
        block0: for (int i = 0; i < text.length() - 1; ++i) {
            if (!Character.isWhitespace(text.charAt(i)) || !Character.isLowerCase(text.charAt(i + 1))) continue;
            for (int j = 0; j < functionWord.length; ++j) {
                if (text.startsWith(functionWord[j], i + 1)) continue block0;
            }
            allTitle = false;
        }
        return allTitle;
    }

    static String removeFileExtension(String path) {
        String fileName = new File(path).getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return path.substring(0, i += path.length() - fileName.length());
        }
        return path;
    }

    public static void buildAceEntities(Document doc, String docId, AceDocument aceDoc) {
        aceEntityNo = 0;
        LearnRelations.resetMentions();
        String docText = doc.text();
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        if (entities != null) {
            for (int ientity = 0; ientity < entities.size(); ++ientity) {
                AceEntity aceEntity = Ace.buildEntity(entities.get(ientity), ientity, doc, docId, docText);
                if (aceEntity == null) continue;
                aceDoc.addEntity(aceEntity);
            }
        }
        logger.info("buildAceEntities: generated " + aceDoc.entities.size() + " entities");
    }

    private static AceEntity buildEntity(Annotation entity, int ientity, Document doc, String docId, String docText) {
        Vector mentions = (Vector)entity.get("mentions");
        Annotation firstMention = (Annotation)mentions.get(0);
        String aceTypeSubtype = EDTtype.getTypeSubtype(doc, entity, firstMention);
        String aceType = EDTtype.bareType(aceTypeSubtype);
        if (entityTrace) {
            logger.trace("Type of " + Resolve.normalizeName(doc.text(firstMention)) + " is " + aceTypeSubtype);
        }
        if (aceType.equals("OTHER")) {
            return null;
        }
        String aceSubtype = EDTtype.subtype(aceTypeSubtype);
        boolean generic = Ace.isGeneric(doc, firstMention);
        if (generic) {
            logger.trace("Identified generic mention " + Resolve.normalizeName(doc.text(firstMention)));
        }
        ++aceEntityNo;
        if (entityTrace) {
            logger.trace("Generating ace entity " + aceEntityNo + " (internal entity " + ientity + ") = " + Resolve.normalizeName(doc.text(firstMention)) + " [" + aceType + "]");
        }
        String entityID = docId + "-" + aceEntityNo;
        AceEntity aceEntity = new AceEntity(entityID, aceType, aceSubtype, generic);
        for (int imention = 0; imention < mentions.size(); ++imention) {
            boolean isNameMention;
            Annotation mention = (Annotation)mentions.get(imention);
            Annotation head = Resolve.getHeadC(mention);
            String mentionID = entityID + "-" + imention;
            AceEntityMention aceMention = Ace.buildMention(mention, head, mentionID, aceType, doc, docText);
            aceEntity.addMention(aceMention);
            LearnRelations.addMention(aceMention);
            boolean bl = isNameMention = aceMention.type == "NAME";
            if (!isNameMention) continue;
            aceEntity.addName(new AceEntityName(head.span(), docText));
        }
        return aceEntity;
    }

    private static AceEntityMention buildMention(Annotation mention, Annotation head, String mentionID, String entityType, Document doc, String docText) {
        Span mentionSpan = mention.span();
        Span headSpan = head.span();
        String mentionType = Ace.mentionType(head, mention);
        AceEntityMention m = new AceEntityMention(mentionID, mentionType, mentionSpan, headSpan, docText);
        if (entityType.equals("GPE")) {
            String prep;
            m.role = perfectMentions ? PerfectAce.getMentionRole(head) : ((prep = Ace.governingPreposition(doc, mention)) != null && Ace.in(prep, locativePrepositions) || Resolve.sentenceSet.sentenceNumber(mention.start()) == 0 ? "LOC" : "GPE");
        }
        return m;
    }

    private static String mentionType(Annotation head, Annotation mention) {
        if (perfectMentions) {
            return PerfectAce.getMentionType(head);
        }
        String cat = (String)head.get("cat");
        String mcat = (String)mention.get("cat");
        if (cat == "n" || cat == "title" || cat == "tv" || cat == "v") {
            return "NOMINAL";
        }
        if (cat == "pro" || cat == "det" || cat == "adj" || cat == "ven" || cat == "q" || cat == "np" || cat == "wp" || cat == "wp$") {
            return "PRONOUN";
        }
        if (mention.get("nameWithModifier") != null) {
            return "NOMINAL";
        }
        return "NAME";
    }

    private static boolean isGeneric(Document doc, Annotation mention) {
        Annotation ngHead = Ace.getNgHead(mention);
        Annotation headC = Resolve.getHeadC(mention);
        if (headC.get("cat") == "n") {
            FeatureSet vpa;
            String det = SynFun.getDet(mention);
            if (det != null && Ace.in(det, genericFriendlyDeterminers)) {
                return true;
            }
            if (!EDTtype.hasGenericHead(doc, mention)) {
                return false;
            }
            if (ngHead.get("poss") != null || det == "poss") {
                return false;
            }
            if (ngHead.get("quant") != null || det == "q") {
                return false;
            }
            Annotation vg = Ace.governingVerbGroup(mention);
            if (vg != null && (vpa = (FeatureSet)vg.get("pa")) != null && vpa.get("tense") != "past" && vpa.get("aspect") == null) {
                logger.trace("Governing verb group = " + doc.text(vg));
                logger.trace("Verb group pa = " + vpa);
                return true;
            }
            return false;
        }
        if (headC.get("cat") == "pro" || headC.get("cat") == "np" || headC.get("cat") == "det") {
            String pronoun = SynFun.getHead(doc, mention);
            return Ace.in(pronoun, clearGenericPronouns) || Ace.in(pronoun, genericFriendlyDeterminers);
        }
        return false;
    }

    private static Annotation getNgHead(Annotation ng) {
        Annotation hd = ng;
        while ((ng = (Annotation)hd.get("headC")) != null) {
            if (ng.get("cat") != "np" || ng.get("possPrefix") == "true") {
                return hd;
            }
            hd = ng;
        }
        return hd;
    }

    private static void buildTimex(Document doc, AceDocument aceDoc, String docId) {
        TimeMain.processDocument(doc);
        Vector<Annotation> v = doc.annotationsOfType("TIMEX2");
        if (v != null) {
            logger.info(v.size() + " time expressions found.");
            for (int i = 0; i < v.size(); ++i) {
                Annotation ann = v.get(i);
                String docText = doc.text();
                String timeId = docId + "-T" + i;
                String val = (String)ann.get("VAL");
                if (val == null) {
                    logger.warn("TIMEX " + timeId + " has no VAL.");
                }
                AceTimexMention mention = new AceTimexMention(timeId + "-1", ann.span(), docText);
                AceTimex timex = new AceTimex(timeId, val);
                timex.addMention(mention);
                aceDoc.addTimeExpression(timex);
            }
        }
    }

    private static boolean in(Object o, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static void tagReciprocalRelations(Document doc) {
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (int j = 0; j < constits.size(); ++j) {
                Annotation object;
                Annotation subject;
                Annotation ann = constits.elementAt(j);
                if (ann.get("subject") != null && (subject = (Annotation)ann.get("subject")).get("subject-1") == null) {
                    subject.put("subject-1", ann);
                }
                if (ann.get("object") == null || (object = (Annotation)ann.get("object")).get("object-1") != null) continue;
                object.put("object-1", ann);
            }
        }
    }

    static Annotation governingVerbGroup(Annotation ann) {
        Annotation governingConstituent;
        if (ann.get("subject-1") != null) {
            governingConstituent = (Annotation)ann.get("subject-1");
        } else if (ann.get("object-1") != null) {
            governingConstituent = (Annotation)ann.get("object-1");
        } else {
            return null;
        }
        return Resolve.getHeadC(governingConstituent);
    }

    static String governingPreposition(Document doc, Annotation ann) {
        Annotation pp = (Annotation)ann.get("p-obj-1");
        if (pp == null) {
            return null;
        }
        Annotation[] ppChildren = (Annotation[])pp.get("children");
        if (ppChildren.length != 2) {
            return null;
        }
        Annotation in = ppChildren[0];
        String prep = doc.text(in).trim();
        return prep;
    }

    public static void setPatternSet(String fileName) throws IOException {
        eve = new RelationPatternSet();
        eve.load(fileName, 0);
    }

    static {
        sourceType = "text";
        eve = null;
        eventTagger = null;
        docCount = 0;
        parseSuffix = ".sgm.sent.chout";
        writeEventConfidence = false;
        MAX_UPPER = 0.5f;
        functionWord = new String[]{"a ", "an ", "the ", "his ", "her ", "its ", "against ", "as ", "at ", "by ", "due to ", "for ", "from ", "in ", "into ", "of ", "over ", "to ", "with ", "within ", "and ", "not ", "or ", "can ", "be ", "will "};
        locativePrepositions = new String[]{"in", "at", "to", "near"};
        genericFriendlyDeterminers = new String[]{"no", "neither", "any", "many", "every", "each"};
        clearGenericPronouns = new String[]{"everyone", "anyone", "everybody", "anybody", "something", "who", "whoever", "whomever", "wherever", "whatever", "where"};
        JetTest.validProperties.add("Ace.PerfectEntities");
        JetTest.validProperties.add("Ace.Value.fileName");
        JetTest.validProperties.add("Time.fileName");
        JetTest.validProperties.add("Ace.RelationPatterns.fileName");
        JetTest.validProperties.add("Ace.RelationModel.fileName");
        JetTest.validProperties.add("Ace.RelationDepPaths.fileName");
        JetTest.validProperties.add("Ace.Relations.tagSameSentence");
        JetTest.validProperties.add("Ace.EventModels.directory");
        JetTest.validProperties.add("Ace.writeEventConfidence");
        JetTest.validProperties.add("Ace.EventModels.eventProbabilityThreshold");
        JetTest.validProperties.add("Ace.EventModels.argumentProbabilityThreshold");
        JetTest.validProperties.add("Ace.Year");
        JetTest.validProperties.add("Ace.extendedAPF");
        JetTest.validProperties.add("Ace.EDTtype.fileName");
        JetTest.validProperties.add("Ace.generic.fileName");
        JetTest.validProperties.add("Ace.writeEventConfidence");
        JetTest.validProperties.add("Ace.EventModels.eventProbabilityThreshold");
        JetTest.validProperties.add("Ace.EventModels.argumentProbabilityThreshold");
        JetTest.validProperties.add("Ace.Value.fileName");
        JetTest.validProperties.add("Gazetteer.fileName");
        JetTest.validProperties.add("Ace.NameSubtypeModel.fileName");
    }
}

