/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.AcePlus;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.aceJet.AceTimex;
import edu.nyu.jet.aceJet.AceValue;
import edu.nyu.jet.tipster.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceDocument {
    public static boolean ace2004 = true;
    public static boolean ace2005 = true;
    private static DocumentBuilder builder = null;
    private String fileText;
    private StringBuffer fileTextWithXML;
    public String sourceFile;
    public String sourceType;
    public String docID;
    public ArrayList<AceEntity> entities = new ArrayList();
    public ArrayList<AceTimex> timeExpressions = new ArrayList();
    public ArrayList<AceValue> values = new ArrayList();
    public ArrayList<AceRelation> relations = new ArrayList();
    public ArrayList<AceEvent> events = new ArrayList();
    private static final String encoding = "ISO-8859-1";
    TreeSet<AceMention> allMentionsSet = new TreeSet();
    ArrayList<AceMention> allMentionsList = new ArrayList();

    public AceDocument(String sourceFile, String sourceType, String docID, String docText) {
        this.sourceFile = sourceFile;
        this.sourceType = sourceType;
        this.docID = docID;
        this.fileText = docText;
    }

    public AceDocument(String textFileName, String APFfileName) {
        try {
            if (builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                builder = factory.newDocumentBuilder();
            }
            this.analyzeDocument(textFileName, APFfileName);
        }
        catch (SAXException e) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + e);
        }
        catch (IOException e) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + e);
        }
        catch (ParserConfigurationException e) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + e);
        }
    }

    private void analyzeDocument(String textFileName, String APFfileName) throws SAXException, IOException {
        org.w3c.dom.Document apfDoc = builder.parse(APFfileName);
        this.fileTextWithXML = AceDocument.readDocument(textFileName);
        this.fileText = AceDocument.eraseXML(this.fileTextWithXML);
        this.readAPFdocument(apfDoc, this.fileText);
    }

    void readAPFdocument(org.w3c.dom.Document apfDoc, String fileText) {
        NodeList sourceFileElements = apfDoc.getElementsByTagName("source_file");
        Element sourceFileElement = (Element)sourceFileElements.item(0);
        this.sourceFile = sourceFileElement.getAttribute("URI");
        this.sourceType = sourceFileElement.getAttribute("SOURCE");
        NodeList documentElements = apfDoc.getElementsByTagName("document");
        Element documentElement = (Element)documentElements.item(0);
        this.docID = documentElement.getAttribute("DOCID");
        if (Ace.perfectMentions & !Ace.perfectEntities) {
            this.readPerfectMentions(apfDoc, fileText);
            return;
        }
        NodeList entityElements = apfDoc.getElementsByTagName("entity");
        for (int i = 0; i < entityElements.getLength(); ++i) {
            Element entityElement = (Element)entityElements.item(i);
            AceEntity entity = new AceEntity(entityElement, fileText);
            this.addEntity(entity);
        }
        NodeList valueElements = apfDoc.getElementsByTagName("value");
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Element valueElement = (Element)valueElements.item(i);
            AceValue value = new AceValue(valueElement, fileText);
            this.addValue(value);
        }
        NodeList timexElements = apfDoc.getElementsByTagName("timex2");
        for (int i = 0; i < timexElements.getLength(); ++i) {
            Element timexElement = (Element)timexElements.item(i);
            AceTimex timex = new AceTimex(timexElement, fileText);
            this.addTimeExpression(timex);
        }
        NodeList relationElements = apfDoc.getElementsByTagName("relation");
        for (int i = 0; i < relationElements.getLength(); ++i) {
            Element relationElement = (Element)relationElements.item(i);
            AceRelation relation = new AceRelation(relationElement, this, fileText);
            this.addRelation(relation);
        }
        NodeList eventElements = apfDoc.getElementsByTagName("event");
        for (int i = 0; i < eventElements.getLength(); ++i) {
            Element eventElement = (Element)eventElements.item(i);
            AceEvent event = new AceEvent(eventElement, this, fileText);
            this.addEvent(event);
        }
    }

    public void addEntity(AceEntity entity) {
        this.entities.add(entity);
        this.allMentionsSet.addAll(entity.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addValue(AceValue value) {
        this.values.add(value);
        this.allMentionsSet.addAll(value.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addTimeExpression(AceTimex timex) {
        this.timeExpressions.add(timex);
        this.allMentionsSet.addAll(timex.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addRelation(AceRelation relation) {
        this.relations.add(relation);
    }

    public void addEvent(AceEvent event) {
        this.events.add(event);
    }

    static String getElementText(Element e, String elementType) {
        NodeList typeList = e.getElementsByTagName(elementType);
        Element typeElement = (Element)typeList.item(0);
        String text = typeElement.getFirstChild().getNodeValue();
        return text;
    }

    void readPerfectMentions(org.w3c.dom.Document apfDoc, String fileText) {
        NodeList mentionElements = apfDoc.getElementsByTagName("entity_mention");
        for (int i = 0; i < mentionElements.getLength(); ++i) {
            Element mentionElement = (Element)mentionElements.item(i);
            String entityId = "E" + mentionElement.getAttribute("ID");
            String type = mentionElement.getAttribute("ENTITY_TYPE");
            if (AceEntity.standardType.containsKey(type)) {
                type = (String)AceEntity.standardType.get(type);
            }
            String subtype = mentionElement.getAttribute("ENTITY_SUBTYPE");
            if (!type.equals("PERSON") && !type.equals("") && subtype.equals("")) {
                subtype = "Other";
            }
            AceEntityMention mention = new AceEntityMention(mentionElement, fileText);
            AceEntity entity = new AceEntity(entityId, type, subtype, false);
            entity.addMention(mention);
            this.addEntity(entity);
        }
    }

    static StringBuffer readDocument(String fileName) throws IOException {
        String line;
        File file = new File(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        StringBuffer fileText = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            fileText.append(line + "\n");
        }
        return fileText;
    }

    static String eraseXML(StringBuffer fileTextWithXML) {
        boolean inTag = false;
        int length = fileTextWithXML.length();
        StringBuffer fileText = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = fileTextWithXML.charAt(i);
            if (c == '<') {
                inTag = true;
            }
            if (!inTag) {
                fileText.append(c);
            }
            if (c != '>') continue;
            inTag = false;
        }
        return fileText.toString();
    }

    public Document JetDocument() {
        if (this.fileTextWithXML == null) {
            this.fileTextWithXML = new StringBuffer();
            this.fileTextWithXML.append(this.fileText);
        }
        Document doc = new Document(this.fileTextWithXML.toString());
        doc.annotateWithTag("TEXT");
        return doc;
    }

    AceEntity findEntity(String id) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity entity = this.entities.get(i);
            if (!entity.id.equals(id)) continue;
            return entity;
        }
        System.err.println("*** unable to find entity with id " + id);
        return null;
    }

    AceEventArgumentValue findEntityValueTimex(String id) {
        int i;
        for (i = 0; i < this.values.size(); ++i) {
            AceValue value = this.values.get(i);
            if (!value.id.equals(id)) continue;
            return value;
        }
        for (i = 0; i < this.timeExpressions.size(); ++i) {
            AceTimex timex = this.timeExpressions.get(i);
            if (!timex.id.equals(id)) continue;
            return timex;
        }
        return this.findEntity(id);
    }

    AceEntityMention findEntityMention(String id) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity entity = this.entities.get(i);
            AceEntityMention mention = entity.findMention(id);
            if (mention == null) continue;
            return mention;
        }
        System.err.println("*** unable to find entity mention with id " + id);
        return null;
    }

    AceMention findMention(String id) {
        AceMention mention;
        int i;
        for (i = 0; i < this.values.size(); ++i) {
            AceValue value = this.values.get(i);
            mention = value.findMention(id);
            if (mention == null) continue;
            return mention;
        }
        for (i = 0; i < this.timeExpressions.size(); ++i) {
            AceTimex timex = this.timeExpressions.get(i);
            mention = timex.findMention(id);
            if (mention == null) continue;
            return mention;
        }
        return this.findEntityMention(id);
    }

    ArrayList<AceMention> getAllMentions() {
        return this.allMentionsList;
    }

    public void write(PrintWriter w, Document doc) {
        int i;
        w.println("<?xml version=\"1.0\"?>");
        w.println("<!DOCTYPE source_file SYSTEM \"apf.v5.1.1.dtd\">");
        w.print("<source_file URI=\"" + this.sourceFile + "\"");
        w.println(" SOURCE=\"" + this.sourceType + "\" TYPE=\"text\" AUTHOR=\"NYU\">");
        w.println("<document DOCID=\"" + this.docID + "\">");
        String extendedAPF = JetTest.getConfig("Ace.extendedAPF");
        if (extendedAPF != null) {
            AcePlus.write(doc, w);
        }
        for (i = 0; i < this.entities.size(); ++i) {
            AceEntity entity = this.entities.get(i);
            entity.write(w);
        }
        for (i = 0; i < this.values.size(); ++i) {
            AceValue value = this.values.get(i);
            value.write(w);
        }
        for (i = 0; i < this.timeExpressions.size(); ++i) {
            AceTimex timex = this.timeExpressions.get(i);
            timex.write(w);
        }
        for (i = 0; i < this.relations.size(); ++i) {
            AceRelation relation = this.relations.get(i);
            relation.write(w);
        }
        for (i = 0; i < this.events.size(); ++i) {
            AceEvent event = this.events.get(i);
            event.write(w);
        }
        w.println("</document>");
        w.println("</source_file>");
        w.close();
    }

    public static void main(String[] args) {
        String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String ace = home + "ace 05/";
        String xmlFile = ace + "AFP_ENG_20030304.0250.apf.xml";
        String textFile = ace + "AFP_ENG_20030304.0250.sgm";
        AceDocument ad = new AceDocument(textFile, xmlFile);
        ad.write(new PrintWriter(System.out), null);
    }
}

