/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEntityName;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEntity
extends AceEventArgumentValue {
    public String type;
    public String subtype;
    public String entClass;
    public boolean generic;
    public ArrayList<AceEntityMention> mentions = new ArrayList();
    public ArrayList<AceEntityName> names = new ArrayList();
    static HashMap standardType = new HashMap();

    public AceEntity(String id, String type, String subtype, boolean generic) {
        this.id = id;
        this.type = type;
        this.subtype = subtype;
        this.generic = generic;
    }

    public AceEntity(Element entityElement, String fileText) {
        this.id = entityElement.getAttribute("ID");
        if (AceDocument.ace2004) {
            this.type = entityElement.getAttribute("TYPE");
            this.subtype = entityElement.getAttribute("SUBTYPE");
            this.entClass = entityElement.getAttribute("CLASS");
            this.generic = !this.entClass.equals("SPC");
        } else {
            NodeList entityTypeList = entityElement.getElementsByTagName("entity_type");
            Element entityType = (Element)entityTypeList.item(0);
            String genericString = entityType.getAttribute("GENERIC");
            this.generic = genericString.equals("TRUE");
            this.entClass = null;
            this.type = AceDocument.getElementText(entityElement, "entity_type");
        }
        if (standardType.containsKey(this.type)) {
            this.type = (String)standardType.get(this.type);
        }
        NodeList mentionElements = entityElement.getElementsByTagName("entity_mention");
        for (int j = 0; j < mentionElements.getLength(); ++j) {
            Element mentionElement = (Element)mentionElements.item(j);
            AceEntityMention mention = new AceEntityMention(mentionElement, fileText);
            this.addMention(mention);
        }
        for (int i = 0; i < this.mentions.size() - 1; ++i) {
            for (int j = i + 1; j < this.mentions.size(); ++j) {
                AceEntityMention meni = this.mentions.get(i);
                AceEntityMention menj = this.mentions.get(j);
                if (meni.head.end() <= menj.head.end()) continue;
                this.mentions.set(i, menj);
                this.mentions.set(j, meni);
            }
        }
        NodeList entityAttributesList = entityElement.getElementsByTagName("entity_attributes");
        if (entityAttributesList.getLength() > 0) {
            Element entityAttributes = (Element)entityAttributesList.item(0);
            NodeList nameList = entityAttributes.getElementsByTagName("name");
            for (int j = 0; j < nameList.getLength(); ++j) {
                Element nameElement = (Element)nameList.item(j);
                AceEntityName name = new AceEntityName(nameElement, fileText);
                this.addName(name);
            }
        }
    }

    public void addMention(AceEntityMention mention) {
        this.mentions.add(mention);
        mention.entity = this;
    }

    public void addName(AceEntityName name) {
        this.names.add(name);
    }

    public AceEntityMention findMention(String id) {
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceEntityMention mention = this.mentions.get(i);
            if (!mention.id.equals(id)) continue;
            return mention;
        }
        return null;
    }

    public void write(PrintWriter w) {
        int i;
        if (AceDocument.ace2004) {
            w.print("  <entity ID=\"" + this.id + "\"");
            if (this.type != null && !this.type.equals("")) {
                w.print(" TYPE=\"" + this.type.substring(0, 3) + "\"");
            }
            if (this.subtype != null && !this.subtype.equals("")) {
                w.print(" SUBTYPE=\"" + this.subtype + "\"");
            }
            if (this.entClass != null) {
                w.println(" CLASS=\"" + this.entClass + "\">");
            } else {
                w.println(" CLASS=\"" + (this.generic ? "GEN" : "SPC") + "\">");
            }
        } else {
            w.println("  <entity ID=\"" + this.id + "\">");
            w.println("    <entity_type GENERIC=\"" + (this.generic ? "TRUE" : "FALSE") + "\">" + this.type + "</entity_type>");
        }
        for (i = 0; i < this.mentions.size(); ++i) {
            AceEntityMention mention = this.mentions.get(i);
            mention.write(w);
        }
        w.println("    <entity_attributes>");
        for (i = 0; i < this.names.size(); ++i) {
            AceEntityName name = this.names.get(i);
            name.write(w);
        }
        w.println("    </entity_attributes>");
        w.println("  </entity>");
    }

    static {
        standardType.put("GSP", "GPE");
        standardType.put("PER", "PERSON");
        standardType.put("ORG", "ORGANIZATION");
        standardType.put("LOC", "LOCATION");
        standardType.put("FAC", "FACILITY");
    }
}

