/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Vector;

public class AceEventAnchor
extends AceMention {
    Span head;
    Span jetHead;
    boolean passive = false;
    int NP_SEARCH_WINDOW = 40;

    public AceEventAnchor(Span head, Span jetHead, String text, Document doc) {
        this.head = head;
        this.jetHead = jetHead;
        this.extent = head;
        this.jetExtent = jetHead;
        this.text = text;
        this.computeJetExtent(jetHead, doc);
    }

    public AceEventArgumentValue getParent() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Span getJetHead() {
        return this.jetHead;
    }

    private void computeJetExtent(Span jetHead, Document doc) {
        int begin;
        int headStart;
        Vector<Annotation> constits = doc.annotationsEndingAt(jetHead.end(), "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation ann = constits.get(i);
                if (ann.get("cat") == "vg") {
                    this.jetExtent = ann.span();
                    return;
                }
                if (ann.get("cat") != "vg-pass") continue;
                this.jetExtent = ann.span();
                this.passive = true;
                return;
            }
        }
        for (int k = begin = (headStart = jetHead.start()) < this.NP_SEARCH_WINDOW ? 0 : headStart - this.NP_SEARCH_WINDOW; k <= headStart; ++k) {
            constits = doc.annotationsAt(k, "constit");
            if (constits == null) {
                return;
            }
            for (int i = 0; i < constits.size(); ++i) {
                Annotation headC;
                Annotation ann = constits.get(i);
                if (ann.get("cat") != "np" || (headC = Resolve.getHeadC(ann)).span().start() != jetHead.start() || ann.span().within(this.jetExtent)) continue;
                this.jetExtent = ann.span();
            }
        }
    }
}

