/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEventMention {
    public String id;
    public ArrayList<AceEventMentionArgument> arguments = new ArrayList();
    public Span extent;
    public Span jetExtent;
    public String text;
    public Span anchorExtent;
    public Span anchorJetExtent;
    public String anchorText;
    public double confidence = 1.0;

    public AceEventMention(String id, Span jetExtent, Span anchorJetExtent, String fileText) {
        this.id = id;
        this.arguments = new ArrayList();
        this.extent = AceEntityMention.convertSpan(jetExtent, fileText);
        this.jetExtent = jetExtent;
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        this.anchorExtent = AceEntityMention.convertSpan(anchorJetExtent, fileText);
        this.anchorJetExtent = anchorJetExtent;
        this.anchorText = fileText.substring(this.anchorExtent.start(), this.anchorExtent.end() + 1);
    }

    public AceEventMention(Element mentionElement, AceDocument acedoc, String fileText) {
        this.id = mentionElement.getAttribute("ID");
        NodeList extents = mentionElement.getElementsByTagName("extent");
        Element extentElement = (Element)extents.item(0);
        this.extent = AceEntityMention.decodeCharseq(extentElement);
        this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, fileText);
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        NodeList anchors = mentionElement.getElementsByTagName("anchor");
        Element anchorElement = (Element)anchors.item(0);
        this.anchorExtent = AceEntityMention.decodeCharseq(anchorElement);
        this.anchorText = fileText.substring(this.anchorExtent.start(), this.anchorExtent.end() + 1);
        this.anchorJetExtent = AceEntityMention.aceSpanToJetSpan(this.anchorExtent, fileText);
        NodeList arguments = mentionElement.getElementsByTagName("event_mention_argument");
        for (int j = 0; j < arguments.getLength(); ++j) {
            Element argumentElement = (Element)arguments.item(j);
            AceEventMentionArgument argument = new AceEventMentionArgument(argumentElement, acedoc);
            this.addArgument(argument);
        }
    }

    void addArgument(AceEventMentionArgument argument) {
        this.arguments.add(argument);
    }

    void setId(String id) {
        this.id = id;
    }

    public void write(PrintWriter w) {
        w.print("    <event_mention ID=\"" + this.id + "\"");
        if (Ace.writeEventConfidence) {
            w.format(" p=\"%5.3f\"", this.confidence);
        }
        w.println(">");
        w.println("      <extent>");
        AceEntityMention.writeCharseq(w, this.extent, this.text);
        w.println("      </extent>");
        w.println("      <anchor>");
        AceEntityMention.writeCharseq(w, this.anchorExtent, this.anchorText);
        w.println("      </anchor>");
        for (int i = 0; i < this.arguments.size(); ++i) {
            AceEventMentionArgument argument = this.arguments.get(i);
            argument.write(w);
        }
        w.println("    </event_mention>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.anchorText);
        buf.append("(");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            AceEventMentionArgument argument = this.arguments.get(i);
            buf.append(argument.toString());
        }
        buf.append(") ");
        return buf.toString();
    }
}

