/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.tipster.Document;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AcePatternNode {
    String type;
    String subtype;
    String head;
    static final int MATCH_SCORE_ANY_MENTION = 10000;
    static final int MATCH_SCORE_TYPE_MATCH = 10100;
    static final int MATCH_SCORE_SUBTYPE_MATCH = 10200;
    static final int MATCH_SCORE_WORD_MATCH = 10300;
    private AceMention lastMatchedMention = null;

    public AcePatternNode(AceMention mention) {
        this.type = mention.getType();
        if (mention instanceof AceEntityMention) {
            this.subtype = ((AceEntityMention)mention).entity.subtype;
            this.head = ((AceEntityMention)mention).headText.replace('\n', ' ');
        } else {
            this.subtype = "";
            this.head = mention.text.replace('\n', ' ');
        }
    }

    public AcePatternNode(String s) {
        if (s == null) {
            System.err.println("AcePatternNode: null constructor argument");
            return;
        }
        String[] fields = s.split(" \\| ");
        if (fields.length != 3) {
            System.err.println("AcePatternNode: invalid constructor argument: " + s);
            return;
        }
        this.type = fields[0];
        this.subtype = fields[1];
        this.head = fields[2];
    }

    public boolean equals(Object o) {
        if (!(o instanceof AcePatternNode)) {
            return false;
        }
        AcePatternNode p = (AcePatternNode)o;
        return this.type.equals(p.type) && this.subtype.equals(p.subtype) && this.head.equals(p.head);
    }

    public int hashCode() {
        return (this.type + this.subtype + this.head).hashCode();
    }

    public String toString() {
        return this.type + "." + this.subtype;
    }

    public void write(PrintWriter pw) {
        pw.println(this.type + " | " + this.subtype + " | " + this.head);
    }

    public int match(AceMention m) {
        int score = 10000;
        if (this.type.equals(m.getType())) {
            score = 10100;
            if (m instanceof AceEntityMention) {
                AceEntityMention aem = (AceEntityMention)m;
                if (this.subtype.equals(aem.entity.subtype)) {
                    score = 10200;
                    if (this.head.equals(aem.headText)) {
                        score = 10300;
                    }
                }
            }
        }
        return score;
    }

    public AceMention matchFromLeft(int posn, Document doc, AceDocument aceDoc) {
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        for (int i = 0; i < mentions.size(); ++i) {
            AceMention m = mentions.get(i);
            if (m.jetExtent.start() != posn || !this.type.equals(m.getType())) continue;
            return m;
        }
        return null;
    }

    public AceMention matchFromRight(int posn, Document doc, AceDocument aceDoc) {
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        for (int i = 0; i < mentions.size(); ++i) {
            AceMention m = mentions.get(i);
            if (m.jetExtent.end() != posn || !this.type.equals(m.getType())) continue;
            return m;
        }
        return null;
    }

    public int matchOnHead(int posn, Document doc, AceDocument aceDoc) {
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        for (int i = 0; i < mentions.size(); ++i) {
            int start;
            AceMention m = mentions.get(i);
            int n = start = m instanceof AceEntityMention ? ((AceEntityMention)m).jetHead.start() : m.extent.start();
            if (start != posn) continue;
            this.lastMatchedMention = m;
            return this.match(m);
        }
        this.lastMatchedMention = null;
        return -1;
    }

    public AceMention getMatchedMention() {
        return this.lastMatchedMention;
    }
}

