/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceRelationMention {
    public String id;
    public Span extent;
    public String text;
    public AceEntityMention arg1;
    public AceEntityMention arg2;
    public AceRelation relation;
    public double confidence = 1.0;

    public AceRelationMention(String id, AceEntityMention arg1, AceEntityMention arg2, Document doc) {
        this.id = id;
        this.arg1 = arg1;
        this.arg2 = arg2;
        int extentStart = Math.min(arg1.extent.start(), arg2.extent.start());
        int extentEnd = Math.max(arg1.extent.end(), arg2.extent.end());
        this.extent = new Span(extentStart, extentEnd);
        this.text = doc.text(new Span(extentStart, extentEnd + 1));
    }

    public AceRelationMention(Element mentionElement, AceDocument acedoc, String fileText) {
        this.id = mentionElement.getAttribute("ID");
        NodeList extents = mentionElement.getElementsByTagName("extent");
        Element extentElement = (Element)extents.item(0);
        this.extent = AceEntityMention.decodeCharseq(extentElement);
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        if (AceDocument.ace2005) {
            NodeList arguments = mentionElement.getElementsByTagName("relation_mention_argument");
            for (int j = 0; j < arguments.getLength(); ++j) {
                Element argument = (Element)arguments.item(j);
                String mentionid = argument.getAttribute("REFID");
                String role = argument.getAttribute("ROLE");
                if (role.equals("Arg-1")) {
                    this.arg1 = acedoc.findEntityMention(mentionid);
                    continue;
                }
                if (role.equals("Arg-2")) {
                    this.arg2 = acedoc.findEntityMention(mentionid);
                    continue;
                }
                if (AceRelation.timeRoles.contains(role)) continue;
                System.err.println("*** invalid ROLE for relation mention");
            }
        } else {
            NodeList arguments = mentionElement.getElementsByTagName("rel_mention_arg");
            for (int j = 0; j < arguments.getLength(); ++j) {
                Element argument = (Element)arguments.item(j);
                String mentionid = argument.getAttribute(AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID");
                String argnum = argument.getAttribute("ARGNUM");
                if (argnum.equals("1")) {
                    this.arg1 = acedoc.findEntityMention(mentionid);
                    continue;
                }
                if (argnum.equals("2")) {
                    this.arg2 = acedoc.findEntityMention(mentionid);
                    continue;
                }
                System.err.println("*** invalid ARGNUM for relation");
            }
        }
    }

    public void write(PrintWriter w) {
        w.print("      <relation_mention ID=\"" + this.id + "\"");
        if (!AceDocument.ace2005) {
            w.print(" LDCLEXICALCONDITION=\"Formulaic\"");
        }
        if (Ace.writeEventConfidence) {
            w.format(" p=\"%5.3f\"", this.confidence);
        }
        w.println(">");
        w.println("      <extent>");
        AceEntityMention.writeCharseq(w, this.extent, this.text);
        w.println("      </extent>");
        this.writeMentionArg(w, 1, this.arg1);
        this.writeMentionArg(w, 2, this.arg2);
        w.println("      </relation_mention>");
    }

    private void writeMentionArg(PrintWriter w, int argnum, AceEntityMention arg) {
        if (AceDocument.ace2005) {
            w.println("        <relation_mention_argument REFID=\"" + arg.id + "\" ROLE=\"Arg-" + argnum + "\">");
        } else {
            String keyword = AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID";
            w.println("        <rel_mention_arg " + keyword + "=\"" + arg.id + "\" ARGNUM=\"" + argnum + "\">");
        }
        w.println("          <extent>");
        w.print("            <charseq START=\"" + arg.extent.start() + "\" END=\"" + arg.extent.end() + "\">");
        w.print(AceEntityMention.addXmlEscapes(arg.text));
        w.println("</charseq>");
        w.println("          </extent>");
        if (AceDocument.ace2005) {
            w.println("        </relation_mention_argument>");
        } else {
            w.println("        </rel_mention_arg>");
        }
    }

    public String toString() {
        return this.relation.type + ":" + this.relation.subtype + "(" + this.arg1.text + ", " + this.arg2.text + ")";
    }
}

