/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.AceTimex;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceTimexMention
extends AceMention {
    public AceTimex timex;

    public AceTimexMention(String id, Span extent, String fileText) {
        this.id = id;
        this.extent = AceEntityMention.convertSpan(extent, fileText);
        this.jetExtent = extent;
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
    }

    public AceTimexMention(Element mentionElement, String fileText) {
        this.id = mentionElement.getAttribute("ID");
        NodeList extents = mentionElement.getElementsByTagName("extent");
        Element extentElement = (Element)extents.item(0);
        if (extentElement == null) {
            System.err.println("*** AceTimexMention:  no extent.");
        } else {
            this.extent = AceEntityMention.decodeCharseq(extentElement);
            this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, fileText);
            if (this.extent.start() <= this.extent.end() && this.extent.end() < fileText.length()) {
                this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
            } else {
                this.text = "";
                System.err.println("*** AceTimexMention:  invalid extent.");
            }
        }
    }

    public AceEventArgumentValue getParent() {
        return this.timex;
    }

    public String getType() {
        return this.timex.getType();
    }

    void write(PrintWriter w) {
        w.println("    <timex2_mention ID=\"" + this.id + "\">");
        w.println("      <extent>");
        AceEntityMention.writeCharseq(w, this.extent, this.text);
        w.println("      </extent>");
        w.println("    </timex2_mention>");
    }
}

