/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceValueMention;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceValue
extends AceEventArgumentValue {
    String type;
    String subtype;
    public ArrayList<AceValueMention> mentions = new ArrayList();

    public AceValue(String id, String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.id = id;
    }

    public AceValue(Element valueElement, String filetext) {
        this.id = valueElement.getAttribute("ID");
        this.type = valueElement.getAttribute("TYPE");
        this.subtype = valueElement.getAttribute("SUBTYPE");
        if (this.subtype == null) {
            this.subtype = "";
        }
        NodeList mentionElements = valueElement.getElementsByTagName("value_mention");
        for (int j = 0; j < mentionElements.getLength(); ++j) {
            Element mentionElement = (Element)mentionElements.item(j);
            AceValueMention mention = new AceValueMention(mentionElement, filetext);
            this.addMention(mention);
        }
    }

    public void addMention(AceValueMention mention) {
        this.mentions.add(mention);
        mention.value = this;
    }

    AceValueMention findMention(String id) {
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceValueMention mention = this.mentions.get(i);
            if (!mention.id.equals(id)) continue;
            return mention;
        }
        return null;
    }

    public void write(PrintWriter w) {
        w.print("  <value ID=\"" + this.id + "\" TYPE=\"" + this.type + "\"");
        if (this.subtype != null && !this.subtype.equals("")) {
            w.print(" SUBTYPE=\"" + this.subtype + "\"");
        }
        w.println(">");
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceValueMention mention = this.mentions.get(i);
            mention.write(w);
        }
        w.println("  </value>");
    }
}

