/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.lex.Stemmer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchoredPath {
    public static Stemmer stemmer;
    public String arg1;
    public String path;
    public String arg2;
    public String source;

    public AnchoredPath(String arg1, String path, String arg2, String source, int sentenceSpanStart, int sentenceSpanEnd) {
        this.arg1 = arg1;
        this.path = path;
        this.arg2 = arg2;
        this.source = source;
    }

    public AnchoredPath(String line) {
        String[] pathFields;
        boolean newFormat = true;
        String[] topFields = line.split("\t");
        if (topFields.length != 2) {
            topFields = line.split("\\|");
            newFormat = false;
        }
        if ((pathFields = newFormat ? topFields[1].split(" -- ") : topFields[0].split(" -- ")).length != 3) {
            System.out.println("Error in path line: " + line);
            System.exit(1);
        }
        this.arg1 = pathFields[0];
        this.path = AnchoredPath.lemmatizePath(pathFields[1]);
        this.arg2 = pathFields[2];
    }

    public String toString() {
        return this.arg1 + " -- " + this.path + " -- " + this.arg2;
    }

    public static String lemmatizePath(String path) {
        String[] pathArray = path.split(":");
        LinkedList<String> ll = new LinkedList<String>(Arrays.asList(pathArray));
        StringBuilder sb = new StringBuilder();
        while (ll.size() > 0) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(ll.removeFirst());
            if (ll.size() <= 0) continue;
            sb.append(":");
            sb.append(stemmer.getStem(ll.removeFirst(), "NULL"));
        }
        return sb.toString();
    }

    public static String reduceConjunction(String path) {
        String[] pathArray = path.split(":");
        int pathLen = pathArray.length;
        LinkedList<String> ll = new LinkedList<String>(Arrays.asList(pathArray));
        if (pathLen >= 4 && ll.get(0).equals("conj-1") && ll.get(1).equals("and") && ll.get(2).equals("cc-1")) {
            return AnchoredPath.cat(ll.subList(4, pathLen));
        }
        if (pathLen >= 2 && ll.get(0).equals("conj-1")) {
            return AnchoredPath.cat(ll.subList(2, pathLen));
        }
        if (pathLen >= 4 && ll.get(pathLen - 3).equals("cc") && ll.get(pathLen - 2).equals("and") && ll.get(pathLen - 1).equals("conj")) {
            return AnchoredPath.cat(ll.subList(0, pathLen - 4));
        }
        if (pathLen >= 2 && ll.get(pathLen - 1).equals("conj")) {
            return AnchoredPath.cat(ll.subList(0, pathLen - 2));
        }
        return path;
    }

    private static String cat(List<String> l) {
        if (l.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : l) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static {
        new Stemmer();
        stemmer = Stemmer.getDefaultStemmer();
    }
}

