/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.RelationInstance;
import edu.nyu.jet.aceJet.RelationPattern;
import edu.nyu.jet.aceJet.RelationPatternSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class BuildRelationModel {
    static RelationPattern relPat;
    static StringBuffer features;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String rootDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/";
    static final String testPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log";
    static final String patternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log";
    static final String handPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/lisp/patterns.log";
    static final String generalPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/lisp/generalPatterns.log";
    static RelationPatternSet adam;
    static RelationPatternSet eve;
    static RelationPatternSet general;
    static final int testCorpusSize = 2000;
    static final String[] typeSubtype;
    private static final int TYPELENGTH = 9;
    private static final int TOTAL = 0;
    static final int NO_RELATION = 1;
    private static final int N_SUBTYPES;
    private static int[] subtypeCount;
    private static int relationCount;
    private static int MAX_SIZE;
    private static int[] relationLengthCount;
    private static int[] lengthCount;
    private static HashMap[] nonFinalWordCount;
    private static HashMap[] finalWordCount;
    static final double NO_RELATION_BIAS = 0.2;
    static final double VOCAB_SIZE = 4000.0;
    static final boolean trace = false;
    private static double BETA;

    BuildRelationModel() {
    }

    public static void main(String[] args) throws IOException {
        String prep = RelationPattern.prepositionOfLink("s-verb-in");
        System.out.println(prep);
        boolean prepMatch = RelationPattern.matchingRelations("s-verb-in", "s-werb-in");
        System.out.println(prepMatch);
    }

    static void buildProbModel(RelationPatternSet rps) {
        for (int i = 0; i < N_SUBTYPES; ++i) {
            BuildRelationModel.nonFinalWordCount[i] = new HashMap();
            BuildRelationModel.finalWordCount[i] = new HashMap();
        }
        Iterator it = rps.iterator();
        while (it.hasNext()) {
            ArrayList lilink;
            int size;
            int itype;
            RelationPattern pattern = (RelationPattern)it.next();
            String type = pattern.relationType;
            String subType = pattern.relationSubtype;
            if (type.equals("0")) {
                itype = 1;
            } else {
                itype = BuildRelationModel.typeSubtypeToIndex(type, subType);
                if (itype < 0) {
                    System.err.println("*** unknown type/subtype" + type + ":" + subType);
                    continue;
                }
            }
            if ((size = (lilink = pattern.linearLink).size()) <= 0 || size >= MAX_SIZE || lilink.get(0).equals("0")) continue;
            if (!type.equals("0")) {
                ++relationCount;
                int n = size;
                relationLengthCount[n] = relationLengthCount[n] + 1;
            }
            int n = size;
            lengthCount[n] = lengthCount[n] + 1;
            subtypeCount[0] = subtypeCount[0] + 1;
            int n2 = itype;
            subtypeCount[n2] = subtypeCount[n2] + 1;
            for (int i = 0; i < size - 1; ++i) {
                BuildRelationModel.incrementHashMap(nonFinalWordCount[0], (String)lilink.get(i), 1);
                BuildRelationModel.incrementHashMap(nonFinalWordCount[itype], (String)lilink.get(i), 1);
            }
            BuildRelationModel.incrementHashMap(finalWordCount[0], (String)lilink.get(size - 1), 1);
            BuildRelationModel.incrementHashMap(finalWordCount[itype], (String)lilink.get(size - 1), 1);
        }
    }

    static int mostLikelySubtype(RelationInstance relpat) {
        String argType1 = relpat.getType1();
        String argType2 = relpat.getType2();
        int bestType = -1;
        double bestProb = -1.0;
        for (int iType = 1; iType < N_SUBTYPES; ++iType) {
            double prob = BuildRelationModel.subtypeProb(iType, relpat.linearLink);
            if (!(prob > bestProb)) continue;
            bestType = iType;
            bestProb = prob;
        }
        if (bestType > 0) {
            System.out.println(">>> Best stat. type = " + typeSubtype[bestType]);
        }
        return bestType;
    }

    private static double subtypeProb(int iType, ArrayList linearLink) {
        int size = linearLink.size();
        if (size == 0 || size >= MAX_SIZE || linearLink.get(0).equals("0")) {
            return -1.0;
        }
        double prob = 1.0;
        for (int i = 0; i < size - 1; ++i) {
            prob *= BuildRelationModel.wordSubtypeProb(iType, (String)linearLink.get(i), false);
        }
        prob *= BuildRelationModel.wordSubtypeProb(iType, (String)linearLink.get(size - 1), true);
        if (iType == 1) {
            double f1 = 1.0 - (double)relationLengthCount[size] / (double)lengthCount[size];
            prob *= f1 * 0.2;
        } else {
            double f1 = (double)subtypeCount[iType] / (double)relationCount;
            double f2 = (double)relationLengthCount[size] / (double)lengthCount[size];
            prob *= f1 * f2;
        }
        return prob;
    }

    private static double wordSubtypeProb(int iType, String word, boolean last) {
        double prob;
        int ct;
        Integer count = last ? (Integer)finalWordCount[iType].get(word) : (Integer)nonFinalWordCount[iType].get(word);
        int n = ct = count == null ? 0 : count;
        if (ct > 0) {
            prob = (double)ct / (double)subtypeCount[iType];
        } else {
            count = last ? (Integer)finalWordCount[0].get(word) : (Integer)nonFinalWordCount[0].get(word);
            ct = count == null ? 0 : count;
            prob = ct > 0 ? BETA * (double)ct / (double)subtypeCount[0] : 2.5E-4;
        }
        return prob;
    }

    private static int typeSubtypeToIndex(String type, String subType) {
        if (type.equals("0")) {
            return 1;
        }
        for (int i = 2; i < N_SUBTYPES; ++i) {
            String tSt = typeSubtype[i];
            String t = tSt.substring(0, 9).trim();
            String sT = tSt.substring(10);
            if (!type.equals(t) || !subType.equals(sT)) continue;
            return i;
        }
        return -1;
    }

    static void incrementHashMap(HashMap map, String key, int n) {
        Integer countI = (Integer)map.get(key);
        int count = countI == null ? 0 : countI;
        map.put(key, new Integer(count + n));
    }

    private static void predict() throws IOException {
        String line;
        int count = 0;
        int correct = 0;
        int spurious = 0;
        int missing = 0;
        int incorrect = 0;
        BufferedReader reader = new BufferedReader(new FileReader("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log"));
        while ((line = reader.readLine()) != null && ++count <= 2000) {
            int i;
            relPat = new RelationPattern(line);
            RelationPattern match1 = adam.findMatch(relPat, 5);
            RelationPattern match2 = eve.findMatch(relPat, 21);
            RelationPattern match3 = general.findMatch(relPat, 5);
            String predictedType = match1 != null ? match1.relationType : (match2 != null ? match2.relationType : (match3 != null ? match3.relationType : ((i = BuildRelationModel.mostLikelySubtype(relPat)) < 0 || i == 1 ? "0" : typeSubtype[i].substring(0, 4).trim())));
            if (!BuildRelationModel.relPat.relationType.equals(predictedType)) {
                System.out.println(line);
                System.out.println("Correct type: " + BuildRelationModel.relPat.relationType + " Predicted type:  " + predictedType);
                if (match1 != null) {
                    System.out.println("Best Adam pattern = " + match1.string);
                } else if (match2 != null) {
                    System.out.println("Best corpus pattern = " + match2.string);
                } else if (match3 != null) {
                    System.out.println("Best gen'l pattern = " + match3.string);
                } else {
                    System.out.println("No pattern matched.");
                }
            }
            if (BuildRelationModel.relPat.relationType.equals("0")) {
                if (predictedType.equals("0")) continue;
                ++spurious;
                continue;
            }
            if (BuildRelationModel.relPat.relationType.equals(predictedType)) {
                ++correct;
                continue;
            }
            if (predictedType.equals("0")) {
                ++missing;
                continue;
            }
            ++incorrect;
        }
        System.out.println(correct + " correct predictions");
        System.out.println(spurious + " spurious");
        System.out.println(missing + " missing");
        System.out.println(incorrect + " incorrect");
        System.out.println("Recall = " + (float)correct / (float)(correct + incorrect + missing));
        System.out.println("Precision = " + (float)correct / (float)(correct + incorrect + spurious));
        System.out.println("Value = " + (correct - spurious - missing - incorrect));
    }

    static {
        features = new StringBuffer();
        typeSubtype = new String[]{"total", "no relation", "PHYS      Located", "PHYS      Near", "PHYS      Part-Whole", "PER-SOC   Business", "PER-SOC   Family", "PER-SOC   Other", "EMP-ORG   Employ-Executive", "EMP-ORG   Employ-Staff", "EMP-ORG   Employ-Undetermined", "EMP-ORG   Member-of-Group", "EMP-ORG   Subsidiary", "EMP-ORG   Partner", "EMP-ORG   Other", "ART       User-or-Owner", "ART       Inventor-Manufacturer", "ART       Other", "OTHER-AFF Ethnic", "OTHER-AFF Ideology", "OTHER-AFF Other", "GPE-AFF   Citizen-or-Resident", "GPE-AFF   Based-In", "GPE-AFF   Other", "DISC      "};
        N_SUBTYPES = typeSubtype.length;
        subtypeCount = new int[N_SUBTYPES];
        relationCount = 0;
        MAX_SIZE = 25;
        relationLengthCount = new int[MAX_SIZE];
        lengthCount = new int[MAX_SIZE];
        nonFinalWordCount = new HashMap[N_SUBTYPES];
        finalWordCount = new HashMap[N_SUBTYPES];
        BETA = 0.1;
    }
}

