/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEventAnchor;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.aceJet.RelationPattern;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkPath {
    static final Logger logger = LoggerFactory.getLogger(ChunkPath.class);
    ArrayList<String> chunks;
    Document doc;
    private static HashMap categoryRankTable = new HashMap();

    public ChunkPath(Document doc, AceMention m1, AceMention m2) {
        this.doc = doc;
        if (m1.jetExtent.start() <= m2.jetExtent.start() && m1.jetExtent.end() >= m2.jetExtent.end()) {
            if (m1 instanceof AceEntityMention || m1 instanceof AceEventAnchor) {
                this.chunks = this.patternBetweenSpans(m1.getJetHead(), m2.jetExtent);
            }
        } else if (m2.jetExtent.start() <= m1.jetExtent.start() && m2.jetExtent.end() >= m1.jetExtent.end()) {
            if (m2 instanceof AceEntityMention || m2 instanceof AceEventAnchor) {
                this.chunks = this.patternBetweenSpans(m1.jetExtent, m2.getJetHead());
            }
        } else {
            this.chunks = this.patternBetweenSpans(m1.jetExtent, m2.jetExtent);
        }
    }

    public ChunkPath(Document doc, int from, int to) {
        this.doc = doc;
        this.chunks = this.buildPattern(from, to);
    }

    private ArrayList patternBetweenSpans(Span span1, Span span2) {
        ArrayList<String> pattern = null;
        if (span1.start() < span2.start()) {
            pattern = this.buildPattern(span1.end(), span2.start());
        } else {
            logger.warn("*** Unexpected span order.");
            logger.warn("Span1 = " + this.doc.text(span1));
            logger.warn("Span2 = " + this.doc.text(span2));
            pattern = null;
        }
        return pattern;
    }

    private ArrayList<String> buildPattern(int start, int end) {
        int posn = Tokenizer.skipWS(this.doc, start, this.doc.length());
        ArrayList<String> pattern = new ArrayList<String>();
        while (posn < end) {
            Vector<Annotation> constits = this.doc.annotationsAt(posn, "constit");
            Annotation best = null;
            if (constits != null) {
                int furthest = -1;
                int bestRank = -1;
                for (int i = 0; i < constits.size(); ++i) {
                    Annotation constit = constits.get(i);
                    String cat = (String)constit.get("cat");
                    int constitEnd = constit.span().end();
                    if (constitEnd <= furthest && (constitEnd != furthest || ChunkPath.categoryRank(cat) <= bestRank) || constitEnd > end) continue;
                    furthest = constit.span().end();
                    best = constit;
                    bestRank = ChunkPath.categoryRank(cat);
                }
            }
            if (best != null) {
                String hd;
                String cat = (String)best.get("cat");
                if (!this.noiseToken(cat, hd = SynFun.getHead(this.doc, best))) {
                    pattern.add(hd);
                }
                posn = best.span().end();
                continue;
            }
            Annotation token = this.doc.tokenAt(posn);
            if (token != null) {
                String text = this.doc.text(token).trim();
                pattern.add(text);
                posn = token.span().end();
                continue;
            }
            logger.warn("buildPattern:  no constits at position " + posn);
            String text = this.doc.text();
            int first = posn < 10 ? 0 : posn - 10;
            int last = posn + 10 > text.length() ? text.length() : posn + 10;
            logger.warn("               text(" + first + ":" + last + ")" + " = " + text.substring(first, last));
            return null;
        }
        return pattern;
    }

    private boolean noiseToken(String cat, String head) {
        return cat == "adv" || cat == "timex" || cat == "q" || head.equals("'") || head.equals("''") || head.equals("\"") || head.equals("timex");
    }

    private static int categoryRank(String category) {
        Integer rankI = (Integer)categoryRankTable.get(category);
        if (rankI == null) {
            return 0;
        }
        return rankI;
    }

    public ArrayList<String> getChunks() {
        return this.chunks;
    }

    public String getLastChunk() {
        if (this.chunks != null && this.chunks.size() > 0) {
            return this.chunks.get(this.chunks.size() - 1);
        }
        return null;
    }

    public int size() {
        if (this.chunks == null) {
            return -1;
        }
        return this.chunks.size();
    }

    public boolean contains(String chunk) {
        return this.chunks.contains(chunk);
    }

    public String toString() {
        return LearnRelations.concat(this.chunks);
    }

    public void write(PrintWriter pw) {
        pw.println(this.toString());
    }

    public ChunkPath(String chunkString) {
        String[] chunkArray = chunkString.split(" ");
        this.chunks = new ArrayList(chunkArray.length);
        for (int i = 0; i < chunkArray.length; ++i) {
            this.chunks.add(chunkArray[i]);
        }
    }

    public boolean equals(ChunkPath c) {
        if (this.chunks == null) {
            return false;
        }
        if (this.chunks.size() != c.size()) {
            return false;
        }
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (this.chunks.get(i).equals(c.getChunks().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int matchFromLeft(int posn, Document doc) {
        if (this.chunks == null) {
            return -1;
        }
        posn = this.skipNoiseTokenFromLeft(posn, doc);
        block0: for (int ichunk = 0; ichunk < this.chunks.size(); ++ichunk) {
            String text;
            Annotation token;
            String chunk = this.chunks.get(ichunk);
            Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
            if (constits != null) {
                for (int i = 0; i < constits.size(); ++i) {
                    Annotation constit = constits.get(i);
                    String cat = (String)constit.get("cat");
                    String c = cat == "adv" || cat == "timex" || cat == "q" ? cat + "(" + SynFun.getHead(doc, constit) + ")" : SynFun.getHead(doc, constit);
                    if (!c.equals(chunk)) continue;
                    posn = constit.end();
                    posn = this.skipNoiseTokenFromLeft(posn, doc);
                    continue block0;
                }
            }
            if ((token = doc.tokenAt(posn)) != null && (text = doc.text(token).trim()).equals(chunk)) {
                posn = token.end();
                posn = this.skipNoiseTokenFromLeft(posn, doc);
                continue;
            }
            return -1;
        }
        return posn;
    }

    private int skipNoiseTokenFromLeft(int posn, Document doc) {
        Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.get(i);
                String cat = (String)constit.get("cat");
                String c = cat == "adv" || cat == "timex" || cat == "q" ? cat + "(" + SynFun.getHead(doc, constit) + ")" : SynFun.getHead(doc, constit);
                if (!RelationPattern.noiseToken(c)) continue;
                return constit.end();
            }
        }
        return posn;
    }

    public int matchFromRight(int posn, Document doc) {
        if (this.chunks == null) {
            return -1;
        }
        posn = this.skipNoiseTokenFromRight(posn, doc);
        block0: for (int ichunk = 0; ichunk < this.chunks.size(); ++ichunk) {
            String text;
            Annotation token;
            String chunk = this.chunks.get(ichunk);
            Vector<Annotation> constits = doc.annotationsEndingAt(posn, "constit");
            if (constits != null) {
                for (int i = 0; i < constits.size(); ++i) {
                    Annotation constit = constits.get(i);
                    String cat = (String)constit.get("cat");
                    String c = cat == "adv" || cat == "timex" || cat == "q" ? cat + "(" + SynFun.getHead(doc, constit) + ")" : SynFun.getHead(doc, constit);
                    if (!c.equals(chunk)) continue;
                    posn = constit.start();
                    posn = this.skipNoiseTokenFromRight(posn, doc);
                    continue block0;
                }
            }
            if ((token = doc.tokenEndingAt(posn)) != null && (text = doc.text(token).trim()).equals(chunk)) {
                posn = token.start();
                posn = this.skipNoiseTokenFromLeft(posn, doc);
                continue;
            }
            return -1;
        }
        return posn;
    }

    private int skipNoiseTokenFromRight(int posn, Document doc) {
        Vector<Annotation> constits = doc.annotationsEndingAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.get(i);
                String cat = (String)constit.get("cat");
                String c = cat == "adv" || cat == "timex" || cat == "q" ? cat + "(" + SynFun.getHead(doc, constit) + ")" : SynFun.getHead(doc, constit);
                if (!RelationPattern.noiseToken(c)) continue;
                return constit.start();
            }
        }
        return posn;
    }

    static {
        categoryRankTable.put("name", new Integer(1));
        categoryRankTable.put("timex", new Integer(1));
        categoryRankTable.put("np", new Integer(2));
        categoryRankTable.put("np-pro", new Integer(2));
        categoryRankTable.put("vgroup", new Integer(2));
        categoryRankTable.put("vgroup-inf", new Integer(2));
        categoryRankTable.put("vgroup-pass", new Integer(2));
        categoryRankTable.put("vgroup-ving", new Integer(2));
        categoryRankTable.put("vgroup-ven", new Integer(2));
        categoryRankTable.put("vp", new Integer(3));
        categoryRankTable.put("vp-inf", new Integer(3));
        categoryRankTable.put("vingo", new Integer(3));
        categoryRankTable.put("s", new Integer(4));
    }
}

