/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Vector;

public class CoherenceAnalyzer {
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire.txt";
    static final int NSENT = 50;
    static int[] mentionCount = new int[50];
    static int[] mentionWithAnaphorCount = new int[50];
    static int[] mentionWithAntecedentCount = new int[50];
    private static int[] sentenceBoundaries;
    private static String firstSentence;
    static ArrayList spans;

    public static void main(String[] args) throws Exception {
        String currentDoc;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFileName = ACEdir + currentDoc + ".sgm";
            boolean newData = fileList.indexOf("03") > 0;
            String APFfileName = ACEdir + currentDoc + (newData ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            CoherenceAnalyzer.reset();
            CoherenceAnalyzer.analyzeDocument(textFileName, APFfileName);
            CoherenceAnalyzer.report(sentenceBoundaries.length);
        }
        CoherenceAnalyzer.report(50);
    }

    private static void analyzeDocument(String textFileName, String APFfileName) {
        AceDocument aceDoc = new AceDocument(textFileName, APFfileName);
        Document doc = aceDoc.JetDocument();
        CoherenceAnalyzer.collectSentenceBoundaries(doc);
        CoherenceAnalyzer.collectMentionSpans(aceDoc);
        CoherenceAnalyzer.findEntityMentions(aceDoc);
    }

    static void findEntityMentions(AceDocument aceDoc) {
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            ArrayList<AceEntityMention> mentions = entity.mentions;
            CoherenceAnalyzer.analyzeMentions(mentions);
        }
    }

    private static void analyzeMentions(ArrayList mentions) {
        for (int imention = 0; imention < mentions.size(); ++imention) {
            AceEntityMention mention = (AceEntityMention)mentions.get(imention);
            Span span = mention.head;
            int sentence = CoherenceAnalyzer.sentenceNumber(span);
            if (sentence >= 50) continue;
            boolean hasAntecedent = imention > 0;
            boolean hasAnaphor = imention < mentions.size() - 1;
            int n = sentence;
            mentionCount[n] = mentionCount[n] + 1;
            if (hasAnaphor) {
                int n2 = sentence;
                mentionWithAnaphorCount[n2] = mentionWithAnaphorCount[n2] + 1;
            }
            if (!hasAntecedent) continue;
            int n3 = sentence;
            mentionWithAntecedentCount[n3] = mentionWithAntecedentCount[n3] + 1;
        }
    }

    private static void reset() {
        mentionCount = new int[50];
        mentionWithAnaphorCount = new int[50];
        mentionWithAntecedentCount = new int[50];
    }

    private static void report(int limit) {
        for (int i = 0; i < limit && i < 50; ++i) {
            System.out.print("Sentence " + i + ": ");
            System.out.print(mentionCount[i] + " mentions, ");
            System.out.print(mentionWithAnaphorCount[i] + " with anaphors, ");
            System.out.println(mentionWithAntecedentCount[i] + " with antecedents");
        }
        if (mentionCount[1] > 0 && mentionWithAnaphorCount[1] == 0) {
            System.out.println("**** Isolated first sentence:");
            System.out.println("     " + firstSentence);
        }
    }

    private static void collectSentenceBoundaries(Document doc) {
        Vector<Annotation> textAnnotations = doc.annotationsOfType("TEXT");
        Annotation textAnnotation = textAnnotations.get(0);
        Span textSpan = textAnnotation.span();
        SentenceSplitter.split(doc, textSpan);
        Vector<Annotation> v = doc.annotationsOfType("sentence");
        Span firstSentenceSpan = v.get(0).span();
        firstSentence = doc.text(firstSentenceSpan);
        int datelineEnd = firstSentence.indexOf(95) + firstSentenceSpan.start();
        sentenceBoundaries = new int[v.size() + 1];
        CoherenceAnalyzer.sentenceBoundaries[0] = datelineEnd;
        for (int i = 0; i < v.size(); ++i) {
            CoherenceAnalyzer.sentenceBoundaries[i + 1] = v.get(i).span().end();
        }
    }

    private static int sentenceNumber(Span span) {
        int start = span.start();
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            if (start >= sentenceBoundaries[i]) continue;
            return i;
        }
        return -1;
    }

    private static void collectMentionSpans(AceDocument aceDoc) {
        spans = new ArrayList();
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            if (entity.generic) continue;
            ArrayList<AceEntityMention> mentions = entity.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEntityMention mention = mentions.get(j);
                spans.add(mention.extent);
            }
        }
    }

    private static boolean embedded(AceEntityMention mention) {
        Span span = mention.extent;
        for (int i = 0; i < spans.size(); ++i) {
            Span otherSpan = (Span)spans.get(i);
            if (!span.within(otherSpan) || span.equals(otherSpan)) continue;
            return true;
        }
        return false;
    }

    static {
        spans = new ArrayList();
    }
}

