/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.aceJet.AceRelationMention;
import edu.nyu.jet.aceJet.AnchoredPath;
import edu.nyu.jet.aceJet.EventSyntacticPattern;
import edu.nyu.jet.aceJet.RelationTagger;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepPathRelationTagger {
    static final Logger logger = LoggerFactory.getLogger(DepPathRelationTagger.class);
    static Document doc;
    static AceDocument aceDoc;
    static String currentDoc;
    static Map<String, String> model;

    public static void findRelations(String currentDoc, Document d, AceDocument ad) {
        doc = d;
        RelationTagger.doc = d;
        DepPathRelationTagger.doc.relations.addInverses();
        aceDoc = ad;
        RelationTagger.docName = currentDoc;
        RelationTagger.sentences = new SentenceSet(doc);
        RelationTagger.relationList = new ArrayList<AceRelation>();
        RelationTagger.findEntityMentions(aceDoc);
        List<AceEntityMention[]> pairs = RelationTagger.findMentionPairs();
        for (AceEntityMention[] pair : pairs) {
            DepPathRelationTagger.predictRelation(pair[0], pair[1], DepPathRelationTagger.doc.relations);
        }
        RelationTagger.relationCoref(aceDoc);
        RelationTagger.removeRedundantMentions(aceDoc);
    }

    static void loadModel(String modelFile) throws IOException {
        String line;
        model = new TreeMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(modelFile));
        int n = 0;
        while ((line = reader.readLine()) != null) {
            String[] fields = line.split("\t");
            String pattern = fields[0];
            pattern = pattern.replace("would:vch:", "");
            pattern = pattern.replace("be:vch:", "");
            pattern = pattern.replace("were:vch:", "");
            String outcome = fields[1];
            model.put(pattern, outcome);
            ++n;
        }
        System.out.println("Loaded relation model with " + n + " relation paths.");
    }

    private static void predictRelation(AceEntityMention m1, AceEntityMention m2, SyntacticRelationSet relations) {
        int h2;
        int h1 = m1.getJetHead().start();
        String path = EventSyntacticPattern.buildSyntacticPath(h1, h2 = m2.getJetHead().start(), relations);
        if (path == null) {
            return;
        }
        if ((path = AnchoredPath.reduceConjunction(path)) == null) {
            return;
        }
        path = AnchoredPath.lemmatizePath(path);
        path = path.replace("would:vch:", "");
        path = path.replace("be:vch:", "");
        path = path.replace("were:vch:", "");
        String pattern = m1.entity.type + "--" + path + "--" + m2.entity.type;
        String outcome = model.get(pattern);
        if (outcome == null) {
            return;
        }
        if (!RelationTagger.blockingTest(m1, m2)) {
            return;
        }
        if (!RelationTagger.blockingTest(m2, m1)) {
            return;
        }
        String[] typeSubtype = outcome.split(":", 2);
        String type = typeSubtype[0];
        String subtype = typeSubtype.length == 1 ? "" : typeSubtype[1];
        if (subtype.endsWith("-1")) {
            subtype = subtype.replace("-1", "");
            AceRelationMention mention = new AceRelationMention("", m2, m1, doc);
            AceRelation relation = new AceRelation("", type, subtype, "", m2.entity, m1.entity);
            relation.addMention(mention);
            RelationTagger.relationList.add(relation);
        } else {
            AceRelationMention mention = new AceRelationMention("", m1, m2, doc);
            System.out.println("Found " + outcome + " relation " + mention.text);
            AceRelation relation = new AceRelation("", type, subtype, "", m1.entity, m2.entity);
            relation.addMention(mention);
            RelationTagger.relationList.add(relation);
        }
    }

    static {
        model = null;
    }
}

