/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.EDTtype;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;

class EDTtypeData {
    static HashMap subtypeTotals = new HashMap();
    String word;
    String type = null;
    String subtype = null;
    int count = 0;
    HashMap typeCount;
    int genericCount = 0;
    int nonGenericCount = 0;

    EDTtypeData(String word) {
        this.word = word;
        this.typeCount = new HashMap();
    }

    static EDTtypeData readLine(String line) {
        int split = line.indexOf(124);
        if (split <= 1) {
            System.err.println("** error in ACE type dict: " + line);
            return null;
        }
        String term = line.substring(0, split - 1);
        EDTtypeData data = new EDTtypeData(term);
        String typeStatistics = line.substring(split + 2);
        StringTokenizer st = new StringTokenizer(typeStatistics);
        while (st.hasMoreTokens()) {
            String subtype;
            String type;
            String typeSubtype = st.nextToken();
            String countString = st.nextToken();
            int count = Integer.valueOf(countString);
            int p = typeSubtype.indexOf(58);
            if (p > 0) {
                type = typeSubtype.substring(0, p);
                subtype = typeSubtype.substring(p + 1);
            } else {
                type = typeSubtype;
                subtype = "*";
            }
            data.incrementTypeCount(type, subtype, count);
        }
        return data;
    }

    String getBestType() {
        if (this.type == null) {
            this.determineBestType();
        }
        return this.type;
    }

    String getBestSubtype() {
        if (this.type == null) {
            this.determineBestType();
        }
        return this.subtype;
    }

    String getBestTypeSubtype() {
        return EDTtype.typeAndSubtype(this.getBestType(), this.getBestSubtype());
    }

    void write(PrintStream writer) {
        writer.print(this.word + " |");
        for (String type : this.typeCount.keySet()) {
            HashMap subMap = (HashMap)this.typeCount.get(type);
            for (String subtype : subMap.keySet()) {
                if (subtype == "total") continue;
                Integer cc = (Integer)subMap.get(subtype);
                if (subtype.equals("*")) {
                    writer.print(" " + type + " " + cc);
                    continue;
                }
                writer.print(" " + type + ":" + subtype + " " + cc);
            }
        }
        writer.println();
    }

    void incrementTypeCount(String type, String subtype, int incr) {
        EDTtypeData.incrementCount(this.typeCount, type, subtype, incr);
        if (!subtype.equals("*")) {
            EDTtypeData.incrementCount(this.typeCount, type, "total", incr);
            EDTtypeData.incrementCount(subtypeTotals, type, subtype, incr);
        }
    }

    static void incrementCount(HashMap map, String a, String b, int incr) {
        Integer cc;
        HashMap<String, Integer> aMap = (HashMap<String, Integer>)map.get(a);
        if (aMap == null) {
            aMap = new HashMap<String, Integer>();
            map.put(a, aMap);
        }
        int c = (cc = (Integer)aMap.get(b)) == null ? 0 : cc;
        aMap.put(b, new Integer(c += incr));
    }

    void incrementGenericCount(boolean generic) {
        if (generic) {
            ++this.genericCount;
        } else {
            ++this.nonGenericCount;
        }
    }

    void determineBestType() {
        int c;
        Integer cc;
        if (this.type != null) {
            return;
        }
        int bestCount = 0;
        for (String tp : this.typeCount.keySet()) {
            cc = (Integer)((HashMap)this.typeCount.get(tp)).get("total");
            c = cc == null ? 0 : cc;
            if (c <= bestCount) continue;
            this.type = tp;
            bestCount = c;
        }
        if (this.type == null) {
            for (String tp : this.typeCount.keySet()) {
                cc = (Integer)((HashMap)this.typeCount.get(tp)).get("*");
                c = cc == null ? 0 : cc;
                if (c <= bestCount) continue;
                this.type = tp;
                bestCount = c;
            }
            if (this.type == null) {
                System.err.println("EDTtypeData.determineBestType failed for " + this.word);
            } else {
                this.subtype = EDTtypeData.bestSubtype(this.type);
            }
            return;
        }
        bestCount = -1;
        HashMap subtypeCount = (HashMap)this.typeCount.get(this.type);
        for (String subtp : subtypeCount.keySet()) {
            Integer cc2;
            int c2;
            if (subtp == "total" || subtp.equals("*") || (c2 = (cc2 = (Integer)subtypeCount.get(subtp)) == null ? 0 : cc2) <= bestCount) continue;
            this.subtype = subtp;
            bestCount = c2;
        }
    }

    static void reportSubtypeTotals() {
        for (String type : subtypeTotals.keySet()) {
            System.out.println("For type: " + type);
            HashMap subMap = (HashMap)subtypeTotals.get(type);
            for (String subtype : subMap.keySet()) {
                Integer cc = (Integer)subMap.get(subtype);
                System.out.print(subtype + " " + cc + " ");
            }
            System.out.println();
        }
    }

    static String bestSubtype(String type) {
        HashMap subMap = (HashMap)subtypeTotals.get(type);
        String best = null;
        int bestCount = 0;
        for (String subtype : subMap.keySet()) {
            Integer cc = (Integer)subMap.get(subtype);
            int c = cc;
            if (c <= bestCount) continue;
            best = subtype;
            bestCount = c;
        }
        if (best != null) {
            return best;
        }
        if (type.equals("OTHER")) {
            return "";
        }
        System.err.println("*** Cannot determine best subtype for type " + type);
        return "Other";
    }
}

