/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.EventPattern;
import edu.nyu.jet.aceJet.EventTagger;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.aceJet.NewEventTagger;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class EventEval {
    static int correctArgs;
    static int missingArgs;
    static int spuriousArgs;
    static int correctEvents;
    static int typeErrorEvents;
    static int missingEvents;
    static int spuriousEvents;
    static NewEventTagger evTagger;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static final String fileListTest = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/head6.txt";
    private static AceEvent keyEvent;

    public static void main(String[] args) throws IOException {
        if (EventTagger.useParser) {
            JetTest.initializeFromConfig("props/ace use parses.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05.properties");
        }
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        evTagger = new NewEventTagger("eventTemp/");
        evTagger.loadModels();
        EventEval.evalEvents(fileListTest);
    }

    public static void evalEvents(String fileList) throws IOException {
        String currentDocPath;
        EventTagger.useArgumentModel = false;
        EventPattern.useChunkPatterns = true;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        boolean docCount = false;
        correctArgs = 0;
        missingArgs = 0;
        spuriousArgs = 0;
        correctEvents = 0;
        typeErrorEvents = 0;
        missingEvents = 0;
        spuriousEvents = 0;
        while ((currentDocPath = reader.readLine()) != null) {
            System.err.println("\nProcessing file " + currentDocPath);
            String textFile = ace + (EventTagger.useParser ? "perfect-parses/" : "") + currentDocPath;
            String xmlFile = ace + currentDocPath.replaceFirst(".sgm", ".apf.xml");
            String outputFile = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/output/" + currentDocPath.replaceFirst(".sgm", ".apf");
            String docId = currentDocPath.replaceFirst(".sgm", "");
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            Control.processDocument(doc, null, false, 0);
            AceDocument aceDoc = new AceDocument(textFile, xmlFile);
            EventEval.evalEvents(doc, aceDoc, docId);
        }
        System.out.println("Events:  " + correctEvents + " correct; " + typeErrorEvents + " type errors; " + missingEvents + " missing; " + spuriousEvents + " spurious");
        System.out.println("Arguments:  " + correctArgs + " correct; " + missingArgs + " missing; " + spuriousArgs + " spurious");
    }

    public static void evalEvents(Document doc, AceDocument aceDoc, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (EventTagger.usePA) {
            relations.readRelations(EventTagger.glarfDir + docId + EventTagger.triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        HashSet<Span> matchedAnchors = new HashSet<Span>();
        for (int i = 0; i < constituents.size(); ++i) {
            Annotation constit = constituents.get(i);
            String cat = (String)constit.get("cat");
            if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj") continue;
            String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
            Span anchorExtent = constit.span();
            if (matchedAnchors.contains(anchorExtent)) {
                System.err.println("** Skipping duplicate anchor. **");
                continue;
            }
            AceEventMention keyMention = EventEval.keyEventMention(anchorExtent, events);
            AceEvent event = evTagger.eventAnchoredByConstituent(constit, doc, aceDoc, docId, relations, 0);
            if (keyMention != null) {
                ArrayList<AceEventMentionArgument> keyArguments = keyMention.arguments;
                if (event != null) {
                    matchedAnchors.add(anchorExtent);
                    if (event.subtype.equals(EventEval.keyEvent.subtype)) {
                        int k;
                        AceEventMention mention = event.mentions.get(0);
                        ArrayList<AceEventMentionArgument> arguments = mention.arguments;
                        ArrayList<AceEventMentionArgument> correctArguments = new ArrayList<AceEventMentionArgument>(arguments);
                        correctArguments.retainAll(keyArguments);
                        ArrayList<AceEventMentionArgument> spuriousArguments = new ArrayList<AceEventMentionArgument>(arguments);
                        spuriousArguments.removeAll(keyArguments);
                        ArrayList<AceEventMentionArgument> missingArguments = new ArrayList<AceEventMentionArgument>(keyArguments);
                        missingArguments.removeAll(arguments);
                        correctArgs += correctArguments.size();
                        spuriousArgs += spuriousArguments.size();
                        missingArgs += missingArguments.size();
                        System.out.println("For event: " + keyMention.text);
                        System.out.println("   type of event:   " + EventEval.keyEvent.subtype);
                        System.out.println("   anchor:          " + anchor);
                        for (k = 0; k < correctArguments.size(); ++k) {
                            System.out.println("   correct  argument:  " + correctArguments.get(k));
                        }
                        for (k = 0; k < spuriousArguments.size(); ++k) {
                            System.out.println("   spurious argument:  " + spuriousArguments.get(k));
                        }
                        for (k = 0; k < missingArguments.size(); ++k) {
                            System.out.println("   missing  argument:  " + missingArguments.get(k));
                        }
                        ++correctEvents;
                        continue;
                    }
                    ++typeErrorEvents;
                    continue;
                }
                ++missingEvents;
                continue;
            }
            if (event == null) continue;
            ++spuriousEvents;
            System.err.println("Spurious event of type " + event.type + ":" + event.subtype + " for " + anchor);
        }
    }

    private static AceEventMention keyEventMention(Span anchorExtent, ArrayList keyEvents) {
        for (int i = 0; i < keyEvents.size(); ++i) {
            keyEvent = (AceEvent)keyEvents.get(i);
            ArrayList<AceEventMention> keyMentions = EventEval.keyEvent.mentions;
            for (int j = 0; j < keyMentions.size(); ++j) {
                AceEventMention keyMention = keyMentions.get(j);
                Span keyAnchorExtent = keyMention.anchorJetExtent;
                if (anchorExtent.start() != keyAnchorExtent.start()) continue;
                return keyMention;
            }
        }
        return null;
    }
}

