/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventAnchor;
import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.AcePatternNode;
import edu.nyu.jet.aceJet.ChunkPath;
import edu.nyu.jet.aceJet.EventPatternArgument;
import edu.nyu.jet.aceJet.EventSyntacticPattern;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.aceJet.PatternEvaluation;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.parser.SyntacticRelation;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPattern {
    static final Logger logger = LoggerFactory.getLogger(EventPattern.class);
    String patternType;
    ArrayList nodes = new ArrayList();
    ArrayList[] roles;
    ArrayList<ChunkPath> paths = null;
    SyntacticRelationSet syntax = null;
    int anchorPosn;
    String anchor;
    String eventType;
    String eventSubtype;
    ArrayList eventArgs = new ArrayList();
    PatternEvaluation evaluation = new PatternEvaluation();
    static boolean useChunkPatterns = true;
    public int matchScore = 0;
    private int chunkMatchScore = 0;
    int syntaxMatchScore = 0;
    int MIN_MATCH_SCORE = 0;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static final String triplesDir = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/011306-fast-tuples/";
    static final String triplesSuffix = ".sent.txt.ns-2005-fast-ace-n-tuple92";

    EventPattern(String patternType, Document doc, SyntacticRelationSet relations, AceEvent event, AceEventMention eventMention) {
        int iarg;
        int i;
        this.patternType = patternType;
        if (patternType == "CHUNK") {
            this.paths = new ArrayList();
        } else if (patternType == "SYNTAX" || patternType == "PA") {
            this.syntax = new SyntacticRelationSet();
        } else {
            logger.error("Invalid patternType " + patternType + " in EventPattern constructor.");
            return;
        }
        ArrayList<AceEventMentionArgument> allArguments = eventMention.arguments;
        ArrayList<AceEventMentionArgument> arguments = new ArrayList<AceEventMentionArgument>(allArguments);
        ArrayList<AceMention> argVals = new ArrayList<AceMention>();
        int[] argValPtr = new int[arguments.size()];
        for (i = 0; i < arguments.size(); ++i) {
            AceMention m = arguments.get((int)i).value;
            if (argVals.contains(m)) {
                argValPtr[i] = argVals.indexOf(m);
                continue;
            }
            argValPtr[i] = argVals.size();
            argVals.add(m);
        }
        for (i = 0; i < argVals.size() - 1; ++i) {
            for (int j = i + 1; j < argVals.size(); ++j) {
                AceMention argi = (AceMention)argVals.get(i);
                AceMention argj = (AceMention)argVals.get(j);
                if (argi.jetExtent.start() <= argj.jetExtent.start()) continue;
                argVals.set(i, argj);
                argVals.set(j, argi);
                for (int k = 0; k < argValPtr.length; ++k) {
                    if (argValPtr[k] == i) {
                        argValPtr[k] = j;
                        continue;
                    }
                    if (argValPtr[k] != j) continue;
                    argValPtr[k] = i;
                }
            }
        }
        Span anchorExtent = eventMention.anchorJetExtent;
        String anchorText = eventMention.anchorText;
        this.anchorPosn = -1;
        for (int i2 = 0; i2 < argVals.size(); ++i2) {
            AceMention argi = (AceMention)argVals.get(i2);
            if (argi.getJetHead().start() <= anchorExtent.start()) continue;
            this.anchorPosn = i2;
            argVals.add(i2, null);
            for (int j = 0; j < argValPtr.length; ++j) {
                if (argValPtr[j] < this.anchorPosn) continue;
                int n = j;
                argValPtr[n] = argValPtr[n] + 1;
            }
            break;
        }
        if (this.anchorPosn < 0) {
            this.anchorPosn = argVals.size();
            argVals.add(null);
        }
        this.anchor = EventPattern.normalizedAnchor(anchorExtent, anchorText, doc, relations);
        int toHead = 0;
        AceMention mention = null;
        AceMention lastMention = null;
        int[] argumentPosn = new int[argVals.size()];
        for (iarg = 0; iarg < argVals.size(); ++iarg) {
            if (iarg == this.anchorPosn) {
                mention = new AceEventAnchor(eventMention.anchorExtent, eventMention.anchorJetExtent, eventMention.anchorText, doc);
                argumentPosn[iarg] = anchorExtent.start();
                this.nodes.add(null);
            } else {
                mention = (AceMention)argVals.get(iarg);
                argumentPosn[iarg] = toHead = mention.getJetHead().start();
                this.nodes.add(new AcePatternNode(mention));
            }
            if (iarg > 0 && patternType == "CHUNK") {
                ChunkPath p = new ChunkPath(doc, lastMention, mention);
                if (p == null) {
                    logger.warn("EventPattern:  unable to build chunk path.");
                }
                this.paths.add(p);
            }
            lastMention = mention;
        }
        if (patternType == "SYNTAX" || patternType == "PA") {
            this.syntax = EventSyntacticPattern.buildPattern(patternType, anchorExtent.start(), argumentPosn, relations);
        }
        this.eventType = event.type;
        this.eventSubtype = event.subtype;
        this.roles = new ArrayList[this.nodes.size()];
        for (int i3 = 0; i3 < this.roles.length; ++i3) {
            this.roles[i3] = new ArrayList();
        }
        for (iarg = 0; iarg < arguments.size(); ++iarg) {
            int iArgVal = argValPtr[iarg];
            AceEventMentionArgument a = arguments.get(iarg);
            String role = a.role;
            this.eventArgs.add(new EventPatternArgument(role, new Integer(iArgVal + 1)));
            this.roles[iArgVal].add(role);
        }
    }

    public EventPattern(EventPattern ep) {
        this.patternType = ep.patternType;
        this.nodes = ep.nodes;
        this.roles = ep.roles;
        this.paths = ep.paths;
        this.syntax = ep.syntax;
        this.anchorPosn = ep.anchorPosn;
        this.anchor = ep.anchor;
        this.eventType = ep.eventType;
        this.eventSubtype = ep.eventSubtype;
        this.eventArgs = ep.eventArgs;
        this.evaluation = ep.evaluation;
    }

    public boolean empty() {
        return !(this.patternType != "SYNTAX" && this.patternType != "PA" || this.syntax != null && this.syntax.size() != 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EventPattern)) {
            return false;
        }
        EventPattern p = (EventPattern)o;
        if (this.paths == null ? p.paths != null : !this.paths.equals(p.paths)) {
            return false;
        }
        if (this.syntax == null ? p.syntax != null : !this.syntax.equals(p.syntax)) {
            return false;
        }
        return this.nodes.equals(p.nodes) && this.anchorPosn == p.anchorPosn && this.anchor.equals(p.anchor) && this.eventType.equals(p.eventType) && this.eventSubtype.equals(p.eventSubtype) && this.eventArgs.equals(p.eventArgs);
    }

    public int hashCode() {
        return (this.anchor + this.nodes.size()).hashCode();
    }

    static String normalizedAnchor(Span anchorSpan, String anchorText, Document doc, SyntacticRelationSet relations) {
        int posn = anchorSpan.start();
        Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.get(i);
                String cat = (String)constit.get("cat");
                if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj") continue;
                return EventPattern.normalizedAnchor(constit, doc, relations);
            }
        }
        return anchorText;
    }

    static String normalizedAnchor(Annotation constit, Document doc, SyntacticRelationSet relations) {
        String cat = (String)constit.get("cat");
        String sense = "";
        if (cat == "n") {
            return SynFun.getHead(doc, constit).toLowerCase() + sense + "/n";
        }
        return SynFun.getHead(doc, constit).toLowerCase() + sense;
    }

    private static String getSenseOfWordAt(int posn, SyntacticRelationSet relations) {
        SyntacticRelationSet fromSet = relations.getRelationsFrom(posn);
        for (int i = 0; i < fromSet.size(); ++i) {
            SyntacticRelation r = fromSet.get(i);
            if (r.type.endsWith("-1")) continue;
            return r.sourceWordSense;
        }
        return "1";
    }

    public AceEvent match(Span anchorExtent, String anchor, Document doc, SyntacticRelationSet relations, AceDocument aceDoc) {
        if (!this.anchor.equals(anchor)) {
            return null;
        }
        ArrayList chunkArgumentValue = this.chunkMatch(anchorExtent, doc, relations, aceDoc);
        ArrayList syntaxArgumentValue = EventSyntacticPattern.match(this, anchorExtent.start(), doc, relations, aceDoc);
        ArrayList argumentValue = null;
        if (chunkArgumentValue == null && syntaxArgumentValue == null) {
            return null;
        }
        if (chunkArgumentValue != null && this.chunkMatchScore >= this.syntaxMatchScore) {
            argumentValue = chunkArgumentValue;
            this.matchScore = this.chunkMatchScore;
        } else {
            argumentValue = syntaxArgumentValue;
            this.matchScore = this.syntaxMatchScore;
        }
        Span extent = this.computeExtent(anchorExtent, argumentValue);
        AceEvent event = new AceEvent("id", this.eventType, this.eventSubtype);
        AceEventMention emention = new AceEventMention("id", extent, anchorExtent, doc.text());
        event.addMention(emention);
        for (int iarg = 0; iarg < argumentValue.size(); ++iarg) {
            AceEventMentionArgument marg = (AceEventMentionArgument)argumentValue.get(iarg);
            this.addEventMentionArgument(emention, marg.role, marg.value);
            AceEventArgumentValue entity = marg.value.getParent();
            this.addEventArgument(event, marg.role, entity);
        }
        return event;
    }

    private void addEventMentionArgument(AceEventMention emention, String role, AceMention mention) {
        ArrayList<AceEventMentionArgument> arglist = emention.arguments;
        for (int i = 0; i < arglist.size(); ++i) {
            AceEventMentionArgument arg = arglist.get(i);
            if (!arg.role.equals(role) || !arg.value.equals(mention)) continue;
            return;
        }
        emention.addArgument(new AceEventMentionArgument(mention, role));
    }

    private void addEventArgument(AceEvent event, String role, AceEventArgumentValue entity) {
        ArrayList<AceEventArgument> arglist = event.arguments;
        for (int i = 0; i < arglist.size(); ++i) {
            AceEventArgument arg = arglist.get(i);
            if (!arg.role.equals(role) || !arg.value.equals(entity)) continue;
            return;
        }
        event.addArgument(new AceEventArgument(entity, role));
    }

    public int getMatchScore() {
        return this.matchScore;
    }

    private ArrayList chunkMatch(Span anchorExtent, Document doc, SyntacticRelationSet relations, AceDocument aceDoc) {
        String role;
        int irole;
        AceMention m;
        String role0;
        ArrayList roleSet;
        AcePatternNode node;
        ChunkPath path;
        boolean matchedNode;
        int inode;
        AceEventAnchor anchorMention;
        ArrayList<AceEventMentionArgument> argumentValue = new ArrayList<AceEventMentionArgument>();
        this.chunkMatchScore = 0;
        if (this.paths == null) {
            return null;
        }
        if (!useChunkPatterns) {
            return null;
        }
        Annotation sentence = EventPattern.containingSentence(doc, anchorExtent);
        if (sentence == null) {
            logger.warn("** Cannot find sentence containing trigger");
            return null;
        }
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        LinkedList<AceMention> mentionsBeforeTrigger = new LinkedList<AceMention>();
        LinkedList<AceMention> mentionsAfterTrigger = new LinkedList<AceMention>();
        for (int i = 0; i < mentions.size(); ++i) {
            AceMention m2 = mentions.get(i);
            if (!m2.getJetHead().within(sentence.span())) continue;
            if (m2.getJetHead().start() < anchorExtent.start()) {
                mentionsBeforeTrigger.add(m2);
                continue;
            }
            mentionsAfterTrigger.add(m2);
        }
        int nodeScore = 0;
        AceMention lastM = anchorMention = new AceEventAnchor(anchorExtent, anchorExtent, doc.text(anchorExtent).trim(), doc);
        for (inode = this.anchorPosn - 1; inode >= 0; --inode) {
            matchedNode = false;
            path = this.paths.get(inode);
            node = (AcePatternNode)this.nodes.get(inode);
            roleSet = this.roles[inode];
            role0 = (String)roleSet.get(0);
            while (!mentionsBeforeTrigger.isEmpty()) {
                m = (AceMention)mentionsBeforeTrigger.removeLast();
                nodeScore = node.match(m);
                if (nodeScore <= this.MIN_MATCH_SCORE || !AceEventArgument.isValid(this.eventSubtype, role0, m) || !new ChunkPath(doc, m, lastM).equals(path)) continue;
                this.chunkMatchScore += nodeScore;
                for (irole = 0; irole < roleSet.size(); ++irole) {
                    role = (String)roleSet.get(irole);
                    argumentValue.add(new AceEventMentionArgument(m, role));
                }
                lastM = m;
                matchedNode = true;
                break;
            }
            if (!matchedNode) break;
        }
        lastM = anchorMention;
        for (inode = this.anchorPosn; inode < this.nodes.size() - 1; ++inode) {
            matchedNode = false;
            path = this.paths.get(inode);
            node = (AcePatternNode)this.nodes.get(inode + 1);
            roleSet = this.roles[inode + 1];
            role0 = (String)roleSet.get(0);
            while (!mentionsAfterTrigger.isEmpty()) {
                m = (AceMention)mentionsAfterTrigger.removeFirst();
                nodeScore = node.match(m);
                if (nodeScore <= this.MIN_MATCH_SCORE || !AceEventArgument.isValid(this.eventSubtype, role0, m) || !new ChunkPath(doc, lastM, m).equals(path)) continue;
                this.chunkMatchScore += nodeScore;
                for (irole = 0; irole < roleSet.size(); ++irole) {
                    role = (String)roleSet.get(irole);
                    argumentValue.add(new AceEventMentionArgument(m, role));
                }
                lastM = m;
                matchedNode = true;
                break;
            }
            if (!matchedNode) break;
        }
        return argumentValue;
    }

    private static int nonNullLength(Object[] ray) {
        if (ray == null) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < ray.length; ++i) {
            if (ray[i] == null) continue;
            ++count;
        }
        return count;
    }

    static Annotation containingSentence(Document doc, Span span) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        Annotation sentence = null;
        for (int i = 0; i < sentences.size(); ++i) {
            Annotation s = sentences.get(i);
            if (!span.within(s.span())) continue;
            sentence = s;
            break;
        }
        return sentence;
    }

    private Span computeExtent(Span anchorExtent, ArrayList argumentValue) {
        int min = anchorExtent.start();
        int max = anchorExtent.end();
        if (argumentValue != null) {
            for (int i = 0; i < argumentValue.size(); ++i) {
                AceEventMentionArgument arg = (AceEventMentionArgument)argumentValue.get(i);
                AceMention mention = arg.value;
                min = Math.min(min, mention.jetExtent.start());
                max = Math.max(max, mention.jetExtent.end());
            }
        }
        return new Span(min, max);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (i == this.anchorPosn) {
                result.append("$" + this.anchor + "$");
            } else {
                result.append(this.nodes.get(i));
            }
            result.append(" ");
            if (i >= this.nodes.size() - 1) continue;
            result.append("[" + (this.paths == null ? "" : this.paths.get(i)) + "]");
            result.append(" ");
        }
        if (this.syntax != null) {
            result.append(" " + this.syntax);
        }
        result.append(" --> " + this.eventType + ":" + this.eventSubtype);
        if (this.eventArgs.size() > 0) {
            result.append("( ");
            for (int j = 0; j < this.eventArgs.size(); ++j) {
                result.append(this.eventArgs.get(j) + " ");
            }
            result.append(")");
        }
        if (this.evaluation.successCount > 0 || this.evaluation.failureCount > 0) {
            result.append("\n  " + this.evaluation);
        }
        return result.toString();
    }

    public void write(PrintWriter pw) {
        int i;
        pw.println("$eventPattern");
        pw.println("$type " + this.patternType);
        pw.println("$nodes");
        for (i = 0; i < this.nodes.size(); ++i) {
            AcePatternNode apn = (AcePatternNode)this.nodes.get(i);
            if (apn == null) {
                pw.println("anchor=" + this.anchor);
                continue;
            }
            apn.write(pw);
        }
        if (this.paths != null) {
            pw.println("$paths");
            for (i = 0; i < this.paths.size(); ++i) {
                this.paths.get(i).write(pw);
            }
        }
        if (this.syntax != null) {
            pw.println("$syntax");
            this.syntax.write(pw);
        }
        pw.println("$event");
        pw.println(this.eventType + ":" + this.eventSubtype);
        for (i = 0; i < this.eventArgs.size(); ++i) {
            ((EventPatternArgument)this.eventArgs.get(i)).write(pw);
        }
        pw.println("$eval");
        this.evaluation.write(pw);
        pw.println("$endPattern");
    }

    public EventPattern(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.equals("$endPattern")) {
            if (line.startsWith("$type ")) {
                this.patternType = line.substring(6).trim();
                line = reader.readLine();
                continue;
            }
            if (line.equals("$nodes")) {
                line = reader.readLine();
                while (line != null && !line.startsWith("$")) {
                    if (line.startsWith("anchor=")) {
                        this.anchor = line.substring(7);
                        this.anchorPosn = this.nodes.size();
                        this.nodes.add(null);
                    } else {
                        AcePatternNode apn = new AcePatternNode(line);
                        if (apn.type != null) {
                            this.nodes.add(apn);
                        }
                    }
                    line = reader.readLine();
                }
                this.roles = new ArrayList[this.nodes.size()];
                for (int i = 0; i < this.roles.length; ++i) {
                    this.roles[i] = new ArrayList();
                }
                continue;
            }
            if (line.equals("$paths")) {
                this.paths = new ArrayList();
                line = reader.readLine();
                while (line != null && !line.startsWith("$")) {
                    ChunkPath cp = new ChunkPath(line);
                    this.paths.add(cp);
                    line = reader.readLine();
                }
                continue;
            }
            if (line.equals("$syntax")) {
                line = reader.readLine();
                this.syntax = new SyntacticRelationSet();
                while (line != null && !line.startsWith("$")) {
                    SyntacticRelation sr = new SyntacticRelation(line);
                    this.syntax.add(sr);
                    line = reader.readLine();
                }
                continue;
            }
            if (line.equals("$event")) {
                line = reader.readLine();
                String[] fields = line.split(":");
                this.eventType = fields[0];
                this.eventSubtype = fields[1];
                line = reader.readLine();
                this.eventArgs = new ArrayList();
                while (line != null && !line.startsWith("$")) {
                    EventPatternArgument epa = new EventPatternArgument(line);
                    this.eventArgs.add(epa);
                    this.roles[(Integer)epa.source - 1].add(epa.role);
                    line = reader.readLine();
                }
                continue;
            }
            if (line.equals("$eval")) {
                this.evaluation = new PatternEvaluation(reader);
                line = reader.readLine();
                continue;
            }
            logger.warn("EventPattern:  invalid input line " + line);
            line = reader.readLine();
        }
        if (this.paths != null && this.paths.size() == 0) {
            this.paths = null;
        }
    }

    public static void main(String[] args) throws IOException {
        JetTest.initializeFromConfig("props/ace use parses.properties");
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        AceDocument.ace2005 = true;
        String docId = "nw/XIN_ENG_20030423.0011";
        String xmlFile = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/nw/XIN_ENG_20030423.0011.apf.xml";
        String textFile = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/nw/XIN_ENG_20030423.0011.sgm";
        ExternalDocument doc = new ExternalDocument("sgml", textFile);
        doc.setAllTags(true);
        doc.open();
        Resolve.trace = false;
        Control.processDocument(doc, null, false, 0);
        AceDocument aceDoc = new AceDocument(textFile, xmlFile);
        SyntacticRelationSet relations = new SyntacticRelationSet();
        relations.readRelations(triplesDir + docId + triplesSuffix);
        ArrayList<AceEvent> events = aceDoc.events;
        for (int i = 0; i < events.size(); ++i) {
            AceEvent event = events.get(i);
            ArrayList<AceEventMention> mentions = event.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEventMention m = mentions.get(j);
                System.out.println("Processing mention " + m.id + " = " + m.text);
                EventPattern chunkEvPat = new EventPattern("CHUNK", doc, relations, event, m);
                System.out.println("chunkEvPat = " + chunkEvPat);
                Span anchorExtent = m.anchorJetExtent;
                String anchor = EventPattern.normalizedAnchor(anchorExtent, m.anchorText, doc, relations);
                AceEvent builtEvent = chunkEvPat.match(anchorExtent, anchor, doc, relations, aceDoc);
                if (builtEvent == null) {
                    System.out.println("**** match failed ****");
                } else {
                    System.out.println("Original      event " + m);
                    System.out.println("Reconstructed " + builtEvent);
                }
                EventPattern synEvPat = new EventPattern("SYNTAX", doc, relations, event, m);
                System.out.println("synEvPat = " + synEvPat);
                builtEvent = synEvPat.match(anchorExtent, anchor, doc, relations, aceDoc);
                if (builtEvent == null) {
                    System.out.println("**** match failed ****");
                } else {
                    System.out.println("Original      event " + m);
                    System.out.println("Reconstructed " + builtEvent);
                }
                EventPattern paEvPat = new EventPattern("PA", doc, relations, event, m);
                System.out.println("paEvPat = " + paEvPat);
                builtEvent = paEvPat.match(anchorExtent, anchor, doc, relations, aceDoc);
                if (builtEvent == null) {
                    System.out.println("**** match failed ****");
                    continue;
                }
                System.out.println("Original      event " + m);
                System.out.println("Reconstructed " + builtEvent);
            }
        }
    }
}

