/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceValue;
import edu.nyu.jet.aceJet.AceValueMention;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAceValues {
    static final Logger logger = LoggerFactory.getLogger(FindAceValues.class);
    static TreeMap<String, String> valueTypeMap = new TreeMap();

    public static void readTypeDict() {
        String fileName = JetTest.getConfigFile("Ace.Value.fileName");
        if (fileName != null) {
            FindAceValues.readTypeDict(fileName);
        } else {
            logger.error("No Ace.Value.fileName specified in config file");
        }
    }

    public static void readTypeDict(String dictFile) {
        logger.info("Loading type dictionary {}", (Object)dictFile);
        valueTypeMap = new TreeMap();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(dictFile));
            String type = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '=') {
                    type = line.substring(1);
                    continue;
                }
                String[] tokens = line.split(" ");
                if (type == null) {
                    logger.warn("Error in loading value dictionary.");
                    logger.warn("No type specified for {}", (Object)tokens[0]);
                    continue;
                }
                valueTypeMap.put(tokens[0], type);
            }
            logger.info("Value dictionary loaded.");
        }
        catch (IOException e) {
            logger.error("Unable to load value dictionary due to exception: {}", (Throwable)e);
        }
    }

    public static boolean isDictLoaded() {
        return !valueTypeMap.isEmpty();
    }

    public static String getTypeSubtype(Document doc, Annotation mention) {
        String paHead = SynFun.getHead(doc, mention).toLowerCase();
        Annotation headC = Resolve.getHeadC(mention);
        String headWord = Resolve.normalizeName(doc.text(headC).trim());
        String name = SynFun.getName(doc, mention);
        String cat = (String)headC.get("cat");
        if (name != null) {
            if (paHead.equals("email")) {
                return "Contact-Info:E-Mail";
            }
            if (paHead.equals("url")) {
                return "Contact-Info:URL";
            }
            return "OTHER";
        }
        if (cat.equals("pro") || cat.equals("det") || cat.equals("q")) {
            return "OTHER";
        }
        String typeSubtype = FindAceValues.lookUpValueType(headWord);
        if (typeSubtype != null) {
            return typeSubtype.intern();
        }
        typeSubtype = FindAceValues.lookUpValueType(paHead);
        if (typeSubtype != null) {
            return typeSubtype.intern();
        }
        return "OTHER";
    }

    static String lookUpValueType(String word) {
        return valueTypeMap.get(word.toLowerCase());
    }

    public static String bareType(String typeSubtype) {
        int p = typeSubtype.indexOf(58);
        if (p > 0) {
            return typeSubtype.substring(0, p);
        }
        return typeSubtype;
    }

    static String subtype(String typeSubtype) {
        int p = typeSubtype.indexOf(58);
        if (p > 0) {
            return typeSubtype.substring(p + 1);
        }
        return "";
    }

    public static void buildAceValues(Document doc, String docId, AceDocument aceDoc) {
        int valueCount = 0;
        String docText = doc.text();
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        if (entities != null) {
            for (int ientity = 0; ientity < entities.size(); ++ientity) {
                Annotation entity = entities.get(ientity);
                Vector mentions = (Vector)entity.get("mentions");
                for (int imention = 0; imention < mentions.size(); ++imention) {
                    Annotation mention = (Annotation)mentions.get(imention);
                    String typeSubtype = FindAceValues.getTypeSubtype(doc, mention);
                    if (typeSubtype.equals("OTHER")) continue;
                    String valueId = docId + "-V" + ++valueCount;
                    FindAceValues.buildAceValue(valueId, typeSubtype, mention.span(), aceDoc, docText);
                }
            }
        }
        logger.info("Built {} values.", (Object)aceDoc.values.size());
    }

    public static void buildAceValue(String id, String typeSubtype, Span extent, AceDocument aceDoc, String fileText) {
        String type = FindAceValues.bareType(typeSubtype);
        String subtype = FindAceValues.subtype(typeSubtype);
        AceValueMention mention = new AceValueMention(id + "-1", extent, fileText);
        AceValue value = new AceValue(id, type, subtype);
        value.addMention(mention);
        aceDoc.addValue(value);
    }

    public static void pruneAceValues(AceDocument aceDoc) {
        ArrayList<AceValue> values = aceDoc.values;
        HashSet<AceValue> referencedValues = new HashSet<AceValue>();
        for (AceEvent event : aceDoc.events) {
            for (AceEventMention evMention : event.mentions) {
                for (AceEventMentionArgument arg : evMention.arguments) {
                    if (!(arg.value instanceof AceValueMention)) continue;
                    AceValue value = ((AceValueMention)arg.value).value;
                    referencedValues.add(value);
                }
            }
        }
        for (AceValue value : values) {
            String type = value.type;
            if (!type.equals("Numeric") && !type.equals("Contact-Info")) continue;
            referencedValues.add(value);
        }
        values.retainAll(referencedValues);
        logger.info("{} values remain after pruning.", (Object)aceDoc.values.size());
    }
}

