/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.lex.Lexicon;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class Gazetteer {
    HashMap<String, String> nationalityToCountry = new HashMap();
    HashMap<String, String> nationalToCountry = new HashMap();
    HashMap<String, String> nationalsToCountry = new HashMap();
    HashMap<String, String> aliasToCountry = new HashMap();
    HashMap<String, String> capitalToCountry = new HashMap();
    HashMap<String, String> locations = new HashMap();
    LineNumberReader reader;
    boolean monocase = false;
    HashMap<String, String> monocaseMap = new HashMap();

    public void load() throws IOException {
        String fileName = JetTest.getConfigFile("Gazetteer.fileName");
        if (fileName != null) {
            this.load(fileName);
        } else {
            System.err.println("Gazetteer.load:  no file name specified in config file");
        }
    }

    public void load(String fileName) throws IOException {
        System.err.println("Loading gazetteer.");
        this.reader = new LineNumberReader(new FileReader(fileName));
        StreamTokenizer tok = new StreamTokenizer(this.reader);
        while (tok.nextToken() != -1) {
            this.readGazetteerEntry(tok);
        }
        for (String location : this.locations.keySet()) {
            Lexicon.addEntry(Gazetteer.splitAtWS(location), new FeatureSet("TYPE", "GPE", "SUBTYPE", this.aceSubtype(this.locations.get(location))), "onoma");
        }
    }

    private String aceSubtype(String subtype) {
        if (subtype.equals("continent")) {
            return "Continent";
        }
        if (subtype.equals("region")) {
            return "Region-International";
        }
        if (subtype.equals("country")) {
            return "Nation";
        }
        if (subtype.equals("usstate")) {
            return "State-or-Province";
        }
        return "Population-Center";
    }

    private void readGazetteerEntry(StreamTokenizer tok) throws IOException {
        String primaryName = "";
        String type = "";
        String nationality = "";
        String national = "";
        String nationals = "";
        do {
            int ln;
            if (tok.ttype != -3) {
                ln = this.reader.getLineNumber();
                System.err.println("*** Syntax error in gazetteer: " + tok);
                return;
            }
            String key = tok.sval.intern();
            if (tok.nextToken() != 34) {
                ln = this.reader.getLineNumber();
                System.err.println("*** Syntax error in gazetteer, line" + ln);
                return;
            }
            String value = tok.sval;
            this.monocaseMap.put(value.toLowerCase(), value);
            if (key == "country" || key == "continent" || key == "region" || key == "usstate" || key == "city") {
                primaryName = value;
                type = key;
                this.locations.put(value, key);
                continue;
            }
            if (key == "nationality") {
                nationality = value;
                this.nationalityToCountry.put(nationality, primaryName);
                continue;
            }
            if (key == "aka") {
                this.aliasToCountry.put(value, primaryName);
                this.locations.put(value, type);
                continue;
            }
            if (key == "national") {
                national = value;
                continue;
            }
            if (key == "nationals") {
                nationals = value;
                continue;
            }
            if (key == "capital") {
                this.capitalToCountry.put(value, primaryName);
                this.locations.put(value, "city");
                continue;
            }
            ln = this.reader.getLineNumber();
            System.err.println("*** Syntax error in gazetteer, line" + ln);
        } while (tok.nextToken() != 59);
        if (type == "country" && nationality != "") {
            if (national == "") {
                national = nationality;
            }
            if (nationals == "") {
                nationals = national + "s";
                this.monocaseMap.put(nationals.toLowerCase(), nationals);
            }
            this.nationalToCountry.put(national, primaryName);
            this.nationalsToCountry.put(nationals, primaryName);
        }
    }

    public void setMonocase(boolean monocase) {
        this.monocase = monocase;
    }

    public boolean isNationality(String[] s) {
        return this.nationalityToCountry.containsKey(this.foldArg(s));
    }

    public String[] nationalityToCountry(String[] s) {
        return Gazetteer.splitAtWS(this.nationalityToCountry.get(this.foldArg(s)));
    }

    public boolean isNational(String[] s) {
        return this.nationalToCountry.containsKey(this.foldArg(s));
    }

    public String[] nationalToCountry(String[] s) {
        return Gazetteer.splitAtWS(this.nationalToCountry.get(this.foldArg(s)));
    }

    public boolean isNationals(String[] s) {
        return this.nationalsToCountry.containsKey(this.foldArg(s));
    }

    public String[] nationalsToCountry(String[] s) {
        return Gazetteer.splitAtWS(this.nationalsToCountry.get(this.foldArg(s)));
    }

    public String[] capitalToCountry(String[] s) {
        return Gazetteer.splitAtWS(this.capitalToCountry.get(this.foldArg(s)));
    }

    public boolean isLocation(String[] s) {
        return this.locations.containsKey(this.foldArg(s));
    }

    public boolean isCountry(String[] s) {
        return this.locations.get(this.foldArg(s)) == "country";
    }

    public boolean isCountryAlias(String[] s) {
        return this.aliasToCountry.containsKey(this.foldArg(s));
    }

    public boolean isState(String[] s) {
        return this.locations.get(this.foldArg(s)) == "usstate";
    }

    public boolean isRegionOrContinent(String[] s) {
        String type = this.locations.get(this.foldArg(s));
        return type == "region" || type == "continent";
    }

    public String[] canonicalCountryName(String[] s) {
        return Gazetteer.splitAtWS(this.aliasToCountry.get(this.foldArg(s)));
    }

    public static void main(String[] args) throws IOException {
        Gazetteer g = new Gazetteer();
        g.load("data/loc.dict");
        g.setMonocase(true);
        System.out.println(g.isNationals(new String[]{"palestinians"}));
    }

    public static String[] splitAtWS(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s);
        int length = st.countTokens();
        String[] splitS = new String[length];
        for (int i = 0; i < length; ++i) {
            splitS[i] = st.nextToken();
        }
        return splitS;
    }

    private String foldArg(String[] s) {
        String x = Resolve.concat(s);
        if (this.monocase && this.monocaseMap.containsKey(x)) {
            x = this.monocaseMap.get(x);
        }
        return x;
    }

    public String locationType(Document doc, String locationName) {
        String lastToken;
        String[] locationTokens = locationName.split(" ");
        if (this.isCountry(locationTokens) || this.isNationality(locationTokens)) {
            return "country";
        }
        if (this.isState(locationTokens)) {
            return "stateorprovince";
        }
        if (this.capitalToCountry(locationTokens) != null) {
            return "city";
        }
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        if (entities != null) {
            block0: for (Annotation entity : entities) {
                String[] entityName = (String[])entity.get("name");
                if (entityName == null || entityName.length != locationTokens.length) continue;
                for (int i = 0; i < entityName.length; ++i) {
                    if (!entityName[i].equals(locationTokens[i])) continue block0;
                }
                Vector mentions = (Vector)entity.get("mentions");
                for (Annotation mention : mentions) {
                    Object pax = mention.get("pa");
                    if (!(pax instanceof FeatureSet)) continue;
                    FeatureSet pa = (FeatureSet)pax;
                    String hd = (String)pa.get("head");
                    if (hd.equals("city")) {
                        return "city";
                    }
                    if (hd.equals("town")) {
                        return "city";
                    }
                    if (hd.equals("village")) {
                        return "city";
                    }
                    if (hd.equals("port")) {
                        return "city";
                    }
                    if (hd.equals("province")) {
                        return "stateorprovince";
                    }
                    if (hd.equals("state")) {
                        return "stateorprovince";
                    }
                    if (hd.equals("county")) {
                        return "stateorprovince";
                    }
                    if (!hd.equals("district")) continue;
                    return "stateorprovince";
                }
            }
        }
        if ((lastToken = locationTokens[locationTokens.length - 1]).equals("Province")) {
            return "stateorprovince";
        }
        if (lastToken.equals("District")) {
            return "stateorprovince";
        }
        if (lastToken.equals("County")) {
            return "stateorprovince";
        }
        if (lastToken.equals("State")) {
            return "stateorprovince";
        }
        if (lastToken.equals("City")) {
            return "city";
        }
        return null;
    }
}

