/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternEvaluation {
    int successCount = 0;
    int failureCount = 0;
    HashMap<String, Integer> successWithArg = new HashMap();
    HashMap<String, Integer> failureWithArg = new HashMap();

    public PatternEvaluation() {
    }

    public void recordSuccess(ArrayList arguments) {
        this.recordSuccess(arguments, 1);
    }

    public void recordSuccess(ArrayList arguments, int count) {
        this.successCount += count;
        for (int iarg = 0; iarg < arguments.size(); ++iarg) {
            AceEventMentionArgument arg = (AceEventMentionArgument)arguments.get(iarg);
            String role = arg.role;
            this.increment(this.successWithArg, role, count);
        }
    }

    public void recordFailure(ArrayList arguments) {
        this.recordFailure(arguments, 1);
    }

    public void recordFailure(ArrayList arguments, int count) {
        this.failureCount += count;
        for (int iarg = 0; iarg < arguments.size(); ++iarg) {
            AceEventMentionArgument arg = (AceEventMentionArgument)arguments.get(iarg);
            String role = arg.role;
            this.increment(this.failureWithArg, role, count);
        }
    }

    private void increment(HashMap<String, Integer> h, String key, int incr) {
        int count = h.get(key) == null ? 0 : h.get(key);
        h.put(key, new Integer(count + incr));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.successCount + "+/" + this.failureCount + "-(");
        TreeSet<String> roles = new TreeSet<String>(this.successWithArg.keySet());
        Set<String> failureRoles = this.failureWithArg.keySet();
        roles.addAll(failureRoles);
        for (String role : roles) {
            int s = this.successWithArg.get(role) == null ? 0 : this.successWithArg.get(role);
            int f = this.failureWithArg.get(role) == null ? 0 : this.failureWithArg.get(role);
            buf.append(" " + role + ":" + s + "+/" + f + "-");
        }
        buf.append(")");
        return buf.toString();
    }

    public int test(ArrayList arguments, double ratio) {
        int score = -1;
        if ((double)this.successCount >= (double)this.failureCount * ratio) {
            score = 50 * this.successCount / (this.successCount + this.failureCount + 10);
        }
        for (int iarg = 0; iarg < arguments.size(); ++iarg) {
            int f;
            AceEventArgument arg = (AceEventArgument)arguments.get(iarg);
            String role = arg.role;
            int s = this.successWithArg.get(role) == null ? 0 : this.successWithArg.get(role);
            int n = f = this.failureWithArg.get(role) == null ? 0 : this.failureWithArg.get(role);
            if (!((double)s >= (double)f * ratio)) continue;
            score = Math.max(score, 50 * s / (s + f + 10));
        }
        return score;
    }

    public void write(PrintWriter pw) {
        pw.println("noArg | " + this.successCount + " | " + this.failureCount);
        TreeSet<String> roles = new TreeSet<String>(this.successWithArg.keySet());
        Set<String> failureRoles = this.failureWithArg.keySet();
        roles.addAll(failureRoles);
        for (String role : roles) {
            int s = this.successWithArg.get(role) == null ? 0 : this.successWithArg.get(role);
            int f = this.failureWithArg.get(role) == null ? 0 : this.failureWithArg.get(role);
            pw.println(role + " | " + s + " | " + f);
        }
        pw.println("$evalEnd");
    }

    public PatternEvaluation(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.equals("$evalEnd")) {
            String[] field = line.split(" \\| ");
            if (field.length != 3) {
                System.err.println("PatternEvaluation:  invalid input " + line);
                return;
            }
            String role = field[0];
            try {
                int s = Integer.parseInt(field[1]);
                int f = Integer.parseInt(field[2]);
                if (role.equals("noArg")) {
                    this.successCount = s;
                    this.failureCount = f;
                } else {
                    this.successWithArg.put(role, new Integer(s));
                    this.failureWithArg.put(role, new Integer(f));
                }
            }
            catch (NumberFormatException e) {
                System.err.println("PatternEvaluation:  invalid input " + line);
                return;
            }
            line = reader.readLine();
        }
    }
}

