/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.StatParser;
import edu.nyu.jet.pat.NewAnnotationAction;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SpecialZoner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PerfectAce
extends Resolve {
    static HashMap entityMentionMap = null;

    public static void main(String[] args) throws IOException {
        String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String ACEdir = home + "ACE 05/V4/";
        String parseCollection = ACEdir + "perfect-parses/un-sgm.txt";
        PerfectAce.parseCollection(parseCollection);
    }

    private static void parseCollection(String collection) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace perfect just parser.properties");
        Pat.trace = false;
        DocumentCollection col = new DocumentCollection(collection);
        col.open();
        block0: for (int docCount = 0; docCount < col.size(); ++docCount) {
            ExternalDocument doc = col.get(docCount);
            System.out.println("\nProcessing document " + docCount + ": " + doc.fileName());
            doc.setAllTags(true);
            doc.open();
            Vector<Annotation> anns = doc.annotationsOfType("sentence");
            if (anns != null) {
                for (int i = 0; i < anns.size(); ++i) {
                    Annotation sentAnn = anns.get(i);
                    if (sentAnn.get("parse") == null) continue;
                    System.out.println("\nSkipping document " + doc.fileName() + ", already parsed");
                    continue block0;
                }
            }
            SpecialZoner.findSpecialZones(doc);
            String textFile = doc.fullFileName();
            String apfFile = textFile.replaceAll(".sgm", ".apf.xml");
            AceDocument aceDoc = new AceDocument(textFile, apfFile);
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, docCount == -1, docCount);
            PerfectAce.createPerfectNames(doc, aceDoc);
            Vector<Annotation> sentences = doc.annotationsOfType("sentence");
            for (int i = 0; i < sentences.size(); ++i) {
                Annotation sentence = sentences.get(i);
                StatParser.parse(doc, sentence.span());
            }
            doc.removeAnnotationsOfType("ENAMEX");
            StatParser.clearInputAnnotations(doc);
            doc.removeAnnotationsOfType("tagger");
            doc.save();
        }
    }

    static void createPerfectNames(ExternalDocument doc, AceDocument aceDoc) {
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            ArrayList<AceEntityMention> perfectMentions = entity.mentions;
            for (int j = 0; j < perfectMentions.size(); ++j) {
                int start;
                Annotation enamex;
                Vector<Annotation> enamexes;
                AceEntityMention mention = perfectMentions.get(j);
                LearnRelations.doc = doc;
                Span head = mention.jetHead;
                String type = mention.type;
                if (type.equals("PRE") && (enamexes = doc.annotationsAt(head.start(), "ENAMEX")) != null && (enamex = enamexes.get(0)).end() == head.end()) {
                    type = "NAM";
                }
                if (!type.equals("NAM")) continue;
                int posn = start = head.start();
                int end = head.end();
                while (posn < end) {
                    Annotation token = doc.tokenAt(posn);
                    if (token == null) {
                        posn = end;
                        continue;
                    }
                    posn = token.end();
                }
                Span span = new Span(start, posn);
                NewAnnotationAction.hideAnnotations(doc, "constit", span);
                NewAnnotationAction.hideAnnotations(doc, "token", span);
                Annotation name = new Annotation("constit", span, new FeatureSet("cat", "name", "pa", new FeatureSet("head", entity.type.toLowerCase(), "number", "singular")));
                doc.addAnnotation(name);
            }
        }
    }

    static void buildEntityMentionMap(ExternalDocument doc, AceDocument aceDoc) {
        entityMentionMap = new HashMap();
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            ArrayList<AceEntityMention> perfectMentions = entity.mentions;
            for (int j = 0; j < perfectMentions.size(); ++j) {
                AceEntityMention mention = perfectMentions.get(j);
                LearnRelations.doc = doc;
                Span head = mention.jetHead;
                entityMentionMap.put(new Integer(head.start()), new Object[]{entity, mention});
            }
        }
    }

    public static boolean validMention(Document doc, Annotation head, String cat) {
        if (entityMentionMap == null) {
            System.err.println("*** PerfectAce.validMention:  no entityMentionMap");
            return true;
        }
        if (cat == "title") {
            Annotation[] tokens = Tokenizer.gatherTokens(doc, head.span());
            for (int i = 0; i < tokens.length; ++i) {
                Integer start = new Integer(tokens[i].start());
                if (entityMentionMap.get(start) == null) continue;
                return true;
            }
            return false;
        }
        Integer start = new Integer(head.start());
        boolean valid = entityMentionMap.get(start) != null;
        return valid;
    }

    public static String getEntityID(Annotation head) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer start = new Integer(head.start());
        Object[] entityMention = (Object[])entityMentionMap.get(start);
        if (entityMention == null) {
            return null;
        }
        AceEntity entity = (AceEntity)entityMention[0];
        return entity.id;
    }

    public static String getTypeSubtype(Annotation head) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer start = new Integer(head.start());
        Object[] entityMention = (Object[])entityMentionMap.get(start);
        if (entityMention == null) {
            System.err.println("*** No entityMentionMap entry for " + start);
            return "OTHER";
        }
        AceEntity entity = (AceEntity)entityMention[0];
        if (entity.subtype != null && !entity.subtype.equals("")) {
            return entity.type + ":" + entity.subtype;
        }
        return entity.type;
    }

    static String getMentionRole(Annotation head) {
        if (entityMentionMap == null) {
            return "GPE";
        }
        Integer start = new Integer(head.start());
        Object[] entityMention = (Object[])entityMentionMap.get(start);
        if (entityMention == null) {
            return "GPE";
        }
        AceEntityMention mention = (AceEntityMention)entityMention[1];
        return mention.role;
    }

    static String getMentionType(Annotation head) {
        if (entityMentionMap == null) {
            return "NOMINAL";
        }
        Integer start = new Integer(head.start());
        Object[] entityMention = (Object[])entityMentionMap.get(start);
        if (entityMention == null) {
            return "NOMINAL";
        }
        AceEntityMention mention = (AceEntityMention)entityMention[1];
        return mention.type;
    }
}

