/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.aceJet.RelationInstance;
import edu.nyu.jet.aceJet.RelationMention;
import java.util.ArrayList;
import java.util.StringTokenizer;

class RelationPattern
extends RelationInstance
implements Comparable {
    String string;
    String mentionType1 = "   ";
    String mentionSubtype1 = "";
    String mentionHead1 = "";
    String mentionType2 = "   ";
    String mentionSubtype2 = "";
    String mentionHead2 = "";

    RelationPattern(String line) {
        String constit;
        this.string = line;
        this.linearLink = new ArrayList();
        StringTokenizer st = new StringTokenizer(line);
        String reverseFlag = st.nextToken();
        boolean reversed = false;
        if (reverseFlag.startsWith("arg1-")) {
            reversed = false;
        } else if (reverseFlag.startsWith("arg2-")) {
            reversed = true;
        } else {
            System.err.println("Unexpected value of reverseFlag: " + reverseFlag);
        }
        this.mentionType1 = st.nextToken();
        this.mentionSubtype1 = st.nextToken();
        if (this.mentionSubtype1.equals("*")) {
            this.mentionSubtype1 = "";
        }
        this.mentionHead1 = st.nextToken();
        if (!st.nextToken().equals("[")) {
            System.err.println("Cannot find [ in line: " + line);
            return;
        }
        this.syntacticLink = st.nextToken();
        if (!st.nextToken().equals(":")) {
            System.err.println("Cannot find : in line: " + line);
            return;
        }
        while (!(constit = st.nextToken()).equals("]")) {
            if (RelationPattern.noiseToken(constit)) continue;
            this.linearLink.add(constit);
        }
        this.mentionType2 = st.nextToken();
        this.mentionSubtype2 = st.nextToken();
        if (this.mentionSubtype2.equals("*")) {
            this.mentionSubtype2 = "";
        }
        this.mentionHead2 = st.nextToken();
        if (!st.nextToken().equals("-->")) {
            System.err.println("Cannot find --> in line: " + line);
            return;
        }
        this.relationType = st.nextToken();
        if (st.hasMoreTokens()) {
            this.relationSubtype = st.nextToken();
        }
        if (reversed) {
            this.relationType = this.relationType + "-1";
        }
    }

    static boolean noiseToken(String token) {
        return token.startsWith("adv(") || token.startsWith("timex(") || token.startsWith("q(") || token.equals("'") || token.equals("''") || token.equals("\"");
    }

    String getType1() {
        return this.mentionType1;
    }

    String getType2() {
        return this.mentionType2;
    }

    int distance(RelationInstance ri) {
        boolean linearMatch;
        boolean arg2Match;
        String head2;
        String head1;
        String subtype2;
        String subtype1;
        String type2;
        String type1;
        if (ri instanceof RelationPattern) {
            RelationPattern rp = (RelationPattern)ri;
            type1 = rp.mentionType1;
            type2 = rp.mentionType2;
            subtype1 = rp.mentionSubtype1;
            subtype2 = rp.mentionSubtype2;
            head1 = rp.mentionHead1;
            head2 = rp.mentionHead2;
        } else {
            RelationMention rm = (RelationMention)ri;
            type1 = rm.mention1.entity.type;
            type2 = rm.mention2.entity.type;
            subtype1 = rm.mention1.entity.subtype;
            subtype2 = rm.mention2.entity.subtype;
            head1 = LearnRelations.getHead(rm.mention1);
            head2 = LearnRelations.getHead(rm.mention2);
        }
        if (this.mentionType1.length() < 3 || this.mentionType2.length() < 3 || type1.length() < 3 || type2.length() < 3) {
            return 3;
        }
        boolean wildCard1 = this.mentionHead1.equals("0") || head1.equals("0");
        boolean wildCard2 = this.mentionHead2.equals("0") || head2.equals("0");
        boolean exactHeadMatch1 = this.mentionHead1.equals(head1) && !wildCard1;
        boolean exactHeadMatch2 = this.mentionHead2.equals(head2) && !wildCard2;
        boolean typeMatch1 = this.mentionType1.substring(0, 3).equals(type1.substring(0, 3)) || exactHeadMatch1;
        boolean subtypeMatch1 = this.mentionSubtype1.equals(subtype1) || exactHeadMatch1;
        boolean typeMatch2 = this.mentionType2.substring(0, 3).equals(type2.substring(0, 3)) || exactHeadMatch2;
        boolean subtypeMatch2 = this.mentionSubtype2.equals(subtype2) || exactHeadMatch2;
        boolean arg1Match = this.mentionHead1.equals(head1) || wildCard1;
        boolean bl = arg2Match = this.mentionHead2.equals(head2) || wildCard2;
        if (this.syntacticLink.equals("of") && !arg1Match) {
            return 100;
        }
        boolean syntaxMatch = this.syntacticLink.equals(ri.syntacticLink) && !this.syntacticLink.equals("0");
        boolean prepMatch = RelationPattern.matchingRelations(this.syntacticLink, ri.syntacticLink);
        boolean bl2 = linearMatch = this.linearLink.size() == ri.linearLink.size() && (this.linearLink.size() == 0 || !this.linearLink.get(0).equals("0"));
        if (linearMatch) {
            for (int i = 0; i < this.linearLink.size(); ++i) {
                if (this.linearLink.get(i).equals(ri.linearLink.get(i))) continue;
                linearMatch = false;
            }
        }
        if (!(syntaxMatch | prepMatch | linearMatch)) {
            return 100;
        }
        int dist = 0;
        if (!typeMatch1) {
            dist += 20;
        }
        if (!typeMatch2) {
            dist += 20;
        }
        if (!syntaxMatch) {
            ++dist;
        }
        if (!prepMatch) {
            ++dist;
        }
        if (!linearMatch) {
            dist += 2;
        }
        if (!arg1Match) {
            dist += 8;
        }
        if (!arg2Match) {
            dist += 8;
        }
        return dist;
    }

    public int compareTo(Object x) {
        RelationPattern rp = (RelationPattern)x;
        return this.string.compareTo(rp.string);
    }

    static String prepositionOfLink(String syntacticLink) {
        int dash;
        if ((syntacticLink.startsWith("s-") || syntacticLink.startsWith("o-")) && (dash = syntacticLink.lastIndexOf(45)) > 0) {
            return syntacticLink.substring(dash + 1);
        }
        return null;
    }

    static boolean matchingRelations(String syntacticLink1, String syntacticLink2) {
        String prep1 = RelationPattern.prepositionOfLink(syntacticLink1);
        String prep2 = RelationPattern.prepositionOfLink(syntacticLink2);
        return prep1 != null && prep1.equals(prep2);
    }
}

