/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.aceJet.AceRelationMention;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RelationScorer {
    static int correctEntityMentions = 0;
    static int missingEntityMentions = 0;
    static int spuriousEntityMentions = 0;
    static int correctRelationMentions = 0;
    static int missingRelationMentions = 0;
    static int spuriousRelationMentions = 0;
    static int relationMentionTypeErrors = 0;
    static Map<String, String> entityAlignment = new HashMap<String, String>();
    static Set<String> symmetricTypes = new HashSet<String>();

    public static void main(String[] args) throws IOException {
        String docName;
        if (args.length < 7 || args.length > 8) {
            System.err.println("RelationScorer requires 7 or 8 arguments:");
            System.err.println("    docList sourceDir sourceExt responseDir responseExt keyDir keyExt [year]");
            System.exit(1);
        }
        String docListFile = args[0];
        String sourceDir = args[1];
        String sourceExt = args[2];
        String responseDir = args[3];
        String responseExt = args[4];
        String keyDir = args[5];
        String keyExt = args[6];
        if (args.length == 8) {
            Ace.setAceYear(args[7]);
        }
        BufferedReader reader = new BufferedReader(new FileReader(docListFile));
        int docCount = 0;
        while ((docName = reader.readLine()) != null) {
            System.out.println("\nScoring document " + ++docCount + ": " + docName);
            String sourceFile = sourceDir + "/" + docName + "." + sourceExt;
            String responseFile = responseDir + "/" + docName + "." + responseExt;
            String keyFile = keyDir + "/" + docName + "." + keyExt;
            RelationScorer.scoreDocument(sourceFile, responseFile, keyFile);
        }
        RelationScorer.reportScores();
    }

    static void scoreDocument(String sourceFile, String responseFile, String keyFile) {
        ExternalDocument doc = new ExternalDocument("sgml", sourceFile);
        doc.setAllTags(true);
        doc.open();
        AceDocument response = new AceDocument(sourceFile, responseFile);
        AceDocument key = new AceDocument(sourceFile, keyFile);
        HashSet<AceEntityMention> keyEntityMentions = new HashSet<AceEntityMention>();
        for (AceEntity entity : key.entities) {
            keyEntityMentions.addAll(entity.mentions);
        }
        HashMap<Integer, AceEntityMention> keyEntityMentionMap = new HashMap<Integer, AceEntityMention>();
        for (AceEntityMention mention : keyEntityMentions) {
            int end = mention.head.end();
            if (doc.charAt(end) == '.') {
                --end;
            }
            keyEntityMentionMap.put(end, mention);
        }
        for (AceEntity entity : response.entities) {
            for (AceEntityMention mention : entity.mentions) {
                AceEntityMention keyMention;
                int end = mention.head.end();
                if (doc.charAt(end) == '.') {
                    --end;
                }
                if ((keyMention = (AceEntityMention)keyEntityMentionMap.get(end)) == null) {
                    System.out.println("Spurious mention " + mention.text);
                    ++spuriousEntityMentions;
                    continue;
                }
                if (!keyEntityMentions.contains(keyMention)) {
                    System.out.println("Spurious mention (duplicate head) " + mention.text);
                    ++spuriousEntityMentions;
                    continue;
                }
                entityAlignment.put(mention.id, keyMention.id);
                keyEntityMentions.remove(keyMention);
                ++correctEntityMentions;
            }
        }
        for (AceEntityMention keyMention : keyEntityMentions) {
            System.out.println("Missing mention " + keyMention.text + " [head = " + keyMention.headText + "]");
            ++missingEntityMentions;
        }
        HashSet keyRelationMentions = new HashSet();
        for (AceRelation relation : key.relations) {
            keyRelationMentions.addAll(relation.mentions);
        }
        for (AceRelation relation : response.relations) {
            block7: for (AceRelationMention mention : relation.mentions) {
                String type = mention.relation.type;
                String subtype = mention.relation.subtype;
                String responseArg1 = mention.arg1.id;
                String mappedArg1 = entityAlignment.get(responseArg1);
                String responseArg2 = mention.arg2.id;
                String mappedArg2 = entityAlignment.get(responseArg2);
                for (AceRelationMention keyMention : keyRelationMentions) {
                    String keyArg1 = keyMention.arg1.id;
                    String keyArg2 = keyMention.arg2.id;
                    String keyType = keyMention.relation.type;
                    String keySubtype = keyMention.relation.subtype;
                    boolean symmetric = symmetricTypes.contains(keyType + ":" + keySubtype);
                    if ((!keyArg1.equals(mappedArg1) || !keyArg2.equals(mappedArg2)) && (!symmetric || !keyArg1.equals(mappedArg2) || !keyArg2.equals(mappedArg1))) continue;
                    if (type.equals(keyType)) {
                        ++correctRelationMentions;
                    } else {
                        ++relationMentionTypeErrors;
                    }
                    keyRelationMentions.remove(keyMention);
                    continue block7;
                }
                ++spuriousRelationMentions;
                System.out.println("Spurious relation (" + type + ":" + subtype + "): " + mention.text);
            }
        }
        for (AceRelationMention keyMention : keyRelationMentions) {
            String type = keyMention.relation.type;
            String subtype = keyMention.relation.subtype;
            System.out.println("Missing relation (" + type + ":" + subtype + "): " + keyMention.text);
            ++missingRelationMentions;
        }
    }

    static void reportScores() {
        System.out.println();
        System.out.println("Correct entity mentions:    " + correctEntityMentions);
        System.out.println("Missing entity mentions:    " + missingEntityMentions);
        System.out.println("Spurious entity mentions:   " + spuriousEntityMentions);
        System.out.println();
        System.out.println("Correct relation mentions:  " + correctRelationMentions);
        System.out.println("Relation mention type errs: " + relationMentionTypeErrors);
        System.out.println("Missing relation mentions:  " + missingRelationMentions);
        System.out.println("Spurious relation mentions: " + spuriousRelationMentions);
        int responseCount = correctRelationMentions + relationMentionTypeErrors + spuriousRelationMentions;
        int keyCount = correctRelationMentions + relationMentionTypeErrors + missingRelationMentions;
        float precision = (float)correctRelationMentions / (float)responseCount;
        float recall = (float)correctRelationMentions / (float)keyCount;
        float f = 2.0f * precision * recall / (precision + recall);
        System.out.println();
        System.out.printf("Precision = %4.1f\n", Float.valueOf(100.0f * precision));
        System.out.printf("Recall =    %4.1f\n", Float.valueOf(100.0f * recall));
        System.out.printf("F =         %4.1f\n", Float.valueOf(100.0f * f));
    }

    static {
        symmetricTypes.add("PHYS:Near");
        symmetricTypes.add("PER-SOC:Business");
        symmetricTypes.add("PER-SOC:Family");
        symmetricTypes.add("PER-SOC:Other");
        symmetricTypes.add("PER-SOC:Lasting-Personal");
        symmetricTypes.add("EMP-ORG:Partner");
        symmetricTypes.add("EMP-ORG:Other");
        symmetricTypes.add("OTHER-AFF:Other");
    }
}

