/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.EventTagger;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.DataStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;

public class TrainEventTagger {
    static final String eventFeatureFileName = "eventFeatureFile.log";
    static final String eventModelFileName = "eventModel.log";
    static final String corefFeatureFileName = "corefFeatureFile.log";
    static final String corefModelFileName = "corefModel.log";
    static final String argFeatureFileName = "argFeatureFile.log";
    static final String argModelFileName = "argModel.log";
    static final String roleFeatureFileName = "roleFeatureFile.log";
    static final String roleModelFileName = "roleModel.log";
    static final String argFeatureHalfFileName = "argFeatureHalfFile.log";
    static final String argModelHalfFileName = "argModelHalf.log";
    static final String roleFeatureHalfFileName = "roleFeatureHalfFile.log";
    static final String roleModelHalfFileName = "roleModelHalf.log";
    static final String eventPatternFile = "eventPatterns.log";
    static final String eventReportFile = "eventPatternReport.log";
    static final String halfEventPatternFile = "eventPatternsHalf.log";
    static String fileListTrain;
    static String docDir;
    static String outputDir;
    static boolean processOnlyOddDocuments;
    static boolean processOnlyEvenDocuments;

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE event tagger training procedure.");
        if (args.length != 4 && args.length != 6) {
            System.out.println("EventTagger must take 4 or 6 arguments:");
            System.out.println("    properties filelist documentDir outputDir [glarfDir glarfSuffix]");
            System.exit(1);
        }
        String propertyFile = args[0];
        fileListTrain = args[1];
        docDir = args[2];
        if (!docDir.endsWith("/")) {
            docDir = docDir + "/";
        }
        EventTagger.docDir = docDir;
        outputDir = args[3];
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        EventTagger.glarfDir = null;
        if (args.length == 6) {
            EventTagger.glarfDir = args[4];
            if (!EventTagger.glarfDir.endsWith("/")) {
                EventTagger.glarfDir = EventTagger.glarfDir + "/";
            }
            EventTagger.triplesSuffix = args[5];
            EventTagger.usePA = true;
        }
        JetTest.initializeFromConfig(propertyFile);
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        EventTagger et = new EventTagger();
        et.argFeatureWriter = new PrintStream(new FileOutputStream(outputDir + argFeatureFileName));
        et.roleFeatureWriter = new PrintStream(new FileOutputStream(outputDir + roleFeatureFileName));
        System.out.println("\n===== Acquiring patterns and training argument model. =====\n");
        TrainEventTagger.train(et, fileListTrain, 0);
        TrainEventTagger.train(et, fileListTrain, 1);
        et.report(outputDir + eventReportFile);
        et.argFeatureWriter.close();
        et.roleFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + argFeatureFileName, outputDir + argModelFileName);
        TrainEventTagger.buildClassifierModel(outputDir + roleFeatureFileName, outputDir + roleModelFileName);
        et.save(outputDir + eventPatternFile);
        System.out.println("\n===== Training event model. =====\n");
        TrainEventTagger.trainEventModel(et);
        System.out.println("\n===== Training coreference model. =====\n");
        TrainEventTagger.trainCorefModel(et);
    }

    private static void trainEventModel(EventTagger et) throws IOException {
        processOnlyOddDocuments = true;
        et.argFeatureWriter = new PrintStream(new FileOutputStream(outputDir + argFeatureHalfFileName));
        et.roleFeatureWriter = new PrintStream(new FileOutputStream(outputDir + roleFeatureHalfFileName));
        TrainEventTagger.train(et, fileListTrain, 0);
        TrainEventTagger.train(et, fileListTrain, 1);
        et.save(outputDir + halfEventPatternFile);
        et.argFeatureWriter.close();
        et.roleFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + argFeatureHalfFileName, outputDir + argModelHalfFileName);
        TrainEventTagger.buildClassifierModel(outputDir + roleFeatureHalfFileName, outputDir + roleModelHalfFileName);
        EventTagger.argModel = EventTagger.loadClassifierModel(outputDir + argModelFileName);
        EventTagger.roleModel = EventTagger.loadClassifierModel(outputDir + roleModelFileName);
        et.eventFeatureWriter = new PrintStream(new FileOutputStream(outputDir + eventFeatureFileName));
        processOnlyOddDocuments = false;
        TrainEventTagger.train(et, fileListTrain, 2);
        et.eventFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + eventFeatureFileName, outputDir + eventModelFileName);
    }

    private static void trainCorefModel(EventTagger et) throws IOException {
        EventTagger.argModel = EventTagger.loadClassifierModel(outputDir + argModelHalfFileName);
        EventTagger.roleModel = EventTagger.loadClassifierModel(outputDir + roleModelHalfFileName);
        EventTagger.eventModel = EventTagger.loadClassifierModel(outputDir + eventModelFileName);
        et.load(outputDir + halfEventPatternFile);
        et.corefFeatureWriter = new PrintStream(new FileOutputStream(outputDir + corefFeatureFileName));
        processOnlyEvenDocuments = true;
        TrainEventTagger.train(et, fileListTrain, 3);
        et.corefFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + corefFeatureFileName, outputDir + corefModelFileName);
    }

    public static void train(EventTagger et, String fileList, int pass) throws IOException {
        String currentDocPath;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDocPath = reader.readLine()) != null) {
            if (processOnlyOddDocuments && ++docCount % 2 == 0 || processOnlyEvenDocuments && docCount % 2 == 1) continue;
            System.out.println("\nProcessing file " + currentDocPath);
            String textFile = docDir + currentDocPath + ".sgm";
            String xmlFile = docDir + currentDocPath + ".apf.xml";
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            doc.stretchAll();
            Resolve.ACE = true;
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, false, 0);
            AceDocument aceDoc = new AceDocument(textFile, xmlFile);
            if (pass == 0) {
                et.acquirePatterns(doc, aceDoc, currentDocPath);
                continue;
            }
            if (pass == 1) {
                et.evaluatePatterns(doc, aceDoc, currentDocPath);
                continue;
            }
            if (pass == 2) {
                et.trainEventModel(doc, aceDoc, currentDocPath);
                continue;
            }
            et.trainCorefModel(doc, aceDoc, currentDocPath);
        }
        reader.close();
    }

    private static void buildClassifierModel(String featureFileName, String modelFileName) {
        boolean USE_SMOOTHING = false;
        boolean PRINT_MESSAGES = true;
        double SMOOTHING_OBSERVATION = 0.1;
        try {
            FileReader datafr = new FileReader(new File(featureFileName));
            BasicEventStream es = new BasicEventStream((DataStream)new PlainTextByLineDataStream((Reader)datafr));
            GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
            GISModel model = GIS.trainModel((EventStream)es, (int)100, (int)4, (boolean)USE_SMOOTHING, (boolean)PRINT_MESSAGES);
            File outputFile = new File(modelFileName);
            SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter((AbstractModel)model, outputFile);
            writer.persist();
        }
        catch (Exception e) {
            System.err.print("Unable to create model due to exception: ");
            System.err.println(e);
        }
    }

    static {
        processOnlyOddDocuments = false;
        processOnlyEvenDocuments = false;
    }
}

