/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import edu.nyu.jet.chunk.TreeBasedChunker;
import edu.nyu.jet.parser.DependencyAnalyzer;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkDependencyAnalyzer {
    private TreeBasedChunker chunker = new TreeBasedChunker();
    private DependencyAnalyzer dependencyAnalyzer = new DependencyAnalyzer();

    public void analyzeChunkDependency(Document doc, ParseTreeNode tree) {
        this.chunker.chunk(doc, tree);
        this.dependencyAnalyzer.resolveTerminalDependency(tree);
        List<Annotation> terminals = ChunkDependencyAnalyzer.getHeadMarkedTerminals(tree);
        Vector<Annotation> chunks = doc.annotationsOfType("chunk", tree.ann.span());
        Map<Annotation, Annotation> terminalToAnnotationMap = ChunkDependencyAnalyzer.makeTerminalToChunkMap(chunks, terminals);
        for (Annotation term : terminals) {
            Annotation head;
            if (term.get("isHead") != Boolean.TRUE || (head = (Annotation)term.get("dep")) == null) continue;
            Annotation chunk = terminalToAnnotationMap.get(term);
            Annotation depChunk = terminalToAnnotationMap.get(head);
            if (chunk == null || depChunk == null || chunk == depChunk) continue;
            chunk.put("dep", depChunk);
        }
        block1: for (Annotation chunk : chunks) {
            Annotation depChunk = (Annotation)chunk.get("dep");
            if (depChunk != null || ChunkDependencyAnalyzer.hasHeadTerminal(doc, chunk)) continue;
            for (Annotation term : doc.annotationsOfType("constit", chunk.span())) {
                Annotation dep = (Annotation)term.get("dep");
                if (dep == null || dep == term || (depChunk = terminalToAnnotationMap.get(dep)) == null) continue;
                chunk.put("dep", depChunk);
                continue block1;
            }
        }
        ChunkDependencyAnalyzer.removeHeadMark(terminals);
    }

    private static Map<Annotation, Annotation> makeTerminalToChunkMap(List<Annotation> chunks, List<Annotation> terminals) {
        IdentityHashMap<Annotation, Annotation> terminalToChunkMap = new IdentityHashMap<Annotation, Annotation>();
        block0: for (Annotation term : terminals) {
            for (Annotation chunk : chunks) {
                if (!term.span().within(chunk.span())) continue;
                terminalToChunkMap.put(term, chunk);
                continue block0;
            }
        }
        return terminalToChunkMap;
    }

    private static List<Annotation> getHeadMarkedTerminals(ParseTreeNode tree) {
        if (tree.children == null) {
            return Collections.singletonList(tree.ann);
        }
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        int i = 1;
        for (ParseTreeNode child : tree.children) {
            if (child.children != null) {
                list.addAll(ChunkDependencyAnalyzer.getHeadMarkedTerminals(child));
            } else {
                Annotation terminal = child.ann;
                boolean isHead = i == tree.head;
                terminal.put("isHead", isHead);
                list.add(terminal);
            }
            ++i;
        }
        return list;
    }

    private static void removeHeadMark(List<Annotation> terminals) {
        for (Annotation terminal : terminals) {
            terminal.remove("isHead");
        }
    }

    private static boolean hasHeadTerminal(Document doc, Annotation chunk) {
        Vector<Annotation> nodes = doc.annotationsOfType("constit", chunk.span());
        if (nodes == null) {
            return false;
        }
        for (Annotation node : nodes) {
            if (node.get("isHead") != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }
}

