/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import edu.nyu.jet.Console;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.File;
import java.util.Vector;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public class Chunker {
    public static GISModel model = null;
    static Annotation[] tokens;
    static int tokenCount;
    static int jetTokenCount;
    static String[] pos;
    static String[] word;
    static String[] tag;
    static int[] position;
    static boolean trace;

    public static void chunk(Document doc, Span span) {
        int i;
        tokens = Tokenizer.gatherTokens(doc, span);
        tokenCount = tokens.length;
        if (tokenCount == 0) {
            return;
        }
        pos = new String[tokenCount];
        word = new String[tokenCount];
        position = new int[tokenCount];
        int itoken = 0;
        for (i = 0; i < tokenCount; ++i) {
            int posn;
            Chunker.position[itoken] = posn = tokens[i].span().start();
            Chunker.pos[itoken] = Chunker.getPosAt(doc, posn);
            Chunker.word[itoken] = doc.text(tokens[i]).trim();
            if (itoken >= 2 && doc.text(tokens[i - 1]).equals("-")) {
                Chunker.pos[itoken - 2] = "JJ";
                Chunker.word[itoken - 2] = word[itoken - 2] + word[itoken - 1] + word[itoken];
                itoken -= 2;
            }
            ++itoken;
        }
        jetTokenCount = itoken;
        tag = new String[jetTokenCount];
        for (i = 0; i < jetTokenCount; ++i) {
            String[] features = Chunker.chunkFeatures(i);
            Chunker.tag[i] = model.getBestOutcome(model.eval(features)).intern();
            if (i != 0 && tag[i - 1] != "O" || tag[i] != "B") continue;
            Chunker.tag[i] = "I";
        }
        int chunkStart = -1;
        int nameEnd = -1;
        for (int i2 = 0; i2 < jetTokenCount; ++i2) {
            Vector<Annotation> nameAnns;
            int posn = position[i2];
            if (nameEnd == posn) {
                nameEnd = -1;
            }
            if (chunkStart >= 0 && tag[i2] == "O" | tag[i2] == "B" && nameEnd < 0) {
                Annotation ann = new Annotation("ng", new Span(chunkStart, posn), null);
                doc.addAnnotation(ann);
                if (trace) {
                    Console.println("Annotate " + doc.text(ann) + " as " + ann);
                }
                chunkStart = -1;
            }
            if (nameEnd < 0 && (nameAnns = doc.annotationsAt(posn, "ENAMEX")) != null && nameAnns.size() > 0) {
                Annotation nameAnn = nameAnns.get(0);
                nameEnd = nameAnn.span().end();
            }
            if (chunkStart >= 0 || tag[i2] != "B" && tag[i2] != "I" && nameEnd <= 0) continue;
            chunkStart = posn;
        }
        if (chunkStart >= 0) {
            int lastTokenEnd = tokens[tokenCount - 1].span().end();
            Annotation ann = new Annotation("ng", new Span(chunkStart, lastTokenEnd), null);
            doc.addAnnotation(ann);
            if (trace) {
                Console.println("Annotate " + doc.text(ann) + " as " + ann);
            }
        }
    }

    private static String getPosAt(Document doc, int posn) {
        Vector<Annotation> v = doc.annotationsAt(posn, "tagger");
        if (v == null || v.size() == 0) {
            return "";
        }
        Annotation taggerAnn = v.get(0);
        return (String)taggerAnn.get("cat");
    }

    private static String[] chunkFeatures(int i) {
        String[] features = new String[]{"prevPOS=" + (i > 0 ? pos[i - 1] : ""), "currPOS=" + pos[i], "nextPOS=" + (i < jetTokenCount - 1 ? pos[i + 1] : ""), i < jetTokenCount - 2 ? "POS012=" + pos[i] + ":" + pos[i + 1] + ":" + pos[i + 2] : (i < jetTokenCount - 2 ? "POS012=" + pos[i] + ":" + pos[i + 1] + ":" : "POS012=" + pos[i] + "::"), "prevTag=" + (i > 0 ? tag[i - 1] : ""), "currWord=" + word[i], "W-1W0=" + (i > 0 ? word[i - 1] : "") + ":" + word[i], "W0W1=" + word[i] + ":" + (i < jetTokenCount - 1 ? word[i + 1] : "")};
        return features;
    }

    public static void loadModel() {
        String modelFileName = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/Chunk/chunk model.txt";
        Chunker.loadModel(modelFileName);
    }

    public static void loadModel(String modelFileName) {
        try {
            model = (GISModel)new SuffixSensitiveGISModelReader(new File(modelFileName)).getModel();
            System.err.println("Chunker model loaded from " + modelFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Chunker.loadModel();
        JetTest.initializeFromConfig("ME Chunk.properties");
        new Console();
    }

    static {
        trace = false;
    }
}

