/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import java.io.IOException;
import opennlp.maxent.GISModel;
import opennlp.model.Context;
import opennlp.model.DataIndexer;
import opennlp.model.EvalParameters;
import opennlp.model.EventStream;
import opennlp.model.MutableContext;
import opennlp.model.OnePassDataIndexer;
import opennlp.model.Prior;
import opennlp.model.UniformPrior;

public class GISTrainer {
    private boolean useSimpleSmoothing = false;
    private boolean useSlackParameter = false;
    private boolean useGaussianSmoothing = false;
    private double sigma = 2.0;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numUniqueEvents;
    private int numPreds;
    private int numOutcomes;
    private int[][] contexts;
    private float[][] values;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private int[] predicateCounts;
    private int cutoff;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] observedExpects;
    private MutableContext[] params;
    private MutableContext[] modelExpects;
    private Prior prior;
    private double cfObservedExpect;
    private double CFMOD;
    private final double NEAR_ZERO = 0.01;
    private final double LLThreshold = 1.0E-4;
    double[] modelDistribution;
    int[] numfeats;
    EvalParameters evalParams;

    GISTrainer() {
    }

    GISTrainer(boolean printMessages) {
        this();
        this.printMessages = printMessages;
    }

    public void setSmoothing(boolean smooth) {
        this.useSimpleSmoothing = smooth;
    }

    public void setSmoothingObservation(double timesSeen) {
        this._smoothingObservation = timesSeen;
    }

    public void setGaussianSigma(double sigmaValue) {
        this.useGaussianSmoothing = true;
        this.sigma = sigmaValue;
    }

    public GISModel trainModel(EventStream eventStream, int iterations, int cutoff) throws IOException {
        return this.trainModel(iterations, (DataIndexer)new OnePassDataIndexer(eventStream, cutoff), cutoff);
    }

    public GISModel trainModel(int iterations, DataIndexer di, int cutoff) {
        return this.trainModel(iterations, di, (Prior)new UniformPrior(), cutoff);
    }

    public GISModel trainModel(int iterations, DataIndexer di, Prior modelPrior, int cutoff) {
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = di.getContexts();
        this.values = di.getValues();
        this.cutoff = cutoff;
        this.predicateCounts = di.getPredCounts();
        this.numTimesEventsSeen = di.getNumTimesEventsSeen();
        this.numUniqueEvents = this.contexts.length;
        this.prior = modelPrior;
        int correctionConstant = 1;
        for (int ci = 0; ci < this.contexts.length; ++ci) {
            if (this.values == null || this.values[ci] == null) {
                if (this.contexts[ci].length <= correctionConstant) continue;
                correctionConstant = this.contexts[ci].length;
                continue;
            }
            float cl = this.values[ci][0];
            for (int vi = 1; vi < this.values[ci].length; ++vi) {
                cl += this.values[ci][vi];
            }
            if (!(cl > (float)correctionConstant)) continue;
            correctionConstant = (int)Math.ceil(cl);
        }
        this.display("done.\n");
        this.outcomeLabels = di.getOutcomeLabels();
        this.outcomeList = di.getOutcomeList();
        this.numOutcomes = this.outcomeLabels.length;
        this.predLabels = di.getPredLabels();
        this.prior.setLabels(this.outcomeLabels, this.predLabels);
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numUniqueEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        float[][] predCount = new float[this.numPreds][this.numOutcomes];
        for (int ti = 0; ti < this.numUniqueEvents; ++ti) {
            for (int j = 0; j < this.contexts[ti].length; ++j) {
                if (this.values != null && this.values[ti] != null) {
                    float[] fArray = predCount[this.contexts[ti][j]];
                    int n = this.outcomeList[ti];
                    fArray[n] = fArray[n] + (float)this.numTimesEventsSeen[ti] * this.values[ti][j];
                    continue;
                }
                float[] fArray = predCount[this.contexts[ti][j]];
                int n = this.outcomeList[ti];
                fArray[n] = fArray[n] + (float)this.numTimesEventsSeen[ti];
            }
        }
        di = null;
        double smoothingObservation = this._smoothingObservation;
        this.params = new MutableContext[this.numPreds];
        this.modelExpects = new MutableContext[this.numPreds];
        this.observedExpects = new MutableContext[this.numPreds];
        this.evalParams = new EvalParameters((Context[])this.params, 0.0, 1.0, this.numOutcomes);
        int[] activeOutcomes = new int[this.numOutcomes];
        int[] allOutcomesPattern = new int[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            allOutcomesPattern[oi] = oi;
        }
        int numActiveOutcomes = 0;
        for (int pi = 0; pi < this.numPreds; ++pi) {
            int aoi;
            int[] outcomePattern;
            numActiveOutcomes = 0;
            if (this.useSimpleSmoothing) {
                numActiveOutcomes = this.numOutcomes;
                outcomePattern = allOutcomesPattern;
            } else {
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    if (!(predCount[pi][oi] > 0.0f) || this.predicateCounts[pi] < cutoff) continue;
                    activeOutcomes[numActiveOutcomes] = oi;
                    ++numActiveOutcomes;
                }
                if (numActiveOutcomes == this.numOutcomes) {
                    outcomePattern = allOutcomesPattern;
                } else {
                    outcomePattern = new int[numActiveOutcomes];
                    for (aoi = 0; aoi < numActiveOutcomes; ++aoi) {
                        outcomePattern[aoi] = activeOutcomes[aoi];
                    }
                }
            }
            this.params[pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            this.modelExpects[pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            this.observedExpects[pi] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            for (aoi = 0; aoi < numActiveOutcomes; ++aoi) {
                int oi = outcomePattern[aoi];
                this.params[pi].setParameter(aoi, 0.0);
                this.modelExpects[pi].setParameter(aoi, 0.0);
                if (predCount[pi][oi] > 0.0f) {
                    this.observedExpects[pi].setParameter(aoi, (double)predCount[pi][oi]);
                    continue;
                }
                if (!this.useSimpleSmoothing) continue;
                this.observedExpects[pi].setParameter(aoi, smoothingObservation);
            }
        }
        if (this.useSlackParameter) {
            int cfvalSum = 0;
            for (int ti = 0; ti < this.numUniqueEvents; ++ti) {
                for (int j = 0; j < this.contexts[ti].length; ++j) {
                    int pi = this.contexts[ti][j];
                    if (this.modelExpects[pi].contains(this.outcomeList[ti])) continue;
                    cfvalSum += this.numTimesEventsSeen[ti];
                }
                cfvalSum += (correctionConstant - this.contexts[ti].length) * this.numTimesEventsSeen[ti];
            }
            this.cfObservedExpect = cfvalSum == 0 ? Math.log(0.01) : Math.log(cfvalSum);
        }
        predCount = null;
        this.display("...done.\n");
        this.modelDistribution = new double[this.numOutcomes];
        this.numfeats = new int[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations, correctionConstant);
        return new GISModel((Context[])this.params, this.predLabels, this.outcomeLabels, 1, this.evalParams.getCorrectionParam());
    }

    private void findParameters(int iterations, int correctionConstant) {
        double prevLL = 0.0;
        double currLL = 0.0;
        this.display("Performing " + iterations + " iterations.\n");
        for (int i = 1; i <= iterations; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            currLL = this.nextIteration(correctionConstant);
            if (i > 1) {
                if (prevLL > currLL) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (currLL - prevLL < 1.0E-4) break;
            }
            prevLL = currLL;
        }
        this.observedExpects = null;
        this.modelExpects = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private double gaussianUpdate(int predicate, int oid, int n, double correctionConstant) {
        double param = this.params[predicate].getParameters()[oid];
        double x = 0.0;
        double x0 = 0.0;
        double modelValue = this.modelExpects[predicate].getParameters()[oid];
        double observedValue = this.observedExpects[predicate].getParameters()[oid];
        for (int i = 0; i < 50; ++i) {
            double tmp = modelValue * Math.exp(correctionConstant * x0);
            double f = tmp + (param + x0) / this.sigma - observedValue;
            double fp = tmp * correctionConstant + 1.0 / this.sigma;
            if (fp == 0.0) break;
            x = x0 - f / fp;
            if (Math.abs(x - x0) < 1.0E-6) {
                x0 = x;
                break;
            }
            x0 = x;
        }
        return x0;
    }

    private double nextIteration(int correctionConstant) {
        int aoi;
        int[] activeOutcomes;
        double loglikelihood = 0.0;
        this.CFMOD = 0.0;
        int numEvents = 0;
        int numCorrect = 0;
        for (int ei = 0; ei < this.numUniqueEvents; ++ei) {
            if (this.values != null) {
                this.prior.logPrior(this.modelDistribution, this.contexts[ei], this.values[ei]);
                GISModel.eval((int[])this.contexts[ei], (float[])this.values[ei], (double[])this.modelDistribution, (EvalParameters)this.evalParams);
            } else {
                this.prior.logPrior(this.modelDistribution, this.contexts[ei]);
                GISModel.eval((int[])this.contexts[ei], (double[])this.modelDistribution, (EvalParameters)this.evalParams);
            }
            for (int j = 0; j < this.contexts[ei].length; ++j) {
                int pi = this.contexts[ei][j];
                if (this.predicateCounts[pi] < this.cutoff) continue;
                activeOutcomes = this.modelExpects[pi].getOutcomes();
                for (aoi = 0; aoi < activeOutcomes.length; ++aoi) {
                    int oi = activeOutcomes[aoi];
                    if (this.values != null && this.values[ei] != null) {
                        this.modelExpects[pi].updateParameter(aoi, this.modelDistribution[oi] * (double)this.values[ei][j] * (double)this.numTimesEventsSeen[ei]);
                        continue;
                    }
                    this.modelExpects[pi].updateParameter(aoi, this.modelDistribution[oi] * (double)this.numTimesEventsSeen[ei]);
                }
                if (!this.useSlackParameter) continue;
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    if (this.modelExpects[pi].contains(oi)) continue;
                    this.CFMOD += this.modelDistribution[oi] * (double)this.numTimesEventsSeen[ei];
                }
            }
            if (this.useSlackParameter) {
                this.CFMOD += (double)((correctionConstant - this.contexts[ei].length) * this.numTimesEventsSeen[ei]);
            }
            loglikelihood += Math.log(this.modelDistribution[this.outcomeList[ei]]) * (double)this.numTimesEventsSeen[ei];
            numEvents += this.numTimesEventsSeen[ei];
            if (!this.printMessages) continue;
            int max = 0;
            for (int oi = 1; oi < this.numOutcomes; ++oi) {
                if (!(this.modelDistribution[oi] > this.modelDistribution[max])) continue;
                max = oi;
            }
            if (max != this.outcomeList[ei]) continue;
            numCorrect += this.numTimesEventsSeen[ei];
        }
        this.display(".");
        for (int pi = 0; pi < this.numPreds; ++pi) {
            double[] observed = this.observedExpects[pi].getParameters();
            double[] model = this.modelExpects[pi].getParameters();
            activeOutcomes = this.params[pi].getOutcomes();
            for (aoi = 0; aoi < activeOutcomes.length; ++aoi) {
                if (this.useGaussianSmoothing) {
                    this.params[pi].updateParameter(aoi, this.gaussianUpdate(pi, aoi, numEvents, correctionConstant));
                } else {
                    if (model[aoi] == 0.0) {
                        System.err.println("Model expects == 0 for " + this.predLabels[pi] + " " + this.outcomeLabels[aoi]);
                    }
                    this.params[pi].updateParameter(aoi, (Math.log(observed[aoi]) - Math.log(model[aoi])) / (double)correctionConstant);
                }
                this.modelExpects[pi].setParameter(aoi, 0.0);
            }
        }
        if (this.CFMOD > 0.0 && this.useSlackParameter) {
            this.evalParams.setCorrectionParam(this.evalParams.getCorrectionParam() + (this.cfObservedExpect - Math.log(this.CFMOD)));
        }
        this.display(". loglikelihood=" + loglikelihood + "\t" + (double)numCorrect / (double)numEvents + "\n");
        return loglikelihood;
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }
}

