/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.lex.Lexicon;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Onoma {
    public static boolean loaded = false;

    public static void read(String fileName) throws IOException {
        String line;
        loaded = true;
        int n = 0;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        while ((line = reader.readLine()) != null) {
            String[] fields = line.split("\t");
            if (fields.length < 2 || fields.length > 3) {
                System.out.println("Invalid onoma line: " + line);
                continue;
            }
            String name = fields[0];
            String type = fields[1];
            String subtype = null;
            if (fields.length == 3) {
                subtype = fields[2];
            }
            Lexicon.clearEntry(Gazetteer.splitAtWS(name));
            Lexicon.addEntry(Gazetteer.splitAtWS(name), new FeatureSet("TYPE", type, "SUBTYPE", subtype), "onoma");
            ++n;
        }
        System.out.println("Onoma:  read " + n + " names.");
    }

    public static void tagDrugs(Document doc, Span span) {
    }

    public static void tagNames(Document doc, Span span) {
        int posn = span.start();
        while (posn < span.end()) {
            Vector<Annotation> onomas = doc.annotationsAt(posn, "onoma");
            if (onomas != null && onomas.size() > 0) {
                Annotation onoma = onomas.get(0);
                List<Annotation> anns = Onoma.containedNames(doc, span, onoma.span());
                if (anns != null) {
                    String type = (String)onoma.get("TYPE");
                    String subtype = (String)onoma.get("SUBTYPE");
                    doc.annotate("ENAMEX", onoma.span(), new FeatureSet("TYPE", type, "SUBTYPE", subtype));
                    for (Annotation ann : anns) {
                        doc.removeAnnotation(ann);
                    }
                }
                posn = onoma.end();
                continue;
            }
            Annotation token = doc.tokenAt(posn);
            if (token != null) {
                posn = token.end();
                continue;
            }
            return;
        }
    }

    private static List<Annotation> containedNames(Document doc, Span span, Span onomaSpan) {
        ArrayList<Annotation> anns = new ArrayList<Annotation>();
        int posn = span.start();
        while (posn < span.end()) {
            Vector<Annotation> enamexes = doc.annotationsAt(posn, "ENAMEX");
            if (enamexes != null && enamexes.size() > 0) {
                Annotation enamex = enamexes.get(0);
                Span enamexSpan = enamex.span();
                if (enamexSpan.end() > onomaSpan.start() && enamexSpan.start() < onomaSpan.end()) {
                    if (enamexSpan.within(onomaSpan)) {
                        anns.add(enamex);
                    } else {
                        return null;
                    }
                }
                posn = enamex.end();
                continue;
            }
            Annotation token = doc.tokenAt(posn);
            if (token != null) {
                posn = token.end();
                continue;
            }
            return null;
        }
        return anns;
    }
}

